/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.fulltext;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.esql.expression.predicate.fulltext.FullTextUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.MultiMatchQuery;

public class MultiMatchQueryPredicate
extends FullTextPredicate
implements TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MultiMatchQueryPredicate", MultiMatchQueryPredicate::new);
    private final String fieldString;
    private final Map<String, Float> fields;

    public MultiMatchQueryPredicate(Source source, String fieldString, String query, String options) {
        super(source, query, options, Collections.emptyList());
        this.fieldString = fieldString;
        this.fields = FullTextUtils.parseFields(fieldString, source);
    }

    MultiMatchQueryPredicate(StreamInput in) throws IOException {
        super(in);
        assert (super.children().isEmpty());
        this.fieldString = in.readString();
        this.fields = FullTextUtils.parseFields(this.fieldString, this.source());
    }

    protected NodeInfo<MultiMatchQueryPredicate> info() {
        return NodeInfo.create((Node)this, MultiMatchQueryPredicate::new, (Object)this.fieldString, (Object)this.query(), (Object)this.options());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public String fieldString() {
        return this.fieldString;
    }

    public Map<String, Float> fields() {
        return this.fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.fieldString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldString, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            MultiMatchQueryPredicate other = (MultiMatchQueryPredicate)obj;
            return Objects.equals(this.fieldString, other.fieldString);
        }
        return false;
    }

    public String getWriteableName() {
        return MultiMatchQueryPredicate.ENTRY.name;
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return TranslationAware.Translatable.YES;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new MultiMatchQuery(this.source(), this.query(), this.fields(), this);
    }
}

