/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Top
extends AggregateFunction
implements ToAggregator,
SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Top", Top::new);
    private static final String ORDER_ASC = "ASC";
    private static final String ORDER_DESC = "DESC";

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "ip", "keyword"}, description="Collects the top values for a field. Includes repeated values.", isAggregation=true, examples={@Example(file="stats_top", tag="top")})
    public Top(Source source, @Param(name="field", type={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text"}, description="The field to collect the top values for.") Expression field, @Param(name="limit", type={"integer"}, description="The maximum number of values to collect.") Expression limit, @Param(name="order", type={"keyword"}, description="The order to calculate the top values. Either `asc` or `desc`.") Expression order) {
        this(source, field, (Expression)Literal.TRUE, limit, order);
    }

    public Top(Source source, Expression field, Expression filter, Expression limit, Expression order) {
        super(source, field, filter, Arrays.asList(limit, order));
    }

    private Top(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)(in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? (Expression)in.readNamedWriteable(Expression.class) : Literal.TRUE), (List<? extends Expression>)(in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? in.readNamedWriteableCollectionAsList(Expression.class) : Arrays.asList((Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class))));
    }

    @Override
    protected void deprecatedWriteParams(StreamOutput out) throws IOException {
        List<? extends Expression> params = this.parameters();
        assert (params.size() == 2);
        out.writeNamedWriteable((NamedWriteable)params.get(0));
        out.writeNamedWriteable((NamedWriteable)params.get(1));
    }

    @Override
    public Top withFilter(Expression filter) {
        return new Top(this.source(), this.field(), filter, this.limitField(), this.orderField());
    }

    public String getWriteableName() {
        return Top.ENTRY.name;
    }

    Expression limitField() {
        return this.parameters().get(0);
    }

    Expression orderField() {
        return this.parameters().get(1);
    }

    private int limitValue() {
        return (Integer)this.limitField().fold(FoldContext.small());
    }

    private String orderRawValue() {
        return BytesRefs.toString((Object)this.orderField().fold(FoldContext.small()));
    }

    private boolean orderValue() {
        return this.orderRawValue().equalsIgnoreCase(ORDER_ASC);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution typeResolution = TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.BOOLEAN || dt == DataType.DATETIME || dt == DataType.IP || DataType.isString((DataType)dt) || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"boolean", "date", "ip", "string", "numeric except unsigned_long or counter types"}).and(TypeResolutions.isNotNullAndFoldable((Expression)this.limitField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isType((Expression)this.limitField(), dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"})).and(TypeResolutions.isNotNullAndFoldable((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(TypeResolutions.isString((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD));
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        int limit = this.limitValue();
        String order = this.orderRawValue();
        if (limit <= 0) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Limit must be greater than 0 in [{}], found [{}]", (Object[])new Object[]{this.sourceText(), limit}));
        }
        if (!order.equalsIgnoreCase(ORDER_ASC) && !order.equalsIgnoreCase(ORDER_DESC)) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        return this.field().dataType().noText();
    }

    protected NodeInfo<Top> info() {
        return NodeInfo.create((Node)this, Top::new, (Object)this.field(), (Object)this.filter(), (Object)this.limitField(), (Object)this.orderField());
    }

    public Top replaceChildren(List<Expression> newChildren) {
        return new Top(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new TopLongAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        if (type == DataType.INTEGER) {
            return new TopIntAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        if (type == DataType.DOUBLE) {
            return new TopDoubleAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        if (type == DataType.BOOLEAN) {
            return new TopBooleanAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        if (type == DataType.IP) {
            return new TopIpAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        if (DataType.isString((DataType)type)) {
            return new TopBytesRefAggregatorFunctionSupplier(this.limitValue(), this.orderValue());
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        if (this.limitValue() == 1) {
            if (this.orderValue()) {
                return new Min(s, this.field());
            }
            return new Max(s, this.field());
        }
        return null;
    }
}

