/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class StdDev
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StdDev", StdDev::new);

    @FunctionInfo(returnType={"double"}, description="The population standard deviation of a numeric field.", isAggregation=true, examples={@Example(file="stats", tag="stdev"), @Example(description="The expression can use inline functions. For example, to calculate the population standard deviation of each employee's maximum salary changes, first use `MV_MAX` on each row, and then use `STD_DEV` on the result", file="stats", tag="docsStatsStdDevNestedExpression")})
    public StdDev(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public StdDev(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private StdDev(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StdDev.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long or counter types"});
    }

    protected NodeInfo<StdDev> info() {
        return NodeInfo.create((Node)this, StdDev::new, (Object)this.field(), (Object)this.filter());
    }

    public StdDev replaceChildren(List<Expression> newChildren) {
        return new StdDev(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public StdDev withFilter(Expression filter) {
        return new StdDev(this.source(), this.field(), filter);
    }

    @Override
    public final AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (type == DataType.LONG) {
            return new StdDevLongAggregatorFunctionSupplier();
        }
        if (type == DataType.INTEGER) {
            return new StdDevIntAggregatorFunctionSupplier();
        }
        if (type == DataType.DOUBLE) {
            return new StdDevDoubleAggregatorFunctionSupplier();
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

