/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class SpatialCentroid
extends SpatialAggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialCentroid", SpatialCentroid::new);

    @FunctionInfo(returnType={"geo_point", "cartesian_point"}, description="Calculate the spatial centroid over a field with spatial point geometry type.", isAggregation=true, examples={@Example(file="spatial", tag="st_centroid_agg-airports")})
    public SpatialCentroid(Source source, @Param(name="field", type={"geo_point", "cartesian_point"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, MappedFieldType.FieldExtractPreference.NONE);
    }

    private SpatialCentroid(Source source, Expression field, Expression filter, MappedFieldType.FieldExtractPreference preference) {
        super(source, field, filter, preference);
    }

    private SpatialCentroid(StreamInput in) throws IOException {
        super(in, MappedFieldType.FieldExtractPreference.NONE);
    }

    public String getWriteableName() {
        return SpatialCentroid.ENTRY.name;
    }

    @Override
    public SpatialCentroid withFilter(Expression filter) {
        return new SpatialCentroid(this.source(), this.field(), filter, this.fieldExtractPreference);
    }

    @Override
    public SpatialCentroid withFieldExtractPreference(MappedFieldType.FieldExtractPreference preference) {
        return new SpatialCentroid(this.source(), this.field(), this.filter(), preference);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected NodeInfo<SpatialCentroid> info() {
        return NodeInfo.create((Node)this, SpatialCentroid::new, (Object)this.field());
    }

    public SpatialCentroid replaceChildren(List<Expression> newChildren) {
        return new SpatialCentroid(this.source(), newChildren.get(0));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.GEO_POINT -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOC_VALUES: {
                        yield new SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case EXTRACT_SPATIAL_BOUNDS: 
                }
                yield new SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier();
            }
            case DataType.CARTESIAN_POINT -> {
                switch (this.fieldExtractPreference) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOC_VALUES: {
                        yield new SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier();
                    }
                    case NONE: 
                    case EXTRACT_SPATIAL_BOUNDS: 
                }
                yield new SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier();
            }
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }
}

