/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.AnalyzerRules;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FoldablesConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.inference.ResolvedInference;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogateExpressions;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.telemetry.FeatureMetric;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    public static final List<Attribute> NO_FIELDS = List.of(new ReferenceAttribute(Source.EMPTY, "<no-fields>", DataType.NULL, Nullability.TRUE, null, true));
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = List.of(new RuleExecutor.Batch("Initialize", RuleExecutor.Limiter.ONCE, new ResolveTable(), new ResolveEnrich(), new ResolveInference(), new ResolveLookupTables(), new ResolveFunctions(), new DateMillisToNanosInEsRelation(EsqlCapabilities.Cap.IMPLICIT_CASTING_DATE_AND_DATE_NANOS.isEnabled())), new RuleExecutor.Batch("Resolution", new ResolveRefs(), new ImplicitCasting(), new ResolveUnionTypes()), new RuleExecutor.Batch("Finish Analysis", RuleExecutor.Limiter.ONCE, new AddImplicitLimit(), new UnionTypesCleanup()));
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super(context);
        this.verifier = verifier;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        BitSet partialMetrics = new BitSet(FeatureMetric.values().length);
        return this.verify(this.execute(plan), this.gatherPreAnalysisMetrics(plan, partialMetrics));
    }

    public LogicalPlan verify(LogicalPlan plan, BitSet partialMetrics) {
        Collection<Failure> failures = this.verifier.verify(plan, partialMetrics);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    public static List<Attribute> mappingAsAttributes(Source source, Map<String, EsField> mapping) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Analyzer.mappingAsAttributes(list, source, null, mapping);
        list.sort(Comparator.comparing(NamedExpression::name));
        return list;
    }

    private static void mappingAsAttributes(List<Attribute> list, Source source, String parentName, Map<String, EsField> mapping) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            FieldAttribute attribute;
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            name = parentName == null ? name : parentName + "." + name;
            Map fieldProperties = t.getProperties();
            DataType type = t.getDataType().widenSmallNumeric();
            if (type != t.getDataType()) {
                t = new EsField(t.getName(), type, t.getProperties(), t.isAggregatable(), t.isAlias());
            }
            if (t instanceof UnsupportedEsField) {
                UnsupportedEsField uef = (UnsupportedEsField)t;
                v0 = new UnsupportedAttribute(source, name, uef);
            } else {
                v0 = attribute = new FieldAttribute(source, parentName, name, t);
            }
            if (DataType.isPrimitive((DataType)type)) {
                list.add((Attribute)attribute);
            }
            if (fieldProperties.isEmpty()) continue;
            Analyzer.mappingAsAttributes(list, source, attribute.name(), fieldProperties);
        }
    }

    private static List<Attribute> resolveAgainstList(UnresolvedNamePattern up, Collection<Attribute> attrList) {
        UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.pattern());
        Predicate<Attribute> matcher = a -> up.match(a.name());
        List<Attribute> matches = AnalyzerRules.maybeResolveAgainstList(matcher, () -> ua, attrList, true, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, list -> UnresolvedNamePattern.errorMessage(up.pattern(), list));
    }

    private static List<Attribute> resolveAgainstList(UnresolvedAttribute ua, Collection<Attribute> attrList) {
        List<Attribute> matches = AnalyzerRules.maybeResolveAgainstList(ua, attrList, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, list -> UnresolvedAttribute.errorMessage((String)ua.name(), (List)list));
    }

    private static List<Attribute> potentialCandidatesIfNoMatchesFound(UnresolvedAttribute ua, List<Attribute> matches, Collection<Attribute> attrList, Function<List<String>, String> messageProducer) {
        if (ua.customMessage()) {
            return List.of();
        }
        if (matches.isEmpty()) {
            HashSet<String> names = new HashSet<String>(attrList.size());
            for (Attribute a : attrList) {
                String nameCandidate = a.name();
                if (!DataType.isPrimitive((DataType)a.dataType())) continue;
                names.add(nameCandidate);
            }
            String name = ua.name();
            UnresolvedAttribute unresolved = ua.withUnresolvedMessage(messageProducer.apply(StringUtils.findSimilar((String)name, names)));
            matches = Collections.singletonList(unresolved);
        }
        return matches;
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named) {
        return named.withLocation(u.source());
    }

    private BitSet gatherPreAnalysisMetrics(LogicalPlan plan, BitSet b) {
        if (!plan.collectFirstChildren(Limit.class::isInstance).isEmpty()) {
            b.set(FeatureMetric.LIMIT.ordinal());
        }
        plan.forEachDown(p -> FeatureMetric.set(p, b));
        return b;
    }

    private static void typeResolutions(FieldAttribute fieldAttribute, ConvertFunction convert, DataType type, InvalidMappedField imf, HashMap<ResolveUnionTypes.TypeResolutionKey, Expression> typeResolutions) {
        ResolveUnionTypes.TypeResolutionKey key = new ResolveUnionTypes.TypeResolutionKey(fieldAttribute.name(), type);
        Expression concreteConvert = ResolveUnionTypes.typeSpecificConvert(convert, fieldAttribute.source(), type, imf);
        typeResolutions.put(key, concreteConvert);
    }

    private static class ResolveUnionTypes
    extends Rule<LogicalPlan, LogicalPlan> {
        private List<FieldAttribute> unionFieldAttributes;

        private ResolveUnionTypes() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            this.unionFieldAttributes = new ArrayList<FieldAttribute>();
            plan.forEachUp(EsRelation.class, rel -> {
                for (Attribute attr : rel.output()) {
                    FieldAttribute fa;
                    if (!(attr instanceof FieldAttribute) || !((fa = (FieldAttribute)attr).field() instanceof MultiTypeEsField) || !fa.synthetic()) continue;
                    this.unionFieldAttributes.add(fa);
                }
            });
            return (LogicalPlan)plan.transformUp(LogicalPlan.class, p -> !p.childrenResolved() ? p : this.doRule((LogicalPlan)((Object)p)));
        }

        private LogicalPlan doRule(LogicalPlan plan) {
            int alreadyAddedUnionFieldAttributes = this.unionFieldAttributes.size();
            plan = (LogicalPlan)((Object)plan.transformExpressionsOnly(e -> {
                if (e instanceof ConvertFunction) {
                    ConvertFunction convert = (ConvertFunction)e;
                    return this.resolveConvertFunction(convert, this.unionFieldAttributes);
                }
                return e;
            }));
            if (this.unionFieldAttributes.size() == alreadyAddedUnionFieldAttributes) {
                return plan;
            }
            plan = (LogicalPlan)plan.transformDown(EsRelation.class, esr -> {
                ArrayList<FieldAttribute> missing = new ArrayList<FieldAttribute>();
                for (FieldAttribute fa : this.unionFieldAttributes) {
                    if (esr.outputSet().contains((Object)fa)) continue;
                    missing.add(fa);
                }
                if (!missing.isEmpty()) {
                    return new EsRelation(esr.source(), esr.indexPattern(), esr.indexMode(), esr.indexNameWithModes(), CollectionUtils.combine(esr.output(), missing));
                }
                return esr;
            });
            return plan;
        }

        private Expression resolveConvertFunction(ConvertFunction convert, List<FieldAttribute> unionFieldAttributes) {
            FieldAttribute fa;
            Expression convertExpression = (Expression)convert;
            Expression expression = convert.field();
            if (expression instanceof FieldAttribute && (expression = (fa = (FieldAttribute)expression).field()) instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)expression;
                typeResolutions = new HashMap();
                Set<DataType> supportedTypes = convert.supportedTypes();
                if (convert instanceof FoldablesConvertFunction) {
                    FoldablesConvertFunction fcf = (FoldablesConvertFunction)convert;
                    String unresolvedMessage = "argument of [" + fcf.sourceText() + "] must be a constant, received [" + Expressions.name((Expression)fa) + "]";
                    UnresolvedAttribute ua = new UnresolvedAttribute(fa.source(), fa.name(), unresolvedMessage);
                    return (Expression)fcf.replaceChildren(Collections.singletonList(ua));
                }
                imf.types().forEach(arg_0 -> ResolveUnionTypes.lambda$resolveConvertFunction$4(supportedTypes, fa, convert, imf, (HashMap)typeResolutions, arg_0));
                if (((HashMap)typeResolutions).size() == imf.getTypesToIndices().size()) {
                    MultiTypeEsField resolvedField = ResolveUnionTypes.resolvedMultiTypeEsField(fa, (HashMap<TypeResolutionKey, Expression>)typeResolutions);
                    return this.createIfDoesNotAlreadyExist(fa, resolvedField, unionFieldAttributes);
                }
            } else {
                FieldAttribute fa2;
                typeResolutions = convert.field();
                if (typeResolutions instanceof FieldAttribute && !(fa2 = (FieldAttribute)typeResolutions).synthetic() && (typeResolutions = fa2.field()) instanceof MultiTypeEsField) {
                    MultiTypeEsField mtf = (MultiTypeEsField)typeResolutions;
                    if (((Expression)convert).dataType() == mtf.getDataType()) {
                        return this.createIfDoesNotAlreadyExist(fa2, mtf, unionFieldAttributes);
                    }
                    Set<DataType> supportedTypes = convert.supportedTypes();
                    if (supportedTypes.contains(fa2.dataType()) && ResolveUnionTypes.canConvertOriginalTypes(mtf, supportedTypes)) {
                        HashMap<String, Expression> indexToConversionExpressions = new HashMap<String, Expression>();
                        for (Map.Entry entry : mtf.getIndexToConversionExpressions().entrySet()) {
                            String indexName = (String)entry.getKey();
                            AbstractConvertFunction originalConversionFunction = (AbstractConvertFunction)entry.getValue();
                            Expression originalField = originalConversionFunction.field();
                            Expression newConvertFunction = (Expression)convertExpression.replaceChildren(Collections.singletonList(originalField));
                            indexToConversionExpressions.put(indexName, newConvertFunction);
                        }
                        MultiTypeEsField multiTypeEsField = new MultiTypeEsField(fa2.fieldName().string(), convertExpression.dataType(), false, indexToConversionExpressions);
                        return this.createIfDoesNotAlreadyExist(fa2, multiTypeEsField, unionFieldAttributes);
                    }
                } else {
                    expression = convert.field();
                    if (expression instanceof AbstractConvertFunction) {
                        AbstractConvertFunction subConvert = (AbstractConvertFunction)expression;
                        return (Expression)convertExpression.replaceChildren(Collections.singletonList(this.resolveConvertFunction(subConvert, unionFieldAttributes)));
                    }
                }
            }
            return convertExpression;
        }

        private Expression createIfDoesNotAlreadyExist(FieldAttribute fa, MultiTypeEsField resolvedField, List<FieldAttribute> unionFieldAttributes) {
            String unionTypedFieldName = Attribute.rawTemporaryName((String[])new String[]{fa.name(), "converted_to", resolvedField.getDataType().typeName()});
            FieldAttribute unionFieldAttribute = new FieldAttribute(fa.source(), fa.parentName(), unionTypedFieldName, (EsField)resolvedField, true);
            int existingIndex = unionFieldAttributes.indexOf(unionFieldAttribute);
            if (existingIndex >= 0) {
                return (Expression)unionFieldAttributes.get(existingIndex);
            }
            unionFieldAttributes.add(unionFieldAttribute);
            return unionFieldAttribute;
        }

        private static MultiTypeEsField resolvedMultiTypeEsField(FieldAttribute fa, HashMap<TypeResolutionKey, Expression> typeResolutions) {
            HashMap typesToConversionExpressions = new HashMap();
            InvalidMappedField imf = (InvalidMappedField)fa.field();
            imf.getTypesToIndices().forEach((typeName, indexNames) -> {
                DataType type = DataType.fromTypeName((String)typeName);
                TypeResolutionKey key = new TypeResolutionKey(fa.name(), type);
                if (typeResolutions.containsKey(key)) {
                    typesToConversionExpressions.put(typeName, (Expression)typeResolutions.get(key));
                }
            });
            return MultiTypeEsField.resolveFrom((InvalidMappedField)imf, typesToConversionExpressions);
        }

        private static boolean canConvertOriginalTypes(MultiTypeEsField multiTypeEsField, Set<DataType> supportedTypes) {
            return multiTypeEsField.getIndexToConversionExpressions().values().stream().allMatch(e -> {
                AbstractConvertFunction convertFunction;
                return e instanceof AbstractConvertFunction && supportedTypes.contains((convertFunction = (AbstractConvertFunction)e).field().dataType().widenSmallNumeric());
            });
        }

        private static Expression typeSpecificConvert(ConvertFunction convert, Source source, DataType type, InvalidMappedField mtf) {
            EsField field = new EsField(mtf.getName(), type, mtf.getProperties(), mtf.isAggregatable());
            FieldAttribute originalFieldAttr = (FieldAttribute)convert.field();
            FieldAttribute resolvedAttr = new FieldAttribute(source, originalFieldAttr.parentName(), originalFieldAttr.name(), field, originalFieldAttr.nullable(), originalFieldAttr.id(), true);
            Expression e = (Expression)((Expression)convert).replaceChildren(Collections.singletonList(resolvedAttr));
            return SubstituteSurrogateExpressions.rule(e);
        }

        private static /* synthetic */ void lambda$resolveConvertFunction$4(Set supportedTypes, FieldAttribute fa, ConvertFunction convert, InvalidMappedField imf, HashMap typeResolutions, DataType type) {
            if (supportedTypes.contains(type.widenSmallNumeric())) {
                Analyzer.typeResolutions(fa, convert, type, imf, typeResolutions);
            }
        }

        record TypeResolutionKey(String fieldName, DataType fieldType) {
        }
    }

    private static class ResolveTable
    extends AnalyzerRules.ParameterizedAnalyzerRule<UnresolvedRelation, AnalyzerContext> {
        private ResolveTable() {
        }

        @Override
        protected LogicalPlan rule(UnresolvedRelation plan, AnalyzerContext context) {
            return this.resolveIndex(plan, plan.indexMode().equals((Object)IndexMode.LOOKUP) ? context.lookupResolution().get(plan.indexPattern().indexPattern()) : context.indexResolution());
        }

        private LogicalPlan resolveIndex(UnresolvedRelation plan, IndexResolution indexResolution) {
            if (indexResolution == null || !indexResolution.isValid()) {
                String indexResolutionMessage = indexResolution == null ? "[none specified]" : indexResolution.toString();
                return plan.unresolvedMessage().equals(indexResolutionMessage) ? plan : new UnresolvedRelation(plan.source(), plan.indexPattern(), plan.frozen(), plan.metadataFields(), plan.indexMode(), indexResolutionMessage, plan.telemetryLabel());
            }
            IndexPattern table = plan.indexPattern();
            if (!indexResolution.matches(table.indexPattern())) {
                new UnresolvedRelation(plan.source(), plan.indexPattern(), plan.frozen(), plan.metadataFields(), plan.indexMode(), "invalid [" + String.valueOf(table) + "] resolution to [" + String.valueOf(indexResolution) + "]", plan.telemetryLabel());
            }
            EsIndex esIndex = indexResolution.get();
            List<Attribute> attributes = Analyzer.mappingAsAttributes(plan.source(), esIndex.mapping());
            attributes.addAll(plan.metadataFields());
            return new EsRelation(plan.source(), esIndex.name(), plan.indexMode(), esIndex.indexNameWithModes(), attributes.isEmpty() ? NO_FIELDS : attributes);
        }
    }

    private static class ResolveEnrich
    extends AnalyzerRules.ParameterizedAnalyzerRule<Enrich, AnalyzerContext> {
        private ResolveEnrich() {
        }

        @Override
        protected LogicalPlan rule(Enrich plan, AnalyzerContext context) {
            if (!plan.policyName().resolved()) {
                return plan;
            }
            String policyName = BytesRefs.toString((Object)plan.policyName().fold(FoldContext.small()));
            ResolvedEnrichPolicy resolved = context.enrichResolution().getResolvedPolicy(policyName, plan.mode());
            if (resolved != null) {
                EnrichPolicy policy = new EnrichPolicy(resolved.matchType(), null, List.of(), resolved.matchField(), resolved.enrichFields());
                UnresolvedAttribute matchField = plan.matchField() == null || plan.matchField() instanceof EmptyAttribute ? new UnresolvedAttribute(plan.source(), policy.getMatchField()) : plan.matchField();
                List<NamedExpression> enrichFields = ResolveEnrich.calculateEnrichFields(plan.source(), policyName, Analyzer.mappingAsAttributes(plan.source(), resolved.mapping()), plan.enrichFields(), policy);
                return new Enrich(plan.source(), plan.child(), plan.mode(), plan.policyName(), (NamedExpression)matchField, policy, resolved.concreteIndices(), enrichFields);
            }
            String error = context.enrichResolution().getError(policyName, plan.mode());
            UnresolvedAttribute policyNameExp = new UnresolvedAttribute(plan.policyName().source(), policyName, error);
            return new Enrich(plan.source(), plan.child(), plan.mode(), (Expression)policyNameExp, plan.matchField(), null, Map.of(), List.of());
        }

        public static List<NamedExpression> calculateEnrichFields(Source source, String policyName, List<Attribute> mapping, List<NamedExpression> enrichFields, EnrichPolicy policy) {
            HashSet policyEnrichFieldSet = new HashSet(policy.getEnrichFields());
            Map<String, Attribute> fieldMap = mapping.stream().filter(e -> policyEnrichFieldSet.contains(e.name())).collect(Collectors.toMap(NamedExpression::name, Function.identity()));
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            if (enrichFields == null || enrichFields.isEmpty()) {
                for (String enrichFieldName : policy.getEnrichFields()) {
                    result.add(ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName));
                }
            } else {
                for (NamedExpression enrichField : enrichFields) {
                    NamedExpression namedExpression;
                    NamedExpression namedExpression2;
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression2 = a.child();
                    } else {
                        namedExpression2 = enrichField;
                    }
                    String enrichFieldName = Expressions.name((Expression)namedExpression2);
                    NamedExpression field = ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName);
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression = new Alias(a.source(), a.name(), (Expression)field);
                    } else {
                        namedExpression = field;
                    }
                    result.add(namedExpression);
                }
            }
            return result;
        }

        private static NamedExpression createEnrichFieldExpression(Source source, String policyName, Map<String, Attribute> fieldMap, String enrichFieldName) {
            Attribute mappedField = fieldMap.get(enrichFieldName);
            if (mappedField == null) {
                String msg = "Enrich field [" + enrichFieldName + "] not found in enrich policy [" + policyName + "]";
                List similar = StringUtils.findSimilar((String)enrichFieldName, fieldMap.keySet());
                if (!CollectionUtils.isEmpty((Collection)similar)) {
                    msg = msg + ", did you mean " + (similar.size() == 1 ? "[" + (String)similar.get(0) + "]" : "any of " + String.valueOf(similar)) + "?";
                }
                return new UnresolvedAttribute(source, enrichFieldName, msg);
            }
            return new ReferenceAttribute(source, enrichFieldName, mappedField.dataType(), Nullability.TRUE, null, false);
        }
    }

    private static class ResolveInference
    extends AnalyzerRules.ParameterizedAnalyzerRule<InferencePlan<?>, AnalyzerContext> {
        private ResolveInference() {
        }

        @Override
        protected LogicalPlan rule(InferencePlan<?> plan, AnalyzerContext context) {
            assert (plan.inferenceId().resolved() && plan.inferenceId().foldable());
            String inferenceId = BytesRefs.toString((Object)plan.inferenceId().fold(FoldContext.small()));
            ResolvedInference resolvedInference = context.inferenceResolution().getResolvedInference(inferenceId);
            if (resolvedInference != null && resolvedInference.taskType() == plan.taskType()) {
                return plan;
            }
            if (resolvedInference != null) {
                String error = "cannot use inference endpoint [" + inferenceId + "] with task type [" + String.valueOf(resolvedInference.taskType()) + "] within a " + plan.nodeName() + " command. Only inference endpoints with the task type [" + String.valueOf(plan.taskType()) + "] are supported.";
                return plan.withInferenceResolutionError(inferenceId, error);
            }
            String error = context.inferenceResolution().getError(inferenceId);
            return plan.withInferenceResolutionError(inferenceId, error);
        }
    }

    private static class ResolveLookupTables
    extends AnalyzerRules.ParameterizedAnalyzerRule<Lookup, AnalyzerContext> {
        private ResolveLookupTables() {
        }

        @Override
        protected LogicalPlan rule(Lookup lookup, AnalyzerContext context) {
            Source source = lookup.source();
            Expression tableNameExpression = lookup.tableName();
            String tableName = BytesRefs.toString((Object)tableNameExpression.fold(FoldContext.small()));
            Map<String, Map<String, Column>> tables = context.configuration().tables();
            LocalRelation localRelation = null;
            if (!tables.containsKey(tableName)) {
                Object message = "Unknown table [" + tableName + "]";
                List potentialMatches = StringUtils.findSimilar((String)tableName, tables.keySet());
                if (!CollectionUtils.isEmpty((Collection)potentialMatches)) {
                    message = UnresolvedAttribute.errorMessage((String)tableName, (List)potentialMatches).replace("column", "table");
                }
                tableNameExpression = new UnresolvedAttribute(tableNameExpression.source(), tableName, (String)message);
            } else {
                localRelation = this.tableMapAsRelation(source, tables.get(tableName));
            }
            return new Lookup(source, lookup.child(), tableNameExpression, lookup.matchFields(), localRelation);
        }

        private LocalRelation tableMapAsRelation(Source source, Map<String, Column> mapTable) {
            Block[] blocks = new Block[mapTable.size()];
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(blocks.length);
            int i = 0;
            for (Map.Entry<String, Column> entry : mapTable.entrySet()) {
                String name = entry.getKey();
                Column column = entry.getValue();
                EsField field = new EsField(name, column.type(), Map.of(), false, false);
                attributes.add((Attribute)new FieldAttribute(source, null, name, field));
                blocks[i++] = column.values();
            }
            LocalSupplier supplier = LocalSupplier.of(blocks);
            return new LocalRelation(source, attributes, supplier);
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            EsqlFunctionRegistry snapshotRegistry = context.functionRegistry().snapshotRegistry();
            return (LogicalPlan)((Object)plan.transformExpressionsOnly(UnresolvedFunction.class, uf -> ResolveFunctions.resolveFunction(uf, context.configuration(), snapshotRegistry)));
        }

        public static org.elasticsearch.xpack.esql.core.expression.function.Function resolveFunction(UnresolvedFunction uf, Configuration configuration, EsqlFunctionRegistry functionRegistry) {
            UnresolvedFunction f = null;
            if (uf.analyzed()) {
                f = uf;
            } else {
                String functionName = functionRegistry.resolveAlias(uf.name());
                if (!functionRegistry.functionExists(functionName)) {
                    f = uf.missing(functionName, functionRegistry.listFunctions());
                } else {
                    FunctionDefinition def = functionRegistry.resolveFunction(functionName);
                    f = uf.buildResolved(configuration, def);
                }
            }
            return f;
        }
    }

    private static class DateMillisToNanosInEsRelation
    extends Rule<LogicalPlan, LogicalPlan> {
        private final boolean isSnapshot;

        DateMillisToNanosInEsRelation(boolean isSnapshot) {
            this.isSnapshot = isSnapshot;
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            if (this.isSnapshot) {
                return (LogicalPlan)plan.transformUp(EsRelation.class, relation -> {
                    if (relation.indexMode() == IndexMode.LOOKUP) {
                        return relation;
                    }
                    return (LogicalPlan)((Object)((Object)relation.transformExpressionsUp(FieldAttribute.class, f -> {
                        InvalidMappedField imf;
                        EsField patt87487$temp = f.field();
                        if (patt87487$temp instanceof InvalidMappedField && (imf = (InvalidMappedField)patt87487$temp).types().stream().allMatch(DataType::isDate)) {
                            HashMap<ResolveUnionTypes.TypeResolutionKey, Expression> typeResolutions = new HashMap<ResolveUnionTypes.TypeResolutionKey, Expression>();
                            ToDateNanos convert = new ToDateNanos(f.source(), (Expression)f);
                            imf.types().forEach(type -> Analyzer.typeResolutions(f, convert, type, imf, typeResolutions));
                            MultiTypeEsField resolvedField = ResolveUnionTypes.resolvedMultiTypeEsField(f, typeResolutions);
                            return new FieldAttribute(f.source(), f.parentName(), f.name(), (EsField)resolvedField, f.nullable(), f.id(), f.synthetic());
                        }
                        return f;
                    })));
                });
            }
            return plan;
        }
    }

    public static class ResolveRefs
    extends AnalyzerRules.BaseAnalyzerRule {
        private static final DataType[] GEO_TYPES = new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE};
        private static final DataType[] NON_GEO_TYPES = new DataType[]{DataType.KEYWORD, DataType.TEXT, DataType.IP, DataType.LONG, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.DATETIME};

        @Override
        protected LogicalPlan doRule(LogicalPlan plan) {
            UnaryPlan p;
            UnaryPlan r;
            if (!plan.childrenResolved()) {
                return plan;
            }
            ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
            for (LogicalPlan child : plan.children()) {
                List<Attribute> output = child.output();
                childrenOutput.addAll(output);
            }
            if (plan instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)plan;
                return this.resolveAggregate(aggregate, childrenOutput);
            }
            if (plan instanceof Completion) {
                Completion c = (Completion)plan;
                return this.resolveCompletion(c, childrenOutput);
            }
            if (plan instanceof Drop) {
                Drop d = (Drop)plan;
                return this.resolveDrop(d, childrenOutput);
            }
            if (plan instanceof Rename) {
                r = (Rename)plan;
                return this.resolveRename((Rename)r, (List<Attribute>)childrenOutput);
            }
            if (plan instanceof Keep) {
                p = (Keep)plan;
                return this.resolveKeep((Project)p, (List<Attribute>)childrenOutput);
            }
            if (plan instanceof Eval) {
                p = (Eval)plan;
                return this.resolveEval((Eval)p, childrenOutput);
            }
            if (plan instanceof Enrich) {
                p = (Enrich)plan;
                return this.resolveEnrich((Enrich)p, childrenOutput);
            }
            if (plan instanceof MvExpand) {
                p = (MvExpand)plan;
                return this.resolveMvExpand((MvExpand)p, childrenOutput);
            }
            if (plan instanceof Lookup) {
                Lookup l = (Lookup)plan;
                return this.resolveLookup(l, childrenOutput);
            }
            if (plan instanceof LookupJoin) {
                LookupJoin j = (LookupJoin)plan;
                return this.resolveLookupJoin(j);
            }
            if (plan instanceof Rerank) {
                r = (Rerank)plan;
                return this.resolveRerank((Rerank)r, childrenOutput);
            }
            return (LogicalPlan)((Object)plan.transformExpressionsOnly(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)childrenOutput)));
        }

        private Aggregate resolveAggregate(Aggregate aggregate, List<Attribute> childrenOutput) {
            Holder changed = new Holder((Object)false);
            List<Expression> groupings = aggregate.groupings();
            List<? extends NamedExpression> aggregates = aggregate.aggregates();
            if (!Resolvables.resolved(groupings)) {
                ArrayList<Expression> newGroupings = new ArrayList<Expression>(groupings.size());
                for (Expression g : groupings) {
                    Expression resolved = (Expression)g.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                    if (resolved != g) {
                        changed.set((Object)true);
                    }
                    newGroupings.add(resolved);
                }
                groupings = newGroupings;
                if (((Boolean)changed.get()).booleanValue()) {
                    aggregate = aggregate.with(aggregate.child(), newGroupings, aggregate.aggregates());
                    changed.set((Object)false);
                }
            }
            if (!Resolvables.resolved(groupings) || !Resolvables.resolved(aggregates)) {
                ArrayList<Attribute> resolved = new ArrayList<Attribute>();
                for (Expression e : groupings) {
                    Attribute attr = Expressions.attribute((Expression)e);
                    if (attr == null || !attr.resolved()) continue;
                    resolved.add(attr);
                }
                List<Attribute> resolvedList = NamedExpressions.mergeOutputAttributes(resolved, childrenOutput);
                ArrayList<NamedExpression> newAggregates = new ArrayList<NamedExpression>();
                boolean groupingResolved = Resolvables.resolved(groupings);
                int size = groupingResolved ? aggregates.size() : aggregates.size() - groupings.size();
                for (int i = 0; i < aggregates.size(); ++i) {
                    NamedExpression maybeResolvedAgg = aggregates.get(i);
                    if (i < size) {
                        maybeResolvedAgg = (NamedExpression)maybeResolvedAgg.transformUp(UnresolvedAttribute.class, ua -> {
                            UnresolvedAttribute ne = ua;
                            Attribute maybeResolved = this.maybeResolveAttribute((UnresolvedAttribute)ua, resolvedList);
                            if (groupingResolved || maybeResolved.resolved()) {
                                changed.set((Object)true);
                                ne = maybeResolved;
                            }
                            return ne;
                        });
                    }
                    newAggregates.add(maybeResolvedAgg);
                }
                aggregate = (Boolean)changed.get() != false ? aggregate.with(aggregate.child(), groupings, newAggregates) : aggregate;
            }
            return aggregate;
        }

        private LogicalPlan resolveCompletion(Completion p, List<Attribute> childrenOutput) {
            Attribute targetField = p.targetField();
            Expression prompt = p.prompt();
            if (targetField instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua2 = (UnresolvedAttribute)targetField;
                targetField = new ReferenceAttribute(ua2.source(), ua2.name(), DataType.KEYWORD);
            }
            if (!prompt.resolved()) {
                prompt = (Expression)prompt.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
            }
            return new Completion(p.source(), p.child(), p.inferenceId(), prompt, targetField);
        }

        private LogicalPlan resolveMvExpand(MvExpand p, List<Attribute> childrenOutput) {
            NamedExpression namedExpression = p.target();
            if (namedExpression instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved == ua) {
                    return p;
                }
                return new MvExpand(p.source(), p.child(), (NamedExpression)resolved, (Attribute)(resolved.resolved() ? new ReferenceAttribute(resolved.source(), resolved.name(), resolved.dataType(), resolved.nullable(), null, false) : resolved));
            }
            return p;
        }

        private LogicalPlan resolveLookup(Lookup l, List<Attribute> childrenOutput) {
            if (l.localRelation() == null) {
                return l;
            }
            ArrayList<Attribute> matchFields = new ArrayList<Attribute>(l.matchFields().size());
            List<Attribute> localOutput = l.localRelation().output();
            boolean modified = false;
            Iterator<Attribute> iterator = l.matchFields().iterator();
            while (iterator.hasNext()) {
                UnresolvedAttribute ua;
                Attribute matchField;
                Attribute matchFieldChildReference = matchField = iterator.next();
                if (matchField instanceof UnresolvedAttribute && !(ua = (UnresolvedAttribute)matchField).customMessage()) {
                    modified = true;
                    Attribute joinedAttribute = this.maybeResolveAttribute(ua, localOutput);
                    if (joinedAttribute instanceof UnresolvedAttribute) {
                        UnresolvedAttribute lua = (UnresolvedAttribute)joinedAttribute;
                        matchFieldChildReference = lua.withUnresolvedMessage(lua.unresolvedMessage().replace("Unknown column", "Unknown column in lookup target"));
                    } else {
                        Attribute attr;
                        matchFieldChildReference = attr = this.maybeResolveAttribute(ua, childrenOutput);
                        if (!(attr instanceof UnresolvedAttribute)) {
                            boolean dataTypesOk = joinedAttribute.dataType().equals((Object)attr.dataType());
                            if (!dataTypesOk) {
                                boolean bl = dataTypesOk = joinedAttribute.dataType() == DataType.NULL || attr.dataType() == DataType.NULL;
                            }
                            if (!dataTypesOk) {
                                boolean bl = dataTypesOk = joinedAttribute.dataType().equals((Object)DataType.KEYWORD) && attr.dataType().equals((Object)DataType.TEXT);
                            }
                            if (!dataTypesOk) {
                                matchFieldChildReference = new UnresolvedAttribute(attr.source(), attr.name(), attr.id(), "column type mismatch, table column was [" + joinedAttribute.dataType().typeName() + "] and original column was [" + attr.dataType().typeName() + "]", null);
                            }
                        }
                    }
                }
                matchFields.add(matchFieldChildReference);
            }
            if (modified) {
                return new Lookup(l.source(), l.child(), l.tableName(), matchFields, l.localRelation());
            }
            return l;
        }

        private Join resolveLookupJoin(LookupJoin join) {
            JoinConfig config = join.config();
            JoinType type = config.type();
            if (type instanceof JoinTypes.UsingJoinType) {
                JoinTypes.UsingJoinType using = (JoinTypes.UsingJoinType)type;
                List<Attribute> cols = using.columns();
                if (Expressions.anyMatch(cols, c -> {
                    UnresolvedAttribute ua;
                    return c instanceof UnresolvedAttribute && (ua = (UnresolvedAttribute)c).customMessage();
                })) {
                    return join;
                }
                JoinType coreJoin = using.coreJoin();
                if (coreJoin != JoinTypes.LEFT) {
                    String name = cols.get(0).name();
                    UnresolvedAttribute errorAttribute = new UnresolvedAttribute(join.source(), name, "Only LEFT join is supported with USING");
                    return join.withConfig(new JoinConfig(type, Collections.singletonList(errorAttribute), Collections.emptyList(), Collections.emptyList()));
                }
                List<Attribute> leftKeys = this.resolveUsingColumns(cols, join.left().output(), "left");
                List<Attribute> rightKeys = this.resolveUsingColumns(cols, join.right().output(), "right");
                config = new JoinConfig(coreJoin, leftKeys, leftKeys, rightKeys);
                join = new LookupJoin(join.source(), join.left(), join.right(), config);
            } else if (type != JoinTypes.LEFT) {
                UnresolvedAttribute errorAttribute = new UnresolvedAttribute(join.source(), "unsupported", "Unsupported join type");
                return join.withConfig(new JoinConfig(type, Collections.singletonList(errorAttribute), Collections.emptyList(), Collections.emptyList()));
            }
            return join;
        }

        private LogicalPlan resolveRerank(Rerank rerank, List<Attribute> childrenOutput) {
            Alias field2;
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            for (Alias field2 : rerank.rerankFields()) {
                Alias result = (Alias)field2.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                newFields.add(result);
                changed |= result != field2;
            }
            if (changed) {
                rerank = rerank.withRerankFields(newFields);
            }
            if ((field2 = rerank.scoreAttribute()) instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua2 = (UnresolvedAttribute)field2;
                Object resolved = this.resolveAttribute(ua2, childrenOutput);
                if (!resolved.resolved() || resolved.dataType() != DataType.DOUBLE) {
                    resolved = ua2.name().equals("_score") ? MetadataAttribute.create((Source)Source.EMPTY, (String)"_score") : new ReferenceAttribute(resolved.source(), resolved.name(), DataType.DOUBLE);
                }
                rerank = rerank.withScoreAttribute((Attribute)resolved);
            }
            return rerank;
        }

        private List<Attribute> resolveUsingColumns(List<Attribute> cols, List<Attribute> output, String side) {
            ArrayList<Attribute> resolved = new ArrayList<Attribute>(cols.size());
            for (Attribute col : cols) {
                if (col instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)col;
                    Attribute resolvedCol = this.maybeResolveAttribute(ua, output);
                    if (resolvedCol instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ucol = (UnresolvedAttribute)resolvedCol;
                        String message = ua.unresolvedMessage();
                        String match = "column [" + ucol.name() + "]";
                        resolvedCol = ucol.withUnresolvedMessage(message.replace(match, match + " in " + side + " side of join"));
                    }
                    resolved.add(resolvedCol);
                    continue;
                }
                throw new IllegalStateException("Surprised to discover column [ " + col.name() + "] already resolved when resolving JOIN keys");
            }
            return resolved;
        }

        private Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            return ResolveRefs.maybeResolveAttribute(ua, childrenOutput, this.log);
        }

        private static Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput, Logger logger) {
            if (ua.customMessage()) {
                return ua;
            }
            return ResolveRefs.resolveAttribute(ua, childrenOutput, logger);
        }

        private Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            return ResolveRefs.resolveAttribute(ua, childrenOutput, this.log);
        }

        private static Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput, Logger logger) {
            UnresolvedAttribute resolved = ua;
            List<Attribute> named = Analyzer.resolveAgainstList(ua, childrenOutput);
            if (named.size() == 1) {
                resolved = named.get(0);
                if (logger != null && logger.isTraceEnabled() && resolved.resolved()) {
                    logger.trace("Resolved {} to {}", new Object[]{ua, resolved});
                }
            } else if (named.size() > 0) {
                resolved = ua.withUnresolvedMessage("Resolved [" + String.valueOf(ua) + "] unexpectedly to multiple attributes " + String.valueOf(named));
            }
            return resolved;
        }

        private LogicalPlan resolveEval(Eval eval, List<Attribute> childOutput) {
            ArrayList<Attribute> allResolvedInputs = new ArrayList<Attribute>(childOutput);
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            for (Alias field : eval.fields()) {
                Alias result = (Alias)field.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)allResolvedInputs));
                changed |= result != field;
                newFields.add(result);
                if (!result.resolved()) continue;
                Attribute existing = allResolvedInputs.stream().filter(attr -> attr.name().equals(result.name())).findFirst().orElse(null);
                if (existing != null) {
                    allResolvedInputs.remove(existing);
                }
                allResolvedInputs.add(result.toAttribute());
            }
            return changed ? new Eval(eval.source(), eval.child(), newFields) : eval;
        }

        private LogicalPlan resolveKeep(Project p, List<Attribute> childOutput) {
            ArrayList<Object> resolvedProjections = new ArrayList<Attribute>();
            List<? extends NamedExpression> projections = p.projections();
            if (projections.isEmpty() || projections.size() == 1 && projections.get(0) instanceof UnresolvedStar) {
                resolvedProjections.addAll(childOutput);
            } else {
                LinkedHashMap<Attribute, Integer> priorities = new LinkedHashMap<Attribute, Integer>();
                for (NamedExpression namedExpression : projections) {
                    int priority;
                    List<Attribute> resolved;
                    if (namedExpression instanceof UnresolvedStar) {
                        resolved = childOutput;
                        priority = 2;
                    } else if (namedExpression instanceof UnresolvedNamePattern) {
                        UnresolvedNamePattern up = (UnresolvedNamePattern)namedExpression;
                        resolved = Analyzer.resolveAgainstList(up, childOutput);
                        priority = 1;
                    } else if (namedExpression instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                        resolved = Analyzer.resolveAgainstList(ua, childOutput);
                        priority = 0;
                    } else {
                        throw new EsqlIllegalArgumentException("unexpected projection: " + String.valueOf(namedExpression));
                    }
                    for (Attribute attr : resolved) {
                        Integer previousPrio = (Integer)priorities.get(attr);
                        if (previousPrio != null && previousPrio < priority) continue;
                        priorities.remove(attr);
                        priorities.put(attr, priority);
                    }
                }
                resolvedProjections = new ArrayList(priorities.keySet());
            }
            return new EsqlProject(p.source(), p.child(), resolvedProjections);
        }

        private LogicalPlan resolveDrop(Drop drop, List<Attribute> childOutput) {
            ArrayList<Attribute> resolvedProjections = new ArrayList<Attribute>(childOutput);
            for (NamedExpression ne : drop.removals()) {
                List<NamedExpression> resolved;
                if (ne instanceof UnresolvedNamePattern) {
                    UnresolvedNamePattern np = (UnresolvedNamePattern)ne;
                    resolved = Analyzer.resolveAgainstList(np, childOutput);
                } else if (ne instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)ne;
                    resolved = Analyzer.resolveAgainstList(ua, childOutput);
                } else {
                    resolved = Collections.singletonList(ne);
                }
                resolvedProjections.removeIf(resolved::contains);
                resolved.forEach(r -> {
                    if (!r.resolved() && !(r instanceof UnsupportedAttribute)) {
                        resolvedProjections.add((Attribute)r);
                    }
                });
            }
            return new EsqlProject(drop.source(), drop.child(), resolvedProjections);
        }

        private LogicalPlan resolveRename(Rename rename, List<Attribute> childrenOutput) {
            List<NamedExpression> projections = ResolveRefs.projectionsForRename(rename, childrenOutput, this.log);
            return new EsqlProject(rename.source(), rename.child(), projections);
        }

        public static List<NamedExpression> projectionsForRename(Rename rename, List<Attribute> childrenOutput, Logger logger) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(childrenOutput);
            int renamingsCount = rename.renamings().size();
            ArrayList unresolved = new ArrayList(renamingsCount);
            HashMap reverseAliasing = new HashMap(renamingsCount);
            rename.renamings().forEach(alias -> {
                Expression patt48545$temp = alias.child();
                if (patt48545$temp instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)patt48545$temp;
                    if (!alias.name().equals(ua.name())) {
                        projections.removeIf(x -> x.name().equals(alias.name()));
                        childrenOutput.removeIf(x -> x.name().equals(alias.name()));
                        Attribute resolved = ResolveRefs.maybeResolveAttribute(ua, childrenOutput, logger);
                        if (resolved instanceof UnsupportedAttribute || resolved.resolved()) {
                            Alias realiased = alias.replaceChildren(List.of(resolved));
                            projections.replaceAll(arg_0 -> ResolveRefs.lambda$projectionsForRename$11(resolved, (NamedExpression)realiased, arg_0));
                            childrenOutput.removeIf(x -> x.equals((Object)resolved));
                            reverseAliasing.put(resolved.name(), alias.name());
                        } else {
                            boolean updated = false;
                            if (reverseAliasing.containsValue(resolved.name())) {
                                ListIterator<Alias> li = projections.listIterator();
                                while (li.hasNext()) {
                                    Alias a;
                                    Object patt49941$temp = li.next();
                                    if (!(patt49941$temp instanceof Alias) || !(a = (Alias)patt49941$temp).name().equals(resolved.name())) continue;
                                    reverseAliasing.put(resolved.name(), alias.name());
                                    li.set(alias.replaceChildren(a.children()));
                                    updated = true;
                                    break;
                                }
                            }
                            if (!updated) {
                                Attribute u = resolved;
                                String previousAliasName = (String)reverseAliasing.get(resolved.name());
                                if (previousAliasName != null) {
                                    String message = LoggerMessageFormat.format(null, (String)"Column [{}] renamed to [{}] and is no longer available [{}]", (Object[])new Object[]{resolved.name(), previousAliasName, alias.sourceText()});
                                    u = ua.withUnresolvedMessage(message);
                                }
                                unresolved.add(u);
                            }
                        }
                    }
                }
            });
            projections.addAll(unresolved);
            return projections;
        }

        private LogicalPlan resolveEnrich(Enrich enrich, List<Attribute> childrenOutput) {
            Attribute attribute = enrich.matchField().toAttribute();
            if (attribute instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)attribute;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved.equals((Object)ua)) {
                    return enrich;
                }
                if (resolved.resolved() && enrich.policy() != null) {
                    DataType dataType = resolved.dataType();
                    String matchType = enrich.policy().getType();
                    DataType[] allowed = this.allowedEnrichTypes(matchType);
                    if (!Arrays.asList(allowed).contains(dataType)) {
                        String suffix = "only [" + Arrays.stream(allowed).map(DataType::typeName).collect(Collectors.joining(", ")) + "] allowed for type [" + matchType + "]";
                        resolved = ua.withUnresolvedMessage("Unsupported type [" + resolved.dataType().typeName() + "] for enrich matching field [" + ua.name() + "]; " + suffix);
                    }
                }
                return new Enrich(enrich.source(), enrich.child(), enrich.mode(), enrich.policyName(), (NamedExpression)resolved, enrich.policy(), enrich.concreteIndices(), enrich.enrichFields());
            }
            return enrich;
        }

        private DataType[] allowedEnrichTypes(String matchType) {
            return matchType.equals("geo_match") ? GEO_TYPES : NON_GEO_TYPES;
        }

        private static /* synthetic */ NamedExpression lambda$projectionsForRename$11(Attribute resolved, NamedExpression realiased, NamedExpression x) {
            return x.equals((Object)resolved) ? realiased : x;
        }
    }

    private static class ImplicitCasting
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private ImplicitCasting() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)((Object)plan.transformExpressionsUp(org.elasticsearch.xpack.esql.core.expression.function.Function.class, e -> ImplicitCasting.cast(e, context.functionRegistry().snapshotRegistry())));
        }

        private static Expression cast(org.elasticsearch.xpack.esql.core.expression.function.Function f, EsqlFunctionRegistry registry) {
            if (f instanceof In) {
                In in = (In)f;
                return ImplicitCasting.processIn(in);
            }
            if (f instanceof EsqlScalarFunction || f instanceof GroupingFunction) {
                return ImplicitCasting.processScalarOrGroupingFunction(f, registry);
            }
            if (f instanceof EsqlArithmeticOperation || f instanceof BinaryComparison) {
                return ImplicitCasting.processBinaryOperator((BinaryOperator)f);
            }
            if (f instanceof VectorFunction) {
                VectorFunction vectorFunction = (VectorFunction)f;
                return ImplicitCasting.processVectorFunction(f);
            }
            return f;
        }

        private static Expression processScalarOrGroupingFunction(org.elasticsearch.xpack.esql.core.expression.function.Function f, EsqlFunctionRegistry registry) {
            List args = f.arguments();
            List<DataType> targetDataTypes = registry.getDataTypeForStringLiteralConversion(f.getClass());
            if (targetDataTypes == null || targetDataTypes.isEmpty()) {
                return f;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(args.size());
            boolean childrenChanged = false;
            DataType targetDataType = DataType.NULL;
            DataType targetNumericType = null;
            boolean castNumericArgs = true;
            for (int i = 0; i < args.size(); ++i) {
                Expression arg = (Expression)args.get(i);
                if (arg.resolved()) {
                    DataType dataType = arg.dataType();
                    if (dataType == DataType.KEYWORD) {
                        if (arg.foldable() && !(arg instanceof EsqlScalarFunction)) {
                            Expression e;
                            if (i < targetDataTypes.size()) {
                                targetDataType = targetDataTypes.get(i);
                            }
                            if (targetDataType != DataType.NULL && targetDataType != DataType.UNSUPPORTED && (e = ImplicitCasting.castStringLiteral(arg, targetDataType)) != arg) {
                                childrenChanged = true;
                                newChildren.add(e);
                                continue;
                            }
                        }
                    } else if (dataType.isNumeric() && ImplicitCasting.canCastMixedNumericTypes(f) && castNumericArgs) {
                        if (targetNumericType == null) {
                            targetNumericType = dataType;
                        } else if (dataType != targetNumericType) {
                            castNumericArgs = ImplicitCasting.canCastNumeric(dataType, targetNumericType);
                        }
                    }
                }
                newChildren.add((Expression)args.get(i));
            }
            org.elasticsearch.xpack.esql.core.expression.function.Function resultF = childrenChanged ? (Expression)f.replaceChildren(newChildren) : f;
            return targetNumericType != null && castNumericArgs ? ImplicitCasting.castMixedNumericTypes((EsqlScalarFunction)resultF, targetNumericType) : resultF;
        }

        private static Expression processBinaryOperator(BinaryOperator<?, ?, ?, ?> o) {
            Expression left = o.left();
            Expression right = o.right();
            if (!left.resolved() || !right.resolved()) {
                return o;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(2);
            boolean childrenChanged = false;
            DataType targetDataType = DataType.NULL;
            Literal from = Literal.NULL;
            if (left.dataType() == DataType.KEYWORD && left.foldable() && !(left instanceof EsqlScalarFunction)) {
                if (ImplicitCasting.supportsStringImplicitCasting(right.dataType())) {
                    targetDataType = right.dataType();
                    from = left;
                } else if (ImplicitCasting.supportsImplicitTemporalCasting(right, o)) {
                    targetDataType = DataType.DATETIME;
                    from = left;
                }
            }
            if (right.dataType() == DataType.KEYWORD && right.foldable() && !(right instanceof EsqlScalarFunction)) {
                if (ImplicitCasting.supportsStringImplicitCasting(left.dataType())) {
                    targetDataType = left.dataType();
                    from = right;
                } else if (ImplicitCasting.supportsImplicitTemporalCasting(left, o)) {
                    targetDataType = DataType.DATETIME;
                    from = right;
                }
            }
            if (from != Literal.NULL) {
                Expression e = ImplicitCasting.castStringLiteral((Expression)from, targetDataType);
                newChildren.add(from == left ? e : left);
                newChildren.add(from == right ? e : right);
                childrenChanged = true;
            }
            return childrenChanged ? o.replaceChildren(newChildren) : o;
        }

        private static Expression processIn(In in) {
            Expression left = in.value();
            List<Expression> right = in.list();
            if (!left.resolved() || !ImplicitCasting.supportsStringImplicitCasting(left.dataType())) {
                return in;
            }
            DataType targetDataType = left.dataType();
            ArrayList<Expression> newChildren = new ArrayList<Expression>(right.size() + 1);
            boolean childrenChanged = false;
            for (Expression value : right) {
                if (value.resolved() && value.dataType() == DataType.KEYWORD && value.foldable()) {
                    Expression e = ImplicitCasting.castStringLiteral(value, targetDataType);
                    newChildren.add(e);
                    childrenChanged = true;
                    continue;
                }
                newChildren.add(value);
            }
            newChildren.add(left);
            return childrenChanged ? in.replaceChildren(newChildren) : in;
        }

        private static boolean canCastMixedNumericTypes(org.elasticsearch.xpack.esql.core.expression.function.Function f) {
            return f instanceof Coalesce || f instanceof Case || f instanceof Greatest || f instanceof Least;
        }

        private static boolean canCastNumeric(DataType from, DataType to) {
            DataType commonType = EsqlDataTypeConverter.commonType(from, to);
            return commonType == to;
        }

        private static Expression castMixedNumericTypes(EsqlScalarFunction f, DataType targetNumericType) {
            ArrayList<Object> newChildren = new ArrayList<Object>(f.children().size());
            boolean childrenChanged = false;
            block6: for (Expression e : f.children()) {
                if (e.resolved()) {
                    DataType childDataType = e.dataType();
                    if (!childDataType.isNumeric() || childDataType == targetNumericType || !ImplicitCasting.canCastNumeric(childDataType, targetNumericType)) {
                        newChildren.add(e);
                        continue;
                    }
                    childrenChanged = true;
                    switch (targetNumericType) {
                        case INTEGER: {
                            newChildren.add(new ToInteger(e.source(), e));
                            continue block6;
                        }
                        case LONG: {
                            newChildren.add(new ToLong(e.source(), e));
                            continue block6;
                        }
                        case DOUBLE: {
                            newChildren.add(new ToDouble(e.source(), e));
                            continue block6;
                        }
                        case UNSIGNED_LONG: {
                            newChildren.add(new ToUnsignedLong(e.source(), e));
                            continue block6;
                        }
                    }
                    throw new EsqlIllegalArgumentException("unexpected data type: " + String.valueOf(targetNumericType));
                }
                newChildren.add(e);
            }
            return childrenChanged ? (Expression)f.replaceChildren(newChildren) : f;
        }

        private static boolean supportsImplicitTemporalCasting(Expression e, BinaryOperator<?, ?, ?, ?> o) {
            return DataType.isTemporalAmount((DataType)e.dataType()) && o instanceof DateTimeArithmeticOperation;
        }

        private static boolean supportsStringImplicitCasting(DataType type) {
            return type == DataType.DATETIME || type == DataType.DATE_NANOS || type == DataType.IP || type == DataType.VERSION || type == DataType.BOOLEAN;
        }

        private static UnresolvedAttribute unresolvedAttribute(Expression value, String type, Exception e) {
            String string;
            String name = BytesRefs.toString((Object)value.fold(FoldContext.small()));
            Object[] objectArray = new Object[3];
            objectArray[0] = name;
            objectArray[1] = type;
            if (e instanceof ParsingException) {
                ParsingException pe = (ParsingException)((Object)e);
                string = pe.getErrorMessage();
            } else {
                string = e.getMessage();
            }
            objectArray[2] = string;
            String message = LoggerMessageFormat.format(null, (String)"Cannot convert string [{}] to [{}], error [{}]", (Object[])objectArray);
            return new UnresolvedAttribute(value.source(), name, message);
        }

        private static Expression castStringLiteralToTemporalAmount(Expression from) {
            try {
                TemporalAmount result = EsqlDataTypeConverter.maybeParseTemporalAmount(BytesRefs.toString((Object)from.fold(FoldContext.small())).strip());
                if (result == null) {
                    return from;
                }
                DataType target = result instanceof Duration ? DataType.TIME_DURATION : DataType.DATE_PERIOD;
                return new Literal(from.source(), (Object)result, target);
            }
            catch (Exception e) {
                return ImplicitCasting.unresolvedAttribute(from, String.valueOf(DataType.DATE_PERIOD) + " or " + String.valueOf(DataType.TIME_DURATION), e);
            }
        }

        private static Expression castStringLiteral(Expression from, DataType target) {
            assert (from.foldable());
            try {
                return DataType.isTemporalAmount((DataType)target) ? ImplicitCasting.castStringLiteralToTemporalAmount(from) : new Literal(from.source(), EsqlDataTypeConverter.convert(from.fold(FoldContext.small()), target), target);
            }
            catch (Exception e) {
                return ImplicitCasting.unresolvedAttribute(from, target.toString(), e);
            }
        }

        private static Expression processVectorFunction(org.elasticsearch.xpack.esql.core.expression.function.Function vectorFunction) {
            List args = vectorFunction.arguments();
            ArrayList<Object> newArgs = new ArrayList<Object>();
            for (Expression arg : args) {
                Object folded;
                if (arg.resolved() && arg.dataType().isNumeric() && arg.foldable() && (folded = arg.fold(FoldContext.small())) instanceof List) {
                    Literal denseVector = new Literal(arg.source(), folded, DataType.DENSE_VECTOR);
                    newArgs.add(denseVector);
                    continue;
                }
                newArgs.add(arg);
            }
            return (Expression)vectorFunction.replaceChildren(newArgs);
        }
    }

    private static class AddImplicitLimit
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private AddImplicitLimit() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan logicalPlan, AnalyzerContext context) {
            int limit;
            List limits = logicalPlan.collectFirstChildren(Limit.class::isInstance);
            if (limits.isEmpty()) {
                HeaderWarning.addWarning((String)"No limit defined, adding default limit of [{}]", (Object[])new Object[]{context.configuration().resultTruncationDefaultSize()});
                limit = context.configuration().resultTruncationDefaultSize();
            } else {
                limit = context.configuration().resultTruncationMaxSize();
            }
            Source source = logicalPlan.source();
            return new Limit(source, (Expression)new Literal(source, (Object)limit, DataType.INTEGER), logicalPlan);
        }
    }

    private static class UnionTypesCleanup
    extends Rule<LogicalPlan, LogicalPlan> {
        private UnionTypesCleanup() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            LogicalPlan planWithCheckedUnionTypes = (LogicalPlan)plan.transformUp(LogicalPlan.class, p -> (LogicalPlan)((Object)((Object)p.transformExpressionsOnly(FieldAttribute.class, UnionTypesCleanup::checkUnresolved))));
            return planWithCheckedUnionTypes.resolved() ? UnionTypesCleanup.planWithoutSyntheticAttributes(planWithCheckedUnionTypes) : planWithCheckedUnionTypes;
        }

        static Attribute checkUnresolved(FieldAttribute fa) {
            EsField esField = fa.field();
            if (esField instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)esField;
                String unresolvedMessage = "Cannot use field [" + fa.name() + "] due to ambiguities being " + imf.errorMessage();
                List types = imf.getTypesToIndices().keySet().stream().toList();
                return new UnsupportedAttribute(fa.source(), fa.name(), new UnsupportedEsField(imf.getName(), types), unresolvedMessage, fa.id());
            }
            return fa;
        }

        private static LogicalPlan planWithoutSyntheticAttributes(LogicalPlan plan) {
            List<Attribute> output = plan.output();
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>(output.size());
            for (Attribute attr : output) {
                if (attr.synthetic() && attr instanceof FieldAttribute) continue;
                newOutput.add(attr);
            }
            return newOutput.size() == output.size() ? plan : new Project(Source.EMPTY, plan, newOutput);
        }
    }
}

