/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseStream;

class ActiveRepositoryVerifyIntegrityTasks {
    private final Map<Long, RepositoryVerifyIntegrityResponseStream> responseStreamsByCoordinatingTaskId = ConcurrentCollections.newConcurrentMap();

    ActiveRepositoryVerifyIntegrityTasks() {
    }

    Releasable registerResponseBuilder(long coordinatingTaskId, RepositoryVerifyIntegrityResponseStream responseStream) {
        assert (responseStream.hasReferences());
        RepositoryVerifyIntegrityResponseStream previous = this.responseStreamsByCoordinatingTaskId.putIfAbsent(coordinatingTaskId, responseStream);
        if (previous != null) {
            IllegalStateException exception = new IllegalStateException("already executing verify task [" + coordinatingTaskId + "]");
            assert (false) : exception;
            throw exception;
        }
        return Releasables.assertOnce(() -> {
            boolean removed = this.responseStreamsByCoordinatingTaskId.remove(coordinatingTaskId, (Object)responseStream);
            if (!removed) {
                IllegalStateException exception = new IllegalStateException("already completed verify task [" + coordinatingTaskId + "]");
                assert (false) : exception;
                throw exception;
            }
        });
    }

    RepositoryVerifyIntegrityResponseStream acquireResponseStream(long taskId) {
        RepositoryVerifyIntegrityResponseStream outerRequest = this.responseStreamsByCoordinatingTaskId.get(taskId);
        if (outerRequest == null || !outerRequest.tryIncRef()) {
            throw new ResourceNotFoundException("verify task [" + taskId + "] not found", new Object[0]);
        }
        return outerRequest;
    }
}

