/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.MatcherWatchdog;
import org.joni.Matcher;

public class TimeoutChecker
implements Closeable {
    private static final TimeoutCheckerWatchdog timeoutCheckerWatchdog = new TimeoutCheckerWatchdog();
    public static final MatcherWatchdog watchdog = timeoutCheckerWatchdog;
    private final String operation;
    private final TimeValue timeout;
    private final Thread checkedThread;
    private final ScheduledFuture<?> future;
    private boolean isClosed;
    private volatile boolean timeoutExceeded;

    public TimeoutChecker(String operation, TimeValue timeout, ScheduledExecutorService scheduler) {
        this.operation = operation;
        this.timeout = timeout;
        this.checkedThread = Thread.currentThread();
        timeoutCheckerWatchdog.add(this.checkedThread, timeout);
        this.future = timeout != null ? scheduler.schedule(this::setTimeoutExceeded, timeout.nanos(), TimeUnit.NANOSECONDS) : null;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        FutureUtils.cancel(this.future);
        timeoutCheckerWatchdog.remove(this.checkedThread);
        this.isClosed = true;
    }

    public void check(String where) {
        if (this.timeoutExceeded) {
            throw new ElasticsearchTimeoutException("Aborting " + this.operation + " during [" + where + "] as it has taken longer than the timeout of [" + String.valueOf(this.timeout) + "]", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> grokCaptures(Grok grok, String text, String where) {
        try {
            Map map = grok.captures(text);
            return map;
        }
        finally {
            this.check(where);
        }
    }

    private synchronized void setTimeoutExceeded() {
        if (this.isClosed) {
            return;
        }
        this.timeoutExceeded = true;
        timeoutCheckerWatchdog.interruptLongRunningThreadIfRegistered(this.checkedThread);
    }

    static class TimeoutCheckerWatchdog
    implements MatcherWatchdog {
        final ConcurrentHashMap<Thread, WatchDogEntry> registry = new ConcurrentHashMap();

        TimeoutCheckerWatchdog() {
        }

        void add(Thread thread, TimeValue timeout) {
            WatchDogEntry previousValue = this.registry.put(thread, new WatchDogEntry(timeout));
            assert (previousValue == null);
        }

        public synchronized void register(Matcher matcher) {
            WatchDogEntry value = this.registry.get(Thread.currentThread());
            if (value != null) {
                boolean wasFalse = value.registered.compareAndSet(false, true);
                assert (wasFalse);
                value.matchers.add(matcher);
                if (value.isTimedOut()) {
                    matcher.interrupt();
                }
            }
        }

        public long maxExecutionTimeInMillis() {
            WatchDogEntry value = this.registry.get(Thread.currentThread());
            return value != null ? value.timeout.getMillis() : Long.MAX_VALUE;
        }

        public void unregister(Matcher matcher) {
            WatchDogEntry value = this.registry.get(Thread.currentThread());
            if (value != null) {
                boolean wasTrue = value.registered.compareAndSet(true, false);
                assert (wasTrue);
                value.matchers.remove(matcher);
            }
        }

        void remove(Thread thread) {
            WatchDogEntry previousValue = this.registry.remove(thread);
            assert (previousValue != null);
        }

        synchronized void interruptLongRunningThreadIfRegistered(Thread thread) {
            WatchDogEntry value = this.registry.get(thread);
            value.timedOut();
            if (value.registered.get()) {
                for (Matcher matcher : value.matchers) {
                    matcher.interrupt();
                }
            }
        }

        static class WatchDogEntry {
            final TimeValue timeout;
            final AtomicBoolean registered;
            final Collection<Matcher> matchers;
            boolean timedOut;

            WatchDogEntry(TimeValue timeout) {
                this.timeout = timeout;
                this.registered = new AtomicBoolean(false);
                this.matchers = new CopyOnWriteArrayList<Matcher>();
            }

            private void timedOut() {
                this.timedOut = true;
            }

            private boolean isTimedOut() {
                return this.timedOut;
            }
        }
    }
}

