/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodeMessage
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncodeMessage.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, MessageEncoder> encoderFactory;
    @Nullable
    private MessageHandler messageHandler;
    @Nullable
    private MessageContext msgContext;

    public void setMessageEncoderFactory(@Nonnull Function<ProfileRequestContext, MessageEncoder> factory) {
        this.encoderFactory = (Function)Constraint.isNotNull(factory, (String)"MessageEncoderFactory cannot be null");
    }

    public void setMessageHandler(@Nullable MessageHandler handler) {
        this.messageHandler = handler;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encoderFactory == null) {
            throw new ComponentInitializationException("MessageEncoderFactory cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.msgContext = profileRequestContext.getOutboundMessageContext();
        if (this.msgContext == null) {
            this.log.debug("{} Outbound message context was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageEncoder encoder = this.encoderFactory.apply(profileRequestContext);
        if (encoder == null) {
            this.log.error("{} Unable to locate an outbound message encoder", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
            return;
        }
        try {
            this.log.debug("{} Encoding outbound response using message encoder of type {} for this response", (Object)this.getLogPrefix(), (Object)encoder.getClass().getName());
            if (!encoder.isInitialized()) {
                this.log.debug("{} Encoder was not initialized, injecting MessageContext and initializing", (Object)this.getLogPrefix());
                encoder.setMessageContext(this.msgContext);
                encoder.initialize();
            } else {
                this.log.debug("{} Encoder was already initialized, skipping MessageContext injection and init", (Object)this.getLogPrefix());
            }
            encoder.prepareContext();
            if (this.messageHandler != null) {
                this.log.debug("{} Invoking message handler of type {} for this response", (Object)this.getLogPrefix(), (Object)this.messageHandler.getClass().getName());
                this.messageHandler.invoke(this.msgContext);
            }
            encoder.encode();
            if (this.msgContext.getMessage() != null) {
                this.log.debug("{} Outbound message encoded from a message of type {}", (Object)this.getLogPrefix(), (Object)this.msgContext.getMessage().getClass().getName());
            } else {
                this.log.debug("{} Outbound message was encoded from protocol-specific data rather than MessageContext#getMessage()", (Object)this.getLogPrefix());
            }
        }
        catch (ComponentInitializationException | MessageEncodingException | MessageHandlerException e) {
            this.log.error("{} Unable to encode outbound response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
        }
        finally {
            encoder.destroy();
        }
    }
}

