/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.sort.SortOrder;

public abstract class NumericMetricsAggregator
extends MetricsAggregator {
    private NumericMetricsAggregator(String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
    }

    public static abstract class MultiDoubleValue
    extends MultiValue {
        private final ValuesSource.Numeric valuesSource;

        protected MultiDoubleValue(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
            this.valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
        }

        @Override
        public ScoreMode scoreMode() {
            return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        }

        @Override
        public final LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
            NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
            return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
        }

        protected abstract LeafBucketCollector getLeafCollector(SortedNumericDoubleValues var1, LeafBucketCollector var2);

        protected abstract LeafBucketCollector getLeafCollector(NumericDoubleValues var1, LeafBucketCollector var2);
    }

    public static abstract class MultiValue
    extends NumericMetricsAggregator {
        protected MultiValue(String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
        }

        public abstract boolean hasMetric(String var1);

        public abstract double metric(String var1, long var2);

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key == null) {
                throw new IllegalArgumentException("When ordering on a multi-value metrics aggregation a metric name must be specified.");
            }
            if (!this.hasMetric(key)) {
                throw new IllegalArgumentException("Unknown metric name [" + key + "] on multi-value metrics aggregation [" + this.name() + "]");
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN(this.metric(key, lhs), this.metric(key, rhs), order == SortOrder.ASC);
        }
    }

    public static abstract class SingleDoubleValue
    extends SingleValue {
        private final ValuesSource.Numeric valuesSource;

        protected SingleDoubleValue(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
            this.valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
        }

        @Override
        public ScoreMode scoreMode() {
            return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        }

        @Override
        public final LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
            NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
            return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
        }

        protected abstract LeafBucketCollector getLeafCollector(SortedNumericDoubleValues var1, LeafBucketCollector var2);

        protected abstract LeafBucketCollector getLeafCollector(NumericDoubleValues var1, LeafBucketCollector var2);
    }

    public static abstract class SingleValue
    extends NumericMetricsAggregator {
        protected SingleValue(String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, metadata);
        }

        public abstract double metric(long var1);

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key != null && !"value".equals(key)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Ordering on a single-value metrics aggregation can only be done on its value. Either drop the key (a la \"%s\") or change it to \"value\" (a la \"%s.value\")", this.name(), this.name()));
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN(this.metric(lhs), this.metric(rhs), order == SortOrder.ASC);
        }
    }
}

