/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.MergedPointRangeQuery;
import org.elasticsearch.search.internal.CancellableBulkScorer;

public class QueryToFilterAdapter {
    private final IndexSearcher searcher;
    private final String key;
    private final Query query;
    private Weight weight;
    protected int segmentsCountedInConstantTime;

    public static QueryToFilterAdapter build(IndexSearcher searcher, String key, Query query) throws IOException {
        if ((query = searcher.rewrite((Query)new ConstantScoreQuery(query))) instanceof ConstantScoreQuery) {
            query = ((ConstantScoreQuery)query).getQuery();
        }
        return new QueryToFilterAdapter(searcher, key, query);
    }

    QueryToFilterAdapter(IndexSearcher searcher, String key, Query query) {
        this.searcher = searcher;
        this.key = key;
        this.query = query;
    }

    Query query() {
        return this.query;
    }

    public boolean isInefficientUnion() {
        return false;
    }

    public final String key() {
        return this.key;
    }

    protected final IndexSearcher searcher() {
        return this.searcher;
    }

    QueryToFilterAdapter union(Query extraQuery) throws IOException {
        Query merged;
        extraQuery = this.searcher().rewrite((Query)new ConstantScoreQuery(extraQuery));
        Query unwrappedExtraQuery = QueryToFilterAdapter.unwrap(extraQuery);
        Query unwrappedQuery = QueryToFilterAdapter.unwrap(this.query);
        if (unwrappedQuery instanceof PointRangeQuery && unwrappedExtraQuery instanceof PointRangeQuery && (merged = MergedPointRangeQuery.merge((PointRangeQuery)unwrappedQuery, (PointRangeQuery)unwrappedExtraQuery)) != null) {
            return new QueryToFilterAdapter(this.searcher(), this.key(), merged);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query, BooleanClause.Occur.FILTER);
        builder.add(extraQuery, BooleanClause.Occur.FILTER);
        Query rewrittenUnion = this.searcher().rewrite((Query)new ConstantScoreQuery((Query)builder.build()));
        if (rewrittenUnion instanceof ConstantScoreQuery) {
            rewrittenUnion = ((ConstantScoreQuery)rewrittenUnion).getQuery();
        }
        final boolean inefficientUnion = rewrittenUnion instanceof BooleanQuery;
        return new QueryToFilterAdapter(this.searcher(), this.key(), rewrittenUnion){

            @Override
            public boolean isInefficientUnion() {
                return inefficientUnion;
            }
        };
    }

    private static Query unwrap(Query query) {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (query instanceof IndexSortSortedNumericDocValuesRangeQuery) {
                query = ((IndexSortSortedNumericDocValuesRangeQuery)query).getFallbackQuery();
                continue;
            }
            if (!(query instanceof IndexOrDocValuesQuery)) break;
            query = ((IndexOrDocValuesQuery)query).getIndexQuery();
        }
        return query;
    }

    Scorer randomAccessScorer(LeafReaderContext ctx) throws IOException {
        Weight weight = this.weight();
        ScorerSupplier scorerSupplier = weight.scorerSupplier(ctx);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(0L);
    }

    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live, Runnable checkCancelled) throws IOException {
        int count;
        if (counter.docCount.alwaysOne() && (count = this.weight().count(ctx)) != -1) {
            ++this.segmentsCountedInConstantTime;
            return count;
        }
        BulkScorer scorer = this.weight().bulkScorer(ctx);
        if (scorer == null) {
            return 0L;
        }
        CancellableBulkScorer cancellableScorer = new CancellableBulkScorer(scorer, checkCancelled);
        cancellableScorer.score(counter, live);
        return counter.readAndReset(ctx);
    }

    void collect(LeafReaderContext ctx, LeafCollector collector, Bits live, Runnable checkCancelled) throws IOException {
        BulkScorer scorer = this.weight().bulkScorer(ctx);
        if (scorer == null) {
            return;
        }
        CancellableBulkScorer cancellableScorer = new CancellableBulkScorer(scorer, checkCancelled);
        cancellableScorer.score(collector, live);
    }

    void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("query", this.query.toString());
        add.accept("segments_counted_in_constant_time", this.segmentsCountedInConstantTime);
    }

    private Weight weight() throws IOException {
        if (this.weight == null) {
            this.weight = this.searcher().createWeight(this.query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return this.weight;
    }

    static boolean matchesNoDocs(List<QueryToFilterAdapter> filters) {
        for (QueryToFilterAdapter filter : filters) {
            if (filter.query() instanceof MatchNoDocsQuery) continue;
            return false;
        }
        return true;
    }
}

