/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.VectorScorer;

public class DenormalizedCosineFloatVectorValues
extends FloatVectorValues {
    private final FloatVectorValues in;
    private final NumericDocValues magnitudeIn;
    private final float[] vector;
    private float magnitude = 1.0f;
    private boolean hasMagnitude;
    private int docId = -1;

    public DenormalizedCosineFloatVectorValues(FloatVectorValues in, NumericDocValues magnitudeIn) {
        this.in = in;
        this.magnitudeIn = magnitudeIn;
        this.vector = new float[in.dimension()];
    }

    public int dimension() {
        return this.in.dimension();
    }

    public int size() {
        return this.in.size();
    }

    public float[] vectorValue() throws IOException {
        return this.vectorValue(this.in.docID());
    }

    public int docID() {
        return this.in.docID();
    }

    public int nextDoc() throws IOException {
        return this.in.nextDoc();
    }

    public int advance(int target) throws IOException {
        return this.in.advance(target);
    }

    public VectorScorer scorer(float[] floats) throws IOException {
        return this.in.scorer(floats);
    }

    public float magnitude() {
        return this.magnitude;
    }

    private float[] vectorValue(int docId) throws IOException {
        if (docId != this.docId) {
            this.docId = docId;
            this.hasMagnitude = this.decodedMagnitude(docId);
            if (this.hasMagnitude) {
                System.arraycopy(this.in.vectorValue(), 0, this.vector, 0, this.dimension());
                int i = 0;
                while (i < this.vector.length) {
                    int n = i++;
                    this.vector[n] = this.vector[n] * this.magnitude;
                }
                return this.vector;
            }
            return this.in.vectorValue();
        }
        return this.hasMagnitude ? this.vector : this.in.vectorValue();
    }

    private boolean decodedMagnitude(int docId) throws IOException {
        if (this.magnitudeIn == null) {
            return false;
        }
        int currentDoc = this.magnitudeIn.docID();
        if (docId == currentDoc) {
            return true;
        }
        if (this.magnitudeIn.advanceExact(docId)) {
            this.magnitude = Float.intBitsToFloat((int)this.magnitudeIn.longValue());
            return true;
        }
        this.magnitude = 1.0f;
        return false;
    }
}

