/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;
import org.elasticsearch.index.codec.tsdb.es819.DocValuesConsumerUtil;
import org.elasticsearch.index.codec.tsdb.es819.TsdbDocValuesProducer;

public abstract class XDocValuesConsumer
extends DocValuesConsumer {
    protected XDocValuesConsumer() {
    }

    public void mergeNumericField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addNumericField(mergeFieldInfo, (DocValuesProducer)new TsdbDocValuesProducer(mergeStats){

            public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                ArrayList<NumericDocValuesSub> subs = new ArrayList<NumericDocValuesSub>();
                assert (mergeState.docMaps.length == mergeState.docValuesProducers.length);
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    NumericDocValues values = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                        values = docValuesProducer.getNumeric(readerFieldInfo);
                    }
                    if (values == null) continue;
                    subs.add(new NumericDocValuesSub(mergeState.docMaps[i], values));
                }
                return XDocValuesConsumer.mergeNumericValues(subs, mergeState.needsIndexSort);
            }
        });
    }

    private static NumericDocValues mergeNumericValues(List<NumericDocValuesSub> subs, boolean indexIsSorted) throws IOException {
        long cost = 0L;
        for (NumericDocValuesSub sub : subs) {
            cost += sub.values.cost();
        }
        final long finalCost = cost;
        final DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)indexIsSorted);
        return new NumericDocValues(){
            private int docID = -1;
            private NumericDocValuesSub current;

            public int docID() {
                return this.docID;
            }

            public int nextDoc() throws IOException {
                this.current = (NumericDocValuesSub)docIDMerger.next();
                this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docID;
            }

            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean advanceExact(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                return finalCost;
            }

            public long longValue() throws IOException {
                return this.current.values.longValue();
            }
        };
    }

    public void mergeBinaryField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addBinaryField(mergeFieldInfo, (DocValuesProducer)new TsdbDocValuesProducer(mergeStats){

            public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>();
                long cost = 0L;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    BinaryDocValues values = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                        values = docValuesProducer.getBinary(readerFieldInfo);
                    }
                    if (values == null) continue;
                    cost += values.cost();
                    subs.add(new BinaryDocValuesSub(mergeState.docMaps[i], values));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)mergeState.needsIndexSort);
                final long finalCost = cost;
                return new BinaryDocValues(){
                    private BinaryDocValuesSub current;
                    private int docID = -1;

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        this.current = (BinaryDocValuesSub)docIDMerger.next();
                        this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long cost() {
                        return finalCost;
                    }

                    public BytesRef binaryValue() throws IOException {
                        return this.current.values.binaryValue();
                    }
                };
            }
        });
    }

    public void mergeSortedNumericField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addSortedNumericField(mergeFieldInfo, (DocValuesProducer)new TsdbDocValuesProducer(mergeStats){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedNumericDocValuesSub> subs = new ArrayList<SortedNumericDocValuesSub>();
                long cost = 0L;
                boolean allSingletons = true;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    SortedNumericDocValues values = null;
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                        values = docValuesProducer.getSortedNumeric(readerFieldInfo);
                    }
                    if (values == null) {
                        values = DocValues.emptySortedNumeric();
                    }
                    cost += values.cost();
                    if (allSingletons && DocValues.unwrapSingleton((SortedNumericDocValues)values) == null) {
                        allSingletons = false;
                    }
                    subs.add(new SortedNumericDocValuesSub(mergeState.docMaps[i], values));
                }
                if (allSingletons) {
                    ArrayList<NumericDocValuesSub> singleValuedSubs = new ArrayList<NumericDocValuesSub>();
                    for (SortedNumericDocValuesSub sub : subs) {
                        NumericDocValues singleValuedValues = DocValues.unwrapSingleton((SortedNumericDocValues)sub.values);
                        assert (singleValuedValues != null);
                        singleValuedSubs.add(new NumericDocValuesSub(sub.docMap, singleValuedValues));
                    }
                    return DocValues.singleton((NumericDocValues)XDocValuesConsumer.mergeNumericValues(singleValuedSubs, mergeState.needsIndexSort));
                }
                final long finalCost = cost;
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)mergeState.needsIndexSort);
                return new SortedNumericDocValues(){
                    private int docID = -1;
                    private SortedNumericDocValuesSub currentSub;

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        this.currentSub = (SortedNumericDocValuesSub)docIDMerger.next();
                        this.docID = this.currentSub == null ? Integer.MAX_VALUE : this.currentSub.mappedDocID;
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public int docValueCount() {
                        return this.currentSub.values.docValueCount();
                    }

                    public long cost() {
                        return finalCost;
                    }

                    public long nextValue() throws IOException {
                        return this.currentSub.values.nextValue();
                    }
                };
            }
        });
    }

    public void mergeSortedField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo fieldInfo, final MergeState mergeState) throws IOException {
        ArrayList<SortedDocValues> toMerge = new ArrayList<SortedDocValues>();
        for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            FieldInfo readerFieldInfo;
            SortedDocValues values = null;
            DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
            if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                values = docValuesProducer.getSorted(readerFieldInfo);
            }
            if (values == null) {
                values = DocValues.emptySorted();
            }
            toMerge.add(values);
        }
        int numReaders = toMerge.size();
        SortedDocValues[] dvs = toMerge.toArray(new SortedDocValues[numReaders]);
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < numReaders; ++sub) {
            int docID;
            SortedDocValues dv = dvs[sub];
            Bits liveDocs = mergeState.liveDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet((long)dv.getValueCount());
            while ((docID = dv.nextDoc()) != Integer.MAX_VALUE) {
                int ord;
                if (!liveDocs.get(docID) || (ord = dv.ordValue()) < 0) continue;
                bitset.set((long)ord);
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final OrdinalMap map = OrdinalMap.build(null, (TermsEnum[])liveTerms, (long[])weights, (float)0.0f);
        this.addSortedField(fieldInfo, (DocValuesProducer)new TsdbDocValuesProducer(mergeStats){

            @Override
            public SortedDocValues getSorted(FieldInfo fieldInfoIn) throws IOException {
                if (fieldInfoIn != fieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedDocValuesSub> subs = new ArrayList<SortedDocValuesSub>();
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    SortedDocValues values = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                        values = docValuesProducer.getSorted(readerFieldInfo);
                    }
                    if (values == null) {
                        values = DocValues.emptySorted();
                    }
                    subs.add(new SortedDocValuesSub(mergeState.docMaps[i], values, map.getGlobalOrds(i)));
                }
                return XDocValuesConsumer.mergeSortedValues(subs, mergeState.needsIndexSort, map);
            }
        });
    }

    private static SortedDocValues mergeSortedValues(final List<SortedDocValuesSub> subs, boolean indexIsSorted, final OrdinalMap map) throws IOException {
        long cost = 0L;
        for (SortedDocValuesSub sub : subs) {
            cost += sub.values.cost();
        }
        final long finalCost = cost;
        final DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)indexIsSorted);
        return new SortedDocValues(){
            private int docID = -1;
            private SortedDocValuesSub current;

            public int docID() {
                return this.docID;
            }

            public int nextDoc() throws IOException {
                this.current = (SortedDocValuesSub)docIDMerger.next();
                this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docID;
            }

            public int ordValue() throws IOException {
                int subOrd = this.current.values.ordValue();
                assert (subOrd != -1);
                return (int)this.current.map.get((long)subOrd);
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public boolean advanceExact(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                return finalCost;
            }

            public int getValueCount() {
                return (int)map.getValueCount();
            }

            public BytesRef lookupOrd(int ord) throws IOException {
                int segmentNumber = map.getFirstSegmentNumber((long)ord);
                int segmentOrd = (int)map.getFirstSegmentOrd((long)ord);
                return ((SortedDocValuesSub)((Object)subs.get((int)segmentNumber))).values.lookupOrd(segmentOrd);
            }

            public TermsEnum termsEnum() throws IOException {
                TermsEnum[] termsEnurmSubs = new TermsEnum[subs.size()];
                for (int sub = 0; sub < termsEnurmSubs.length; ++sub) {
                    termsEnurmSubs[sub] = ((SortedDocValuesSub)((Object)subs.get((int)sub))).values.termsEnum();
                }
                return new MergedTermsEnum(map, termsEnurmSubs);
            }
        };
    }

    public void mergeSortedSetField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        final ArrayList<SortedSetDocValues> toMerge = new ArrayList<SortedSetDocValues>();
        for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            FieldInfo fieldInfo;
            SortedSetDocValues values = null;
            DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
            if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                values = docValuesProducer.getSortedSet(fieldInfo);
            }
            if (values == null) {
                values = DocValues.emptySortedSet();
            }
            toMerge.add(values);
        }
        TermsEnum[] liveTerms = new TermsEnum[toMerge.size()];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < liveTerms.length; ++sub) {
            int docID;
            SortedSetDocValues dv = (SortedSetDocValues)toMerge.get(sub);
            Bits liveDocs = mergeState.liveDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            while ((docID = dv.nextDoc()) != Integer.MAX_VALUE) {
                if (!liveDocs.get(docID)) continue;
                for (int i = 0; i < dv.docValueCount(); ++i) {
                    bitset.set(dv.nextOrd());
                }
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final OrdinalMap map = OrdinalMap.build(null, (TermsEnum[])liveTerms, (long[])weights, (float)0.0f);
        this.addSortedSetField(mergeFieldInfo, (DocValuesProducer)new TsdbDocValuesProducer(mergeStats){

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedSetDocValuesSub> subs = new ArrayList<SortedSetDocValuesSub>();
                long cost = 0L;
                boolean allSingletons = true;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    SortedSetDocValues values = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                        values = docValuesProducer.getSortedSet(readerFieldInfo);
                    }
                    if (values == null) {
                        values = DocValues.emptySortedSet();
                    }
                    cost += values.cost();
                    if (allSingletons && DocValues.unwrapSingleton((SortedSetDocValues)values) == null) {
                        allSingletons = false;
                    }
                    subs.add(new SortedSetDocValuesSub(mergeState.docMaps[i], values, map.getGlobalOrds(i)));
                }
                if (allSingletons) {
                    ArrayList<SortedDocValuesSub> singleValuedSubs = new ArrayList<SortedDocValuesSub>();
                    for (SortedSetDocValuesSub sub : subs) {
                        SortedDocValues singleValuedValues = DocValues.unwrapSingleton((SortedSetDocValues)sub.values);
                        assert (singleValuedValues != null);
                        singleValuedSubs.add(new SortedDocValuesSub(sub.docMap, singleValuedValues, sub.map));
                    }
                    return DocValues.singleton((SortedDocValues)XDocValuesConsumer.mergeSortedValues(singleValuedSubs, mergeState.needsIndexSort, map));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, (boolean)mergeState.needsIndexSort);
                final long finalCost = cost;
                return new SortedSetDocValues(){
                    private int docID = -1;
                    private SortedSetDocValuesSub currentSub;

                    public int docID() {
                        return this.docID;
                    }

                    public int nextDoc() throws IOException {
                        this.currentSub = (SortedSetDocValuesSub)docIDMerger.next();
                        this.docID = this.currentSub == null ? Integer.MAX_VALUE : this.currentSub.mappedDocID;
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public long nextOrd() throws IOException {
                        long subOrd = this.currentSub.values.nextOrd();
                        return this.currentSub.map.get(subOrd);
                    }

                    public int docValueCount() {
                        return this.currentSub.values.docValueCount();
                    }

                    public long cost() {
                        return finalCost;
                    }

                    public BytesRef lookupOrd(long ord) throws IOException {
                        int segmentNumber = map.getFirstSegmentNumber(ord);
                        long segmentOrd = map.getFirstSegmentOrd(ord);
                        return ((SortedSetDocValues)toMerge.get(segmentNumber)).lookupOrd(segmentOrd);
                    }

                    public long getValueCount() {
                        return map.getValueCount();
                    }

                    public TermsEnum termsEnum() throws IOException {
                        TermsEnum[] subs = new TermsEnum[toMerge.size()];
                        for (int sub = 0; sub < subs.length; ++sub) {
                            subs[sub] = ((SortedSetDocValues)toMerge.get(sub)).termsEnum();
                        }
                        return new MergedTermsEnum(map, subs);
                    }
                };
            }
        });
    }

    private static class NumericDocValuesSub
    extends DocIDMerger.Sub {
        final NumericDocValues values;

        NumericDocValuesSub(MergeState.DocMap docMap, NumericDocValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    static class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        final LongBitSet liveTerms;

        BitsFilteredTermsEnum(TermsEnum in, LongBitSet liveTerms) {
            super(in, false);
            assert (liveTerms != null);
            this.liveTerms = liveTerms;
        }

        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            if (this.liveTerms.get(this.ord())) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    private static class SortedDocValuesSub
    extends DocIDMerger.Sub {
        final SortedDocValues values;
        final LongValues map;

        SortedDocValuesSub(MergeState.DocMap docMap, SortedDocValues values, LongValues map) {
            super(docMap);
            this.values = values;
            this.map = map;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class SortedSetDocValuesSub
    extends DocIDMerger.Sub {
        final SortedSetDocValues values;
        final LongValues map;

        SortedSetDocValuesSub(MergeState.DocMap docMap, SortedSetDocValues values, LongValues map) {
            super(docMap);
            this.values = values;
            this.map = map;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }

        public String toString() {
            return "SortedSetDocValuesSub(mappedDocID=" + this.mappedDocID + " values=" + String.valueOf(this.values) + ")";
        }
    }

    private static class MergedTermsEnum
    extends BaseTermsEnum {
        private final TermsEnum[] subs;
        private final OrdinalMap ordinalMap;
        private final long valueCount;
        private long ord = -1L;
        private BytesRef term;

        MergedTermsEnum(OrdinalMap ordinalMap, TermsEnum[] subs) {
            this.ordinalMap = ordinalMap;
            this.subs = subs;
            this.valueCount = ordinalMap.getValueCount();
        }

        public BytesRef term() throws IOException {
            return this.term;
        }

        public long ord() throws IOException {
            return this.ord;
        }

        public BytesRef next() throws IOException {
            if (++this.ord >= this.valueCount) {
                return null;
            }
            int subNum = this.ordinalMap.getFirstSegmentNumber(this.ord);
            TermsEnum sub = this.subs[subNum];
            long subOrd = this.ordinalMap.getFirstSegmentOrd(this.ord);
            do {
                this.term = sub.next();
            } while (sub.ord() < subOrd);
            assert (sub.ord() == subOrd);
            return this.term;
        }

        public AttributeSource attributes() {
            throw new UnsupportedOperationException();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermState termState() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortedNumericDocValuesSub
    extends DocIDMerger.Sub {
        final SortedNumericDocValues values;

        SortedNumericDocValuesSub(MergeState.DocMap docMap, SortedNumericDocValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class BinaryDocValuesSub
    extends DocIDMerger.Sub {
        final BinaryDocValues values;

        BinaryDocValuesSub(MergeState.DocMap docMap, BinaryDocValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

