/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import org.elasticsearch.common.hash.MurmurHash3;

public class Murmur3Hasher {
    public static final String METHOD = "MurmurHash3";
    private final long seed;
    private final byte[] remainder = new byte[16];
    private int remainderLength = 0;
    private int length;
    private long h1;
    private long h2;

    public Murmur3Hasher(long seed) {
        this.seed = seed;
        this.h1 = this.h2 = seed;
    }

    public void update(byte[] inputBytes) {
        this.update(inputBytes, 0, inputBytes.length);
    }

    public void update(byte[] inputBytes, int offset, int length) {
        if (this.remainderLength + length >= this.remainder.length) {
            int numBytesToHash;
            MurmurHash3.IntermediateResult result;
            if (this.remainderLength > 0) {
                int bytesToCopyFromInputToRemainder = this.remainder.length - this.remainderLength;
                System.arraycopy(inputBytes, offset, this.remainder, this.remainderLength, bytesToCopyFromInputToRemainder);
                offset = bytesToCopyFromInputToRemainder;
                length -= bytesToCopyFromInputToRemainder;
                result = MurmurHash3.intermediateHash(this.remainder, 0, this.remainder.length, this.h1, this.h2);
                this.h1 = result.h1;
                this.h2 = result.h2;
                this.remainderLength = 0;
                this.length += this.remainder.length;
            }
            if ((numBytesToHash = length & 0xFFFFFFF0) > 0) {
                result = MurmurHash3.intermediateHash(inputBytes, offset, numBytesToHash, this.h1, this.h2);
                this.h1 = result.h1;
                this.h2 = result.h2;
                this.length += numBytesToHash;
            }
            if (length > numBytesToHash) {
                this.remainderLength = length - numBytesToHash;
                System.arraycopy(inputBytes, offset + numBytesToHash, this.remainder, 0, this.remainderLength);
            }
        } else {
            System.arraycopy(inputBytes, 0, this.remainder, this.remainderLength, length);
            this.remainderLength += length;
        }
    }

    public void reset() {
        this.length = 0;
        this.remainderLength = 0;
        this.h1 = this.h2 = this.seed;
    }

    public byte[] digest() {
        return this.digestHash().getBytes();
    }

    public MurmurHash3.Hash128 digestHash() {
        return this.digestHash(new MurmurHash3.Hash128());
    }

    public MurmurHash3.Hash128 digestHash(MurmurHash3.Hash128 hash) {
        this.length += this.remainderLength;
        MurmurHash3.finalizeHash(hash, this.remainder, 0, this.length, this.h1, this.h2);
        return hash;
    }

    public static String getAlgorithm() {
        return METHOD;
    }
}

