/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class DataStreamGlobalRetentionSettings {
    private static final Logger logger = LogManager.getLogger(DataStreamGlobalRetentionSettings.class);
    public static final TimeValue MIN_RETENTION_VALUE = TimeValue.timeValueSeconds((long)10L);
    public static final Setting<TimeValue> DATA_STREAMS_DEFAULT_RETENTION_SETTING = Setting.timeSetting("data_streams.lifecycle.retention.default", TimeValue.MINUS_ONE, new Setting.Validator<TimeValue>(){

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue settingValue, Map<Setting<?>, Object> settings) {
            TimeValue defaultRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(settingValue);
            TimeValue maxRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull((TimeValue)settings.get(DATA_STREAMS_MAX_RETENTION_SETTING));
            DataStreamGlobalRetentionSettings.validateIsolatedRetentionValue(defaultRetention, DATA_STREAMS_DEFAULT_RETENTION_SETTING.getKey());
            DataStreamGlobalRetentionSettings.validateGlobalRetentionConfiguration(defaultRetention, maxRetention);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<TimeValue>> settings = List.of(DATA_STREAMS_MAX_RETENTION_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> DATA_STREAMS_MAX_RETENTION_SETTING = Setting.timeSetting("data_streams.lifecycle.retention.max", TimeValue.MINUS_ONE, new Setting.Validator<TimeValue>(){

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue settingValue, Map<Setting<?>, Object> settings) {
            TimeValue defaultRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull((TimeValue)settings.get(DATA_STREAMS_DEFAULT_RETENTION_SETTING));
            TimeValue maxRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(settingValue);
            DataStreamGlobalRetentionSettings.validateIsolatedRetentionValue(maxRetention, DATA_STREAMS_MAX_RETENTION_SETTING.getKey());
            DataStreamGlobalRetentionSettings.validateGlobalRetentionConfiguration(defaultRetention, maxRetention);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<TimeValue>> settings = List.of(DATA_STREAMS_DEFAULT_RETENTION_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    static final TimeValue FAILURES_DEFAULT_RETENTION = TimeValue.timeValueDays((long)30L);
    public static final Setting<TimeValue> FAILURE_STORE_DEFAULT_RETENTION_SETTING = Setting.timeSetting("data_streams.lifecycle.retention.failures_default", FAILURES_DEFAULT_RETENTION, new Setting.Validator<TimeValue>(){

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue settingValue, Map<Setting<?>, Object> settings) {
            TimeValue defaultRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(settingValue);
            DataStreamGlobalRetentionSettings.validateIsolatedRetentionValue(defaultRetention, FAILURE_STORE_DEFAULT_RETENTION_SETTING.getKey());
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    @Nullable
    private volatile TimeValue defaultRetention;
    @Nullable
    private volatile TimeValue maxRetention;
    @Nullable
    private volatile TimeValue failuresDefaultRetention;
    @Nullable
    private volatile DataStreamGlobalRetention dataGlobalRetention;
    @Nullable
    private volatile DataStreamGlobalRetention failuresGlobalRetention;

    private DataStreamGlobalRetentionSettings() {
    }

    @Nullable
    public TimeValue getMaxRetention() {
        return this.maxRetention;
    }

    @Nullable
    public TimeValue getDefaultRetention() {
        return this.defaultRetention;
    }

    @Nullable
    public TimeValue getDefaultRetention(boolean failureStore) {
        return failureStore ? this.failuresDefaultRetention : this.defaultRetention;
    }

    public static DataStreamGlobalRetentionSettings create(ClusterSettings clusterSettings) {
        DataStreamGlobalRetentionSettings dataStreamGlobalRetentionSettings = new DataStreamGlobalRetentionSettings();
        clusterSettings.initializeAndWatch(DATA_STREAMS_DEFAULT_RETENTION_SETTING, dataStreamGlobalRetentionSettings::setDefaultRetention);
        clusterSettings.initializeAndWatch(DATA_STREAMS_MAX_RETENTION_SETTING, dataStreamGlobalRetentionSettings::setMaxRetention);
        clusterSettings.initializeAndWatch(FAILURE_STORE_DEFAULT_RETENTION_SETTING, dataStreamGlobalRetentionSettings::setFailuresDefaultRetention);
        return dataStreamGlobalRetentionSettings;
    }

    private void setMaxRetention(TimeValue maxRetention) {
        this.maxRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(maxRetention);
        this.dataGlobalRetention = this.createDataStreamGlobalRetention(false);
        this.failuresGlobalRetention = this.createDataStreamGlobalRetention(true);
        logger.info("Updated global max retention to [{}]", (Object)(this.maxRetention == null ? null : maxRetention.getStringRep()));
    }

    private void setDefaultRetention(TimeValue defaultRetention) {
        this.defaultRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(defaultRetention);
        this.dataGlobalRetention = this.createDataStreamGlobalRetention(false);
        logger.info("Updated global default retention to [{}]", (Object)(this.defaultRetention == null ? null : defaultRetention.getStringRep()));
    }

    private void setFailuresDefaultRetention(TimeValue failuresDefaultRetention) {
        this.failuresDefaultRetention = DataStreamGlobalRetentionSettings.getSettingValueOrNull(failuresDefaultRetention);
        this.failuresGlobalRetention = this.createDataStreamGlobalRetention(true);
        logger.info("Updated failures default retention to [{}]", (Object)(this.failuresDefaultRetention == null ? null : failuresDefaultRetention.getStringRep()));
    }

    private static void validateIsolatedRetentionValue(@Nullable TimeValue retention, String settingName) {
        if (retention != null && retention.getMillis() < MIN_RETENTION_VALUE.getMillis()) {
            throw new IllegalArgumentException("Setting '" + settingName + "' should be greater than " + MIN_RETENTION_VALUE.getStringRep());
        }
    }

    private static void validateGlobalRetentionConfiguration(@Nullable TimeValue defaultRetention, @Nullable TimeValue maxRetention) {
        if (defaultRetention != null && maxRetention != null && defaultRetention.getMillis() > maxRetention.getMillis()) {
            throw new IllegalArgumentException("Setting [" + DATA_STREAMS_DEFAULT_RETENTION_SETTING.getKey() + "=" + defaultRetention.getStringRep() + "] cannot be greater than [" + DATA_STREAMS_MAX_RETENTION_SETTING.getKey() + "=" + maxRetention.getStringRep() + "].");
        }
    }

    @Nullable
    public DataStreamGlobalRetention get() {
        return this.get(false);
    }

    @Nullable
    public DataStreamGlobalRetention get(boolean failureStore) {
        return failureStore ? this.failuresGlobalRetention : this.dataGlobalRetention;
    }

    @Nullable
    private DataStreamGlobalRetention createDataStreamGlobalRetention(boolean failureStore) {
        if (!this.areDefined(failureStore)) {
            return null;
        }
        TimeValue defaultRetention = this.getDefaultRetention(failureStore);
        TimeValue maxRetention = this.getMaxRetention();
        if (defaultRetention != null && maxRetention != null && defaultRetention.getMillis() > maxRetention.getMillis()) {
            return new DataStreamGlobalRetention(null, this.getMaxRetention());
        }
        return new DataStreamGlobalRetention(defaultRetention, maxRetention);
    }

    @Nullable
    private static TimeValue getSettingValueOrNull(TimeValue value) {
        return value == null || value.equals((Object)TimeValue.MINUS_ONE) ? null : value;
    }

    private boolean areDefined(boolean failureStore) {
        return this.getDefaultRetention(failureStore) != null || this.getMaxRetention() != null;
    }
}

