/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.core.ccr.action.ForgetFollowerAction;

public class TransportForgetFollowerAction
extends TransportBroadcastByNodeAction<ForgetFollowerAction.Request, BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;

    @Inject
    public TransportForgetFollowerAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("indices:admin/xpack/ccr/forget_follower", Objects.requireNonNull(clusterService), Objects.requireNonNull(transportService), Objects.requireNonNull(actionFilters), Objects.requireNonNull(indexNameExpressionResolver), ForgetFollowerAction.Request::new, (Executor)transportService.getThreadPool().executor("management"));
        this.indicesService = Objects.requireNonNull(indicesService);
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) {
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected TransportBroadcastByNodeAction.ResponseFactory<BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> getResponseFactory(ForgetFollowerAction.Request request, ClusterState clusterState) {
        return (totalShards, successfulShards, failedShards, emptyResults, shardFailures) -> new BroadcastResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected ForgetFollowerAction.Request readRequestFrom(StreamInput in) throws IOException {
        return new ForgetFollowerAction.Request(in);
    }

    protected void shardOperation(ForgetFollowerAction.Request request, ShardRouting shardRouting, Task task, ActionListener<TransportBroadcastByNodeAction.EmptyResult> listener) {
        Index followerIndex = new Index(request.followerIndex(), request.followerIndexUUID());
        Index leaderIndex = this.clusterService.state().metadata().index(request.leaderIndex()).getIndex();
        final String id = CcrRetentionLeases.retentionLeaseId(request.followerCluster(), followerIndex, request.leaderRemoteCluster(), leaderIndex);
        final IndexShard indexShard = this.indicesService.indexServiceSafe(leaderIndex).getShard(shardRouting.shardId().id());
        indexShard.acquirePrimaryOperationPermit((ActionListener)new DelegatingActionListener<Releasable, TransportBroadcastByNodeAction.EmptyResult>(listener){

            public void onResponse(final Releasable releasable) {
                try {
                    indexShard.removeRetentionLease(id, (ActionListener)new ActionListener<ReplicationResponse>(){

                        public void onResponse(ReplicationResponse replicationResponse) {
                            releasable.close();
                            delegate.onResponse((Object)TransportBroadcastByNodeAction.EmptyResult.INSTANCE);
                        }

                        public void onFailure(Exception e) {
                            releasable.close();
                            delegate.onFailure(e);
                        }
                    });
                }
                catch (Exception e) {
                    releasable.close();
                    this.onFailure(e);
                }
            }
        }, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected ShardsIterator shards(ClusterState clusterState, ForgetFollowerAction.Request request, String[] concreteIndices) {
        List activePrimaryShards = clusterState.routingTable().activePrimaryShardsGrouped(concreteIndices, false);
        ArrayList<ShardRouting> shardRoutings = new ArrayList<ShardRouting>();
        for (ShardIterator shardIterator : activePrimaryShards) {
            ShardRouting primaryShard = (ShardRouting)shardIterator.nextOrNull();
            assert (primaryShard != null);
            shardRoutings.add(primaryShard);
            if (!Assertions.ENABLED) continue;
            ShardRouting maybeNextPrimaryShard = (ShardRouting)shardIterator.nextOrNull();
            assert (maybeNextPrimaryShard == null) : maybeNextPrimaryShard;
        }
        return new PlainShardsIterator(shardRoutings);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, ForgetFollowerAction.Request request) {
        return null;
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, ForgetFollowerAction.Request request, String[] concreteIndices) {
        return null;
    }
}

