/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.modelsnapshots;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

@ServerlessScope(value=Scope.INTERNAL)
public class RestRevertModelSnapshotAction
extends BaseRestHandler {
    private static final boolean DELETE_INTERVENING_DEFAULT = false;

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/model_snapshots/{" + String.valueOf(RevertModelSnapshotAction.Request.SNAPSHOT_ID) + "}/_revert")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/model_snapshots/{" + String.valueOf(RevertModelSnapshotAction.Request.SNAPSHOT_ID) + "}/_revert", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_revert_model_snapshot_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RevertModelSnapshotAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String snapshotId = restRequest.param(RevertModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = RevertModelSnapshotAction.Request.parseRequest((String)jobId, (String)snapshotId, (XContentParser)parser);
        } else {
            request = new RevertModelSnapshotAction.Request(jobId, snapshotId);
            request.setDeleteInterveningResults(restRequest.paramAsBoolean(RevertModelSnapshotAction.Request.DELETE_INTERVENING.getPreferredName(), false));
        }
        request.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        request.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)RevertModelSnapshotAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

