/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.MultiCharSequence;

public class DelimitedToken {
    private final CharSequence charSequence;
    private final int startOffset;
    private final int endOffset;

    static DelimitedToken mergeTokens(List<DelimitedToken> tokens) {
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        int startOffSet = tokens.get((int)0).startOffset;
        int endOffset = tokens.get((int)(tokens.size() - 1)).endOffset;
        return new DelimitedToken(tokens.stream().map(DelimitedToken::charSequence).map(CharSequence::toString).collect(Collectors.joining()), startOffSet, endOffset);
    }

    public DelimitedToken(CharSequence charSequence, int startOffset, int endOffset) {
        this.charSequence = charSequence;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public CharSequence charSequence() {
        return this.charSequence;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimitedToken that = (DelimitedToken)o;
        return this.startOffset == that.startOffset && this.endOffset == that.endOffset && Objects.equals(this.charSequence, that.charSequence);
    }

    public int hashCode() {
        return Objects.hash(this.charSequence, this.startOffset, this.endOffset);
    }

    public String toString() {
        return this.charSequence.toString();
    }

    public static class Encoded
    extends DelimitedToken {
        private final int encoding;

        static Encoded mergeEncodedTokens(List<Encoded> tokens) {
            if (tokens.size() == 1) {
                return tokens.get(0);
            }
            int startOffSet = tokens.get(0).startOffset();
            int endOffset = tokens.get(tokens.size() - 1).endOffset();
            int encoding = tokens.get((int)0).encoding;
            ArrayList<CharSequence> sequences = new ArrayList<CharSequence>(tokens.size());
            for (Encoded t : tokens) {
                if (t.encoding != encoding) {
                    throw new IllegalArgumentException(Strings.format((String)"all merged tokens must have the same encoding, expected [%s]; found [%s]", (Object[])new Object[]{encoding, t.encoding}));
                }
                sequences.add(t.charSequence());
            }
            return new Encoded(new MultiCharSequence(sequences), tokens.get((int)0).encoding, startOffSet, endOffset);
        }

        public Encoded(CharSequence charSequence, int encoding, int startOffset, int endOffset) {
            super(charSequence, startOffset, endOffset);
            this.encoding = encoding;
        }

        public int getEncoding() {
            return this.encoding;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Encoded encoded = (Encoded)o;
            return this.encoding == encoded.encoding;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.encoding);
        }
    }
}

