/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;

final class ElasticServiceAccounts {
    static final String NAMESPACE = "elastic";
    private static final ServiceAccount AUTO_OPS_ACCOUNT = new ElasticServiceAccount("auto-ops", new RoleDescriptor("elastic/auto-ops", new String[]{"monitor", "read_ilm", "read_slm"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().allowRestrictedIndices(true).indices(new String[]{"*"}).privileges(new String[]{"monitor", "view_index_metadata"}).build()}, null, null, null, null, null));
    private static final ServiceAccount ENTERPRISE_SEARCH_ACCOUNT = new ElasticServiceAccount("enterprise-search-server", new RoleDescriptor("elastic/enterprise-search-server", new String[]{"manage", "manage_security", "read_connector_secrets", "write_connector_secrets"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"search-*", ".search-acl-filter-*", ".elastic-analytics-collections", ".ent-search-*", ".monitoring-ent-search-*", "metricbeat-ent-search-*", "enterprise-search-*", "logs-app_search.analytics-default", "logs-elastic_analytics.events-*", "logs-enterprise_search.api-default", "logs-enterprise_search.audit-default", "logs-app_search.search_relevance_suggestions-default", "logs-crawler-default", "logs-elastic_crawler-default", "logs-workplace_search.analytics-default", "logs-workplace_search.content_events-default", ".elastic-connectors*"}).privileges(new String[]{"manage", "read", "write"}).build()}, null, null, null, null, null));
    private static final ServiceAccount FLEET_ACCOUNT = new ElasticServiceAccount("fleet-server", new RoleDescriptor("elastic/fleet-server", new String[]{"monitor", "manage_own_api_key", "read_fleet_secrets"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"logs-*", "metrics-*", "traces-*", ".logs-endpoint.diagnostic.collection-*", ".logs-endpoint.action.responses-*", ".logs-endpoint.heartbeat-*"}).privileges(new String[]{"write", "create_index", "auto_configure"}).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"profiling-*"}).privileges(new String[]{"read", "write"}).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"traces-apm.sampled-*"}).privileges(new String[]{"read", "monitor", "maintenance"}).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-secrets*"}).privileges(new String[]{"read"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-actions*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-agents*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-artifacts*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-enrollment-api-keys*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-policies*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-policies-leader*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-servers*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-fileds*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance"}).allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"synthetics-*"}).privileges(new String[]{"read", "write", "create_index", "auto_configure"}).allowRestrictedIndices(false).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"agentless-*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure", "maintenance", "view_index_metadata"}).allowRestrictedIndices(false).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources(new String[]{"*"}).privileges(new String[]{"reserved_fleet-setup"}).build()}, null, null, null, null));
    private static final ServiceAccount FLEET_REMOTE_ACCOUNT = new ElasticServiceAccount("fleet-server-remote", new RoleDescriptor("elastic/fleet-server-remote", new String[]{"monitor", "manage_own_api_key"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"logs-*", "metrics-*", "traces-*"}).privileges(new String[]{"write", "create_index", "auto_configure"}).build()}, null, null, null, null, null));
    private static final ServiceAccount KIBANA_SYSTEM_ACCOUNT = new ElasticServiceAccount("kibana", ReservedRolesStore.kibanaSystemRoleDescriptor((String)"elastic/kibana"));
    static final Map<String, ServiceAccount> ACCOUNTS = Stream.of(AUTO_OPS_ACCOUNT, ENTERPRISE_SEARCH_ACCOUNT, FLEET_ACCOUNT, FLEET_REMOTE_ACCOUNT, KIBANA_SYSTEM_ACCOUNT).collect(Collectors.toMap(a -> a.id().asPrincipal(), Function.identity()));

    private ElasticServiceAccounts() {
    }

    static class ElasticServiceAccount
    implements ServiceAccount {
        private final ServiceAccount.ServiceAccountId id;
        private final RoleDescriptor roleDescriptor;
        private final User user;

        ElasticServiceAccount(String serviceName, RoleDescriptor roleDescriptor) {
            this.id = new ServiceAccount.ServiceAccountId(ElasticServiceAccounts.NAMESPACE, serviceName);
            this.roleDescriptor = Objects.requireNonNull(roleDescriptor, "Role descriptor cannot be null");
            if (!roleDescriptor.getName().equals(this.id.asPrincipal())) {
                throw new IllegalArgumentException("the provided role descriptor [" + roleDescriptor.getName() + "] must have the same name as the service account [" + this.id.asPrincipal() + "]");
            }
            this.user = new User(this.id.asPrincipal(), Strings.EMPTY_ARRAY, "Service account - " + String.valueOf(this.id), null, Map.of("_elastic_service_account", true), true);
        }

        @Override
        public ServiceAccount.ServiceAccountId id() {
            return this.id;
        }

        @Override
        public RoleDescriptor roleDescriptor() {
            return this.roleDescriptor;
        }

        @Override
        public User asUser() {
            return this.user;
        }
    }
}

