/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.TransportIndicesAliasesAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.DestAlias;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformEffectiveSettings;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;

public final class TransformIndex {
    private static final Logger logger = LogManager.getLogger(TransformIndex.class);
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";

    private TransformIndex() {
    }

    public static void isDestinationIndexCreatedByTransform(Client client, String destIndex, ActionListener<Boolean> listener) {
        GetIndexRequest getIndexRequest = ((GetIndexRequest)new GetIndexRequest().indices(new String[]{destIndex})).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.MAPPINGS});
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"transform", (ActionType)GetIndexAction.INSTANCE, (ActionRequest)getIndexRequest, (ActionListener)ActionListener.wrap(getIndexResponse -> {
            Map indicesMappings = getIndexResponse.mappings();
            if (!indicesMappings.containsKey(destIndex)) {
                listener.onResponse((Object)false);
                return;
            }
            Map indexMapping = ((MappingMetadata)indicesMappings.get(destIndex)).getSourceAsMap();
            if (!indexMapping.containsKey(META)) {
                listener.onResponse((Object)false);
                return;
            }
            Map indexMappingMetadata = (Map)indexMapping.get(META);
            if (!indexMappingMetadata.containsKey("created_by")) {
                listener.onResponse((Object)false);
                return;
            }
            String createdBy = (String)indexMappingMetadata.get("created_by");
            if (!"transform".equals(createdBy)) {
                listener.onResponse((Object)false);
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)false);
                return;
            }
            listener.onFailure(e);
        }));
    }

    public static void createDestinationIndex(Client client, TransformAuditor auditor, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, TransformConfig config, Settings destIndexSettings, Map<String, String> destIndexMappings, ActionListener<Boolean> listener) {
        String destinationIndex = config.getDestination().getIndex();
        String[] dest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destinationIndex});
        ActionListener setUpDestinationAliasesListener = ActionListener.wrap(r -> {
            String message = "Set up aliases [" + config.getDestination().getAliases().stream().map(DestAlias::getAlias).collect(Collectors.joining(", ")) + "] for destination index [" + destinationIndex + "].";
            auditor.info(config.getId(), message);
            listener.onResponse(r);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createDestinationIndexListener = ActionListener.wrap(createdDestinationIndex -> {
            if (createdDestinationIndex.booleanValue()) {
                String message = TransformEffectiveSettings.isDeduceMappingsDisabled((SettingsConfig)config.getSettings()) ? "Created destination index [" + destinationIndex + "]." : "Created destination index [" + destinationIndex + "] with deduced mappings.";
                auditor.info(config.getId(), message);
            }
            TransformIndex.setUpDestinationAliases(client, config, (ActionListener<Boolean>)setUpDestinationAliasesListener);
        }, arg_0 -> listener.onFailure(arg_0));
        if (dest.length == 0) {
            TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings(destIndexSettings, TransformEffectiveSettings.isDeduceMappingsDisabled((SettingsConfig)config.getSettings()) ? Collections.emptyMap() : destIndexMappings, config.getId(), Clock.systemUTC());
            TransformIndex.createDestinationIndex(client, config, generatedDestIndexSettings, (ActionListener<Boolean>)createDestinationIndexListener);
        } else {
            auditor.info(config.getId(), "Using existing destination index [" + destinationIndex + "].");
            ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (Object)((IndicesStatsRequest)client.admin().indices().prepareStats(dest).clear().setDocs(true).request()), (ActionListener)ActionListener.wrap(r -> {
                DocsStats docsStats = r.getTotal().docs;
                if (docsStats != null && docsStats.getCount() > 0L) {
                    auditor.warning(config.getId(), "Non-empty destination index [" + destinationIndex + "]. Contains [" + docsStats.getCount() + "] total documents.");
                }
                createDestinationIndexListener.onResponse((Object)false);
            }, e -> {
                String message = "Unable to determine destination index stats, error: " + e.getMessage();
                logger.warn(message, (Throwable)e);
                auditor.warning(config.getId(), message);
                createDestinationIndexListener.onResponse((Object)false);
            }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).stats(arg_0, arg_1));
        }
    }

    static void createDestinationIndex(Client client, TransformConfig config, TransformDestIndexSettings destIndexSettings, ActionListener<Boolean> listener) {
        CreateIndexRequest request = new CreateIndexRequest(config.getDestination().getIndex());
        request.settings(destIndexSettings.getSettings());
        request.mapping(destIndexSettings.getMappings());
        for (Alias alias : destIndexSettings.getAliases()) {
            request.alias(alias);
        }
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"transform", (Client)client, (ActionType)TransportCreateIndexAction.TYPE, (ActionRequest)request, (ActionListener)ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                listener.onResponse((Object)false);
                return;
            }
            String message = TransformMessages.getMessage((String)"Could not create destination index [{0}] for transform [{1}]", (Object[])new Object[]{config.getDestination().getIndex(), config.getId()});
            logger.error(message, (Throwable)e);
            listener.onFailure((Exception)new RuntimeException(message, (Throwable)e));
        }));
    }

    static void setUpDestinationAliases(Client client, TransformConfig config, ActionListener<Boolean> listener) {
        if (config.getDestination().getAliases() == null || config.getDestination().getAliases().isEmpty()) {
            listener.onResponse((Object)true);
            return;
        }
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        for (DestAlias destAlias : config.getDestination().getAliases()) {
            if (!destAlias.isMoveOnCreation()) continue;
            request.addAliasAction(IndicesAliasesRequest.AliasActions.remove().alias(destAlias.getAlias()).index("*"));
        }
        for (DestAlias destAlias : config.getDestination().getAliases()) {
            request.addAliasAction(IndicesAliasesRequest.AliasActions.add().alias(destAlias.getAlias()).index(config.getDestination().getIndex()));
        }
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"transform", (Client)client, (ActionType)TransportIndicesAliasesAction.TYPE, (ActionRequest)request, (ActionListener)ActionListener.wrap(aliasesResponse -> listener.onResponse((Object)true), e -> {
            String message = TransformMessages.getMessage((String)"Could not set up aliases for destination index [{0}] for transform [{1}]", (Object[])new Object[]{config.getDestination().getIndex(), config.getId()});
            logger.error(message, (Throwable)e);
            listener.onFailure((Exception)new RuntimeException(message, (Throwable)e));
        }));
    }

    public static TransformDestIndexSettings createTransformDestIndexSettings(Settings settings, Map<String, String> mappings, String id, Clock clock) {
        HashMap<String, Map<String, Object>> indexMappings = new HashMap<String, Map<String, Object>>();
        indexMappings.put(PROPERTIES, TransformIndex.createMappingsFromStringMap(mappings));
        indexMappings.put(META, TransformIndex.createMetadata(id, clock));
        Set aliases = null;
        return new TransformDestIndexSettings(indexMappings, settings, aliases);
    }

    private static Map<String, Object> createMetadata(String id, Clock clock) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("created_by", "transform");
        HashMap<String, Object> transformMetadata = new HashMap<String, Object>();
        transformMetadata.put("creation_date_in_millis", clock.millis());
        transformMetadata.put(TransformField.VERSION.getPreferredName(), Map.of("created", TransformConfigVersion.CURRENT.toString()));
        transformMetadata.put("transform", id);
        metadata.put("_transform", transformMetadata);
        return metadata;
    }

    static Map<String, Object> createMappingsFromStringMap(Map<String, String> mappings) {
        return mappings.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singletonMap("type", (String)e.getValue())));
    }
}

