/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.TDigest;

public abstract class AbstractTDigest
extends TDigest {
    static double weightedAverage(double x1, double w1, double x2, double w2) {
        if (x1 <= x2) {
            return AbstractTDigest.weightedAverageSorted(x1, w1, x2, w2);
        }
        return AbstractTDigest.weightedAverageSorted(x2, w2, x1, w1);
    }

    private static double weightedAverageSorted(double x1, double w1, double x2, double w2) {
        assert (x1 <= x2);
        double x = (x1 * w1 + x2 * w2) / (w1 + w2);
        return Math.max(x1, Math.min(x, x2));
    }

    static double interpolate(double x, double x0, double x1) {
        return (x - x0) / (x1 - x0);
    }

    @Override
    public void add(TDigest other) {
        for (Centroid centroid : other.centroids()) {
            this.add(centroid.mean(), centroid.count());
        }
    }
}

