/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.IntAVLTree;
import org.elasticsearch.tdigest.arrays.TDigestArrays;
import org.elasticsearch.tdigest.arrays.TDigestDoubleArray;
import org.elasticsearch.tdigest.arrays.TDigestLongArray;

final class AVLGroupTree
extends AbstractCollection<Centroid>
implements Releasable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(AVLGroupTree.class);
    private final TDigestArrays arrays;
    private boolean closed = false;
    private double centroid;
    private long count;
    private final TDigestDoubleArray centroids;
    private final TDigestLongArray counts;
    private final TDigestLongArray aggregatedCounts;
    private final IntAVLTree tree;

    static AVLGroupTree create(TDigestArrays arrays) {
        arrays.adjustBreaker(SHALLOW_SIZE);
        try {
            return new AVLGroupTree(arrays);
        }
        catch (Exception e) {
            arrays.adjustBreaker(-SHALLOW_SIZE);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVLGroupTree(TDigestArrays arrays) {
        this.arrays = arrays;
        IntAVLTree tree = null;
        TDigestDoubleArray centroids = null;
        TDigestLongArray counts = null;
        TDigestLongArray aggregatedCounts = null;
        try {
            this.tree = tree = this.createIntAvlTree(arrays);
            this.centroids = centroids = arrays.newDoubleArray(tree.capacity());
            this.counts = counts = arrays.newLongArray(tree.capacity());
            this.aggregatedCounts = aggregatedCounts = arrays.newLongArray(tree.capacity());
            tree = null;
            centroids = null;
            counts = null;
            aggregatedCounts = null;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{tree, centroids, counts, aggregatedCounts});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{tree, centroids, counts, aggregatedCounts});
    }

    private IntAVLTree createIntAvlTree(TDigestArrays arrays) {
        arrays.adjustBreaker(IntAVLTree.SHALLOW_SIZE);
        try {
            return new InternalIntAvlTree(arrays);
        }
        catch (Exception e) {
            arrays.adjustBreaker(-IntAVLTree.SHALLOW_SIZE);
            throw e;
        }
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.centroids.ramBytesUsed() + this.counts.ramBytesUsed() + this.aggregatedCounts.ramBytesUsed() + this.tree.ramBytesUsed();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    public int prev(int node) {
        return this.tree.prev(node);
    }

    public int next(int node) {
        return this.tree.next(node);
    }

    public double mean(int node) {
        return this.centroids.get(node);
    }

    public long count(int node) {
        return this.counts.get(node);
    }

    public void add(double centroid, long count) {
        this.centroid = centroid;
        this.count = count;
        this.tree.add();
    }

    @Override
    public boolean add(Centroid centroid) {
        this.add(centroid.mean(), centroid.count());
        return true;
    }

    public void update(int node, double centroid, long count) {
        this.centroid = centroid;
        this.count = count;
        this.tree.update(node);
    }

    public int floor(double centroid) {
        int floor = 0;
        int node = this.tree.root();
        while (node != 0) {
            int cmp = Double.compare(centroid, this.mean(node));
            if (cmp <= 0) {
                node = this.tree.left(node);
                continue;
            }
            floor = node;
            node = this.tree.right(node);
        }
        return floor;
    }

    public int floorSum(long sum) {
        int floor = 0;
        int node = this.tree.root();
        while (node != 0) {
            int left = this.tree.left(node);
            long leftCount = this.aggregatedCounts.get(left);
            if (leftCount <= sum) {
                floor = node;
                sum -= leftCount + this.count(node);
                node = this.tree.right(node);
                continue;
            }
            node = this.tree.left(node);
        }
        return floor;
    }

    public int first() {
        return this.tree.first(this.tree.root());
    }

    public int last() {
        return this.tree.last(this.tree.root());
    }

    public long headSum(int node) {
        int left = this.tree.left(node);
        long sum = this.aggregatedCounts.get(left);
        int n = node;
        int p = this.tree.parent(node);
        while (p != 0) {
            if (n == this.tree.right(p)) {
                int leftP = this.tree.left(p);
                sum += this.counts.get(p) + this.aggregatedCounts.get(leftP);
            }
            n = p;
            p = this.tree.parent(n);
        }
        return sum;
    }

    @Override
    public Iterator<Centroid> iterator() {
        return this.iterator(this.first());
    }

    private Iterator<Centroid> iterator(final int startNode) {
        return new Iterator<Centroid>(){
            int nextNode;
            {
                this.nextNode = startNode;
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != 0;
            }

            @Override
            public Centroid next() {
                Centroid next = new Centroid(AVLGroupTree.this.mean(this.nextNode), AVLGroupTree.this.count(this.nextNode));
                this.nextNode = AVLGroupTree.this.tree.next(this.nextNode);
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator");
            }
        };
    }

    public long sum() {
        return this.aggregatedCounts.get(this.tree.root());
    }

    void checkBalance() {
        this.tree.checkBalance(this.tree.root());
    }

    void checkAggregates() {
        this.checkAggregates(this.tree.root());
    }

    private void checkAggregates(int node) {
        assert (this.aggregatedCounts.get(node) == this.counts.get(node) + this.aggregatedCounts.get(this.tree.left(node)) + this.aggregatedCounts.get(this.tree.right(node)));
        if (node != 0) {
            this.checkAggregates(this.tree.left(node));
            this.checkAggregates(this.tree.right(node));
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.arrays.adjustBreaker(-SHALLOW_SIZE);
            Releasables.close((Releasable[])new Releasable[]{this.centroids, this.counts, this.aggregatedCounts, this.tree});
        }
    }

    private class InternalIntAvlTree
    extends IntAVLTree {
        private InternalIntAvlTree(TDigestArrays arrays) {
            super(arrays);
        }

        @Override
        protected void resize(int newCapacity) {
            super.resize(newCapacity);
            AVLGroupTree.this.centroids.resize(newCapacity);
            AVLGroupTree.this.counts.resize(newCapacity);
            AVLGroupTree.this.aggregatedCounts.resize(newCapacity);
        }

        @Override
        protected void merge(int node) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void copy(int node) {
            AVLGroupTree.this.centroids.set(node, AVLGroupTree.this.centroid);
            AVLGroupTree.this.counts.set(node, AVLGroupTree.this.count);
        }

        @Override
        protected int compare(int node) {
            if (AVLGroupTree.this.centroid < AVLGroupTree.this.centroids.get(node)) {
                return -1;
            }
            return 1;
        }

        @Override
        protected void fixAggregates(int node) {
            super.fixAggregates(node);
            AVLGroupTree.this.aggregatedCounts.set(node, AVLGroupTree.this.counts.get(node) + AVLGroupTree.this.aggregatedCounts.get(this.left(node)) + AVLGroupTree.this.aggregatedCounts.get(this.right(node)));
        }
    }
}

