/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;

public final class AttributeMap<E>
implements Map<Attribute, E> {
    private static final AttributeMap EMPTY = new AttributeMap(Collections.emptyMap());
    private final Map<AttributeWrapper, E> delegate;

    public static <E> AttributeMap<E> emptyAttributeMap() {
        return EMPTY;
    }

    private AttributeMap(Map<AttributeWrapper, E> other) {
        this.delegate = other;
    }

    private AttributeMap() {
        this.delegate = new LinkedHashMap<AttributeWrapper, E>();
    }

    public AttributeMap(Attribute key, E value) {
        this.delegate = new LinkedHashMap<AttributeWrapper, E>();
        this.add(key, value);
    }

    public AttributeMap<E> combine(AttributeMap<E> other) {
        AttributeMap<E> combine = new AttributeMap<E>();
        combine.addAll(this);
        combine.addAll(other);
        return combine;
    }

    public AttributeMap<E> subtract(AttributeMap<E> other) {
        AttributeMap<E> diff = new AttributeMap<E>();
        for (Map.Entry<AttributeWrapper, E> entry : this.delegate.entrySet()) {
            if (other.delegate.containsKey(entry.getKey())) continue;
            diff.delegate.put(entry.getKey(), entry.getValue());
        }
        return diff;
    }

    public AttributeMap<E> intersect(AttributeMap<E> other) {
        AttributeMap<E> smaller = other.size() > this.size() ? this : other;
        AttributeMap<E> larger = smaller == this ? other : this;
        AttributeMap<E> intersect = new AttributeMap<E>();
        for (Map.Entry<AttributeWrapper, E> entry : smaller.delegate.entrySet()) {
            if (!larger.delegate.containsKey(entry.getKey())) continue;
            intersect.delegate.put(entry.getKey(), entry.getValue());
        }
        return intersect;
    }

    public boolean subsetOf(AttributeMap<E> other) {
        if (this.size() > other.size()) {
            return false;
        }
        for (AttributeWrapper aw : this.delegate.keySet()) {
            if (other.delegate.containsKey(aw)) continue;
            return false;
        }
        return true;
    }

    private E add(Attribute key, E value) {
        return this.delegate.put(new AttributeWrapper(key), value);
    }

    private void addAll(AttributeMap<E> other) {
        for (Map.Entry<Attribute, E> entry : other.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private E addIfAbsent(Attribute key, Function<? super Attribute, ? extends E> mappingFunction) {
        return (E)this.delegate.computeIfAbsent(new AttributeWrapper(key), k -> mappingFunction.apply(k.attr));
    }

    private E delete(Object key) {
        E e;
        if (key instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)key;
            e = this.delegate.remove(new AttributeWrapper(ne.toAttribute()));
        } else {
            e = null;
        }
        return e;
    }

    public Set<String> attributeNames() {
        LinkedHashSet s = Sets.newLinkedHashSetWithExpectedSize((int)this.size());
        for (AttributeWrapper aw : this.delegate.keySet()) {
            s.add(aw.attr.name());
        }
        return s;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        NamedExpression ne;
        return key instanceof NamedExpression && this.delegate.containsKey(new AttributeWrapper((ne = (NamedExpression)key).toAttribute()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public E get(Object key) {
        E e;
        if (key instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)key;
            e = this.delegate.get(new AttributeWrapper(ne.toAttribute()));
        } else {
            e = null;
        }
        return e;
    }

    @Override
    public E getOrDefault(Object key, E defaultValue) {
        E e;
        if (key instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)key;
            e = this.delegate.getOrDefault(new AttributeWrapper(ne.toAttribute()), defaultValue);
        } else {
            e = defaultValue;
        }
        return e;
    }

    public E resolve(Object key) {
        return this.resolve(key, null);
    }

    public E resolve(Object key, E defaultValue) {
        E value = defaultValue;
        E candidate = null;
        int allowedLookups = 1000;
        while (true) {
            E e = this.get(key);
            candidate = e;
            if (e == null && !this.containsKey(key)) break;
            if (candidate == key) {
                return candidate;
            }
            if (--allowedLookups == 0) {
                throw new QlIllegalArgumentException("Potential cycle detected");
            }
            key = candidate;
            value = candidate;
        }
        return value;
    }

    @Override
    public E put(Attribute key, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Attribute, ? extends E> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Attribute> keySet() {
        return new UnwrappingSet<AttributeWrapper, Attribute>(this.delegate.keySet()){

            @Override
            protected Attribute unwrap(AttributeWrapper next) {
                return next.attr;
            }
        };
    }

    @Override
    public Collection<E> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<Attribute, E>> entrySet() {
        return new UnwrappingSet<Map.Entry<AttributeWrapper, E>, Map.Entry<Attribute, E>>(this.delegate.entrySet()){

            @Override
            protected Map.Entry<Attribute, E> unwrap(final Map.Entry<AttributeWrapper, E> next) {
                return new Map.Entry<Attribute, E>(){

                    @Override
                    public Attribute getKey() {
                        return ((AttributeWrapper)next.getKey()).attr;
                    }

                    @Override
                    public E getValue() {
                        return next.getValue();
                    }

                    @Override
                    public E setValue(E value) {
                        return next.setValue(value);
                    }
                };
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super Attribute, ? super E> action) {
        this.delegate.forEach((? super K k, ? super V v) -> action.accept(k.attr, (Object)v));
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AttributeMap) {
            AttributeMap am = (AttributeMap)obj;
            obj = am.delegate;
        }
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static <E> AttributeMap<E> of(Attribute key, E value) {
        AttributeMap<E> map = new AttributeMap<E>();
        map.add(key, value);
        return map;
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    private static class AttributeWrapper {
        private final Attribute attr;

        AttributeWrapper(Attribute attr) {
            this.attr = attr;
        }

        public int hashCode() {
            return this.attr.semanticHash();
        }

        public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof AttributeWrapper) {
                AttributeWrapper aw = (AttributeWrapper)obj;
                bl = this.attr.semanticEquals(aw.attr);
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return this.attr.toString();
        }
    }

    public static class Builder<E> {
        private final AttributeMap<E> map = new AttributeMap();

        private Builder() {
        }

        public E put(Attribute attr, E value) {
            return this.map.add(attr, value);
        }

        public Builder<E> putAll(AttributeMap<E> m) {
            this.map.addAll(m);
            return this;
        }

        public E computeIfAbsent(Attribute key, Function<? super Attribute, ? extends E> mappingFunction) {
            return this.map.addIfAbsent(key, mappingFunction);
        }

        public E remove(Object o) {
            return this.map.delete(o);
        }

        public Set<Attribute> keySet() {
            return this.map.keySet();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public AttributeMap<E> build() {
            return this.map;
        }
    }

    private static abstract class UnwrappingSet<W, U>
    extends AbstractSet<U> {
        private final Set<W> set;

        UnwrappingSet(Set<W> originalSet) {
            this.set = originalSet;
        }

        @Override
        public Iterator<U> iterator() {
            return new Iterator<U>(){
                final Iterator<W> i;
                {
                    this.i = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public U next() {
                    return this.unwrap(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        protected abstract U unwrap(W var1);

        @Override
        public Stream<U> stream() {
            return this.set.stream().map(this::unwrap);
        }

        @Override
        public Stream<U> parallelStream() {
            return this.set.parallelStream().map(this::unwrap);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public Object[] toArray() {
            Object[] array = this.set.toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((AttributeWrapper)array[i]).attr;
            }
            return array;
        }

        @Override
        public <A> A[] toArray(A[] a) {
            if (a.length < this.size()) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            }
            int i = 0;
            A[] result = a;
            for (U u : this) {
                result[i++] = u;
            }
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return this.set.toString();
        }
    }
}

