/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationTemplate;

public class GetSearchApplicationAction {
    public static final String NAME = "cluster:admin/xpack/application/search_application/get";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/search_application/get");

    private GetSearchApplicationAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final SearchApplication searchApp;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.searchApp = new SearchApplication(in);
        }

        public Response(SearchApplication app) {
            Objects.requireNonNull(app, "Search Application cannot be null");
            this.searchApp = app;
        }

        public Response(String name, String[] indices, String analyticsCollectionName, long updatedAtMillis, SearchApplicationTemplate template) {
            this.searchApp = new SearchApplication(name, indices, analyticsCollectionName, updatedAtMillis, template);
        }

        public static Response fromXContent(String resourceName, XContentParser parser) throws IOException {
            return new Response(SearchApplication.fromXContent(resourceName, parser));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.searchApp.writeTo(out);
        }

        public SearchApplication searchApp() {
            return this.searchApp;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.searchApp.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.searchApp, response.searchApp);
        }

        public int hashCode() {
            return Objects.hash(this.searchApp);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final String name;
        public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("get_search_application_request", p -> new Request((String)p[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public Request(String name) {
            this.name = name;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || this.name.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"name missing", validationException);
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.name, request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        }
    }
}

