/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.indices.InvalidIndexNameException;

public abstract class ConnectorActionRequest
extends LegacyActionRequest
implements IndicesRequest {
    public ConnectorActionRequest() {
    }

    public ConnectorActionRequest(StreamInput in) throws IOException {
        super(in);
    }

    public ActionRequestValidationException validateIndexName(String indexName, ActionRequestValidationException validationException) {
        if (indexName != null) {
            try {
                MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, InvalidIndexNameException::new);
            }
            catch (InvalidIndexNameException e) {
                return ValidateActions.addValidationError((String)e.toString(), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public String[] indices() {
        return new String[]{".elastic-connectors-v1"};
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandHidden();
    }
}

