/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResults;

public class GetAutoscalingCapacityAction
extends ActionType<Response> {
    public static final GetAutoscalingCapacityAction INSTANCE = new GetAutoscalingCapacityAction();
    public static final String NAME = "cluster:admin/autoscaling/get_autoscaling_capacity";

    private GetAutoscalingCapacityAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final SortedMap<String, AutoscalingDeciderResults> results;

        public Response(SortedMap<String, AutoscalingDeciderResults> results) {
            this.results = Objects.requireNonNull(results);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.results = new TreeMap<String, AutoscalingDeciderResults>(in.readMap(AutoscalingDeciderResults::new));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.results, StreamOutput::writeWriteable);
        }

        public SortedMap<String, AutoscalingDeciderResults> results() {
            return this.results;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("policies");
            for (Map.Entry<String, AutoscalingDeciderResults> entry : this.results.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.results.equals(response.results);
        }

        public int hashCode() {
            return Objects.hash(this.results);
        }

        public Map<String, AutoscalingDeciderResults> getResults() {
            return this.results;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_15_0)) {
                in.readTimeValue();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_15_0)) {
                out.writeTimeValue(AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
            }
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && ((Object)((Object)this)).getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }
}

