/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class EnrichResultBuilderForBoolean
extends EnrichResultBuilder {
    private ObjectArray<boolean[]> cells;

    EnrichResultBuilderForBoolean(BlockFactory blockFactory, int channel) {
        super(blockFactory, channel);
        this.cells = blockFactory.bigArrays().newObjectArray(1L);
    }

    @Override
    void addInputPage(IntVector positions, Page page) {
        BooleanBlock block = (BooleanBlock)page.getBlock(this.channel);
        for (int i = 0; i < positions.getPositionCount(); ++i) {
            int valueCount = block.getValueCount(i);
            if (valueCount == 0) continue;
            int cellPosition = positions.getInt(i);
            this.cells = this.blockFactory.bigArrays().grow(this.cells, (long)(cellPosition + 1));
            boolean[] oldCell = (boolean[])this.cells.get((long)cellPosition);
            boolean[] newCell = this.extendCell(oldCell, valueCount);
            this.cells.set((long)cellPosition, (Object)newCell);
            int dstIndex = oldCell != null ? oldCell.length : 0;
            this.adjustBreaker(RamUsageEstimator.sizeOf((boolean[])newCell) - (oldCell != null ? RamUsageEstimator.sizeOf((boolean[])oldCell) : 0L));
            int firstValueIndex = block.getFirstValueIndex(i);
            for (int v = 0; v < valueCount; ++v) {
                newCell[dstIndex + v] = block.getBoolean(firstValueIndex + v);
            }
        }
    }

    private boolean[] extendCell(boolean[] oldCell, int newValueCount) {
        if (oldCell == null) {
            return new boolean[newValueCount];
        }
        return Arrays.copyOf(oldCell, oldCell.length + newValueCount);
    }

    private boolean[] combineCell(boolean[] first, boolean[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        boolean[] result = new boolean[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void appendGroupToBlockBuilder(BooleanBlock.Builder builder, boolean[] group) {
        if (group == null) {
            builder.appendNull();
        } else if (group.length == 1) {
            builder.appendBoolean(group[0]);
        } else {
            builder.beginPositionEntry();
            for (boolean v : group) {
                builder.appendBoolean(v);
            }
            builder.endPositionEntry();
        }
    }

    private boolean[] getCellOrNull(int position) {
        return (long)position < this.cells.size() ? (boolean[])this.cells.get((long)position) : null;
    }

    private Block buildWithSelected(IntBlock selected) {
        try (BooleanBlock.Builder builder = this.blockFactory.newBooleanBlockBuilder(selected.getPositionCount());){
            block9: for (int i = 0; i < selected.getPositionCount(); ++i) {
                int selectedCount = selected.getValueCount(i);
                switch (selectedCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        int groupId = selected.getInt(selected.getFirstValueIndex(i));
                        this.appendGroupToBlockBuilder(builder, this.getCellOrNull(groupId));
                        continue block9;
                    }
                    default: {
                        int firstValueIndex = selected.getFirstValueIndex(i);
                        boolean[] cell = this.getCellOrNull(selected.getInt(firstValueIndex));
                        for (int p = 1; p < selectedCount; ++p) {
                            int groupId = selected.getInt(firstValueIndex + p);
                            cell = this.combineCell(cell, this.getCellOrNull(groupId));
                        }
                        this.appendGroupToBlockBuilder(builder, cell);
                    }
                }
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private Block buildWithSelected(IntVector selected) {
        try (BooleanBlock.Builder builder = this.blockFactory.newBooleanBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                this.appendGroupToBlockBuilder(builder, this.getCellOrNull(selected.getInt(i)));
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    @Override
    Block build(IntBlock selected) {
        IntVector vector = selected.asVector();
        if (vector != null) {
            return this.buildWithSelected(vector);
        }
        return this.buildWithSelected(selected);
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.cells, () -> super.close()});
    }
}

