/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;
import java.util.SplittableRandom;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQuery;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SampleOperator
implements Operator {
    private final Deque<Page> outputPages = new ArrayDeque<Page>();
    private final RandomSamplingQuery.RandomSamplingIterator randomSamplingIterator;
    private boolean finished = false;
    private int pagesProcessed = 0;
    private int rowsReceived = 0;
    private int rowsEmitted = 0;
    private long collectNanos;
    private long emitNanos;

    private SampleOperator(double probability, int seed) {
        SplittableRandom random = new SplittableRandom(seed);
        this.randomSamplingIterator = new RandomSamplingQuery.RandomSamplingIterator(Integer.MAX_VALUE, probability, random::nextInt);
        this.randomSamplingIterator.nextDoc();
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        long startTime = System.nanoTime();
        this.createOutputPage(page);
        this.rowsReceived += page.getPositionCount();
        page.releaseBlocks();
        ++this.pagesProcessed;
        this.collectNanos += System.nanoTime() - startTime;
    }

    private void createOutputPage(Page page) {
        int[] sampledPositions = new int[page.getPositionCount()];
        int sampledIdx = 0;
        int i = this.randomSamplingIterator.docID();
        while (i - this.rowsReceived < page.getPositionCount()) {
            sampledPositions[sampledIdx++] = i - this.rowsReceived;
            i = this.randomSamplingIterator.nextDoc();
        }
        if (sampledIdx > 0) {
            this.outputPages.add(page.filter(Arrays.copyOf(sampledPositions, sampledIdx)));
        }
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.outputPages.isEmpty();
    }

    @Override
    public Page getOutput() {
        Page page;
        long emitStart = System.nanoTime();
        if (this.outputPages.isEmpty()) {
            page = null;
        } else {
            page = this.outputPages.removeFirst();
            this.rowsEmitted += page.getPositionCount();
        }
        this.emitNanos += System.nanoTime() - emitStart;
        return page;
    }

    @Override
    public void close() {
        for (Page page : this.outputPages) {
            page.releaseBlocks();
        }
    }

    public String toString() {
        return "SampleOperator[sampled = " + this.rowsEmitted + "/" + this.rowsReceived + "]";
    }

    @Override
    public Operator.Status status() {
        return new Status(this.collectNanos, this.emitNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
    }

    private record Status(long collectNanos, long emitNanos, int pagesProcessed, int rowsReceived, int rowsEmitted) implements Operator.Status
    {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "sample", Status::new);

        Status(StreamInput streamInput) throws IOException {
            this(streamInput.readVLong(), streamInput.readVLong(), streamInput.readVInt(), streamInput.readVInt(), streamInput.readVInt());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.collectNanos);
            out.writeVLong(this.emitNanos);
            out.writeVInt(this.pagesProcessed);
            out.writeVInt(this.rowsReceived);
            out.writeVInt(this.rowsEmitted);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("collect_nanos", this.collectNanos);
            if (builder.humanReadable()) {
                builder.field("collect_time", (Object)TimeValue.timeValueNanos((long)this.collectNanos));
            }
            builder.field("emit_nanos", this.emitNanos);
            if (builder.humanReadable()) {
                builder.field("emit_time", (Object)TimeValue.timeValueNanos((long)this.emitNanos));
            }
            builder.field("pages_processed", this.pagesProcessed);
            builder.field("rows_received", this.rowsReceived);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder.endObject();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status other = (Status)o;
            return this.collectNanos == other.collectNanos && this.emitNanos == other.emitNanos && this.pagesProcessed == other.pagesProcessed && this.rowsReceived == other.rowsReceived && this.rowsEmitted == other.rowsEmitted;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.collectNanos, this.emitNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.ZERO;
        }
    }

    public static class Factory
    implements Operator.OperatorFactory {
        private final double probability;
        private final Integer seed;

        public Factory(double probability) {
            this(probability, null);
        }

        Factory(double probability, Integer seed) {
            this.probability = probability;
            this.seed = seed;
        }

        @Override
        public SampleOperator get(DriverContext driverContext) {
            return new SampleOperator(this.probability, this.seed == null ? Randomness.get().nextInt() : this.seed.intValue());
        }

        @Override
        public String describe() {
            return "SampleOperator[probability = " + this.probability + "]";
        }
    }
}

