/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public abstract class ValuesReader
implements ReleasableIterator<Block[]> {
    protected final ValuesSourceReaderOperator operator;
    protected final DocVector docs;
    private int offset;

    ValuesReader(ValuesSourceReaderOperator operator, DocVector docs) {
        this.operator = operator;
        this.docs = docs;
    }

    public boolean hasNext() {
        return this.offset < this.docs.getPositionCount();
    }

    public Block[] next() {
        Releasable[] target = new Block[this.operator.fields.length];
        boolean success = false;
        try {
            this.load((Block[])target, this.offset);
            success = true;
            for (Releasable b : target) {
                this.operator.valuesLoaded += (long)b.getTotalValueCount();
            }
            this.offset += target[0].getPositionCount();
            Releasable[] releasableArray = target;
            return releasableArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])target);
            }
        }
    }

    protected abstract void load(Block[] var1, int var2) throws IOException;

    public void close() {
    }
}

