/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AggregateMetricDoubleArrayBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public interface Block
extends Accountable,
BlockLoader.Block,
Writeable,
RefCounted,
Releasable {
    public static final long MAX_LOOKUP = 100000L;
    public static final int PAGE_MEM_OVERHEAD_PER_BLOCK;
    public static final byte SERIALIZE_BLOCK_VALUES = 0;
    public static final byte SERIALIZE_BLOCK_VECTOR = 1;
    public static final byte SERIALIZE_BLOCK_ARRAY = 2;
    public static final byte SERIALIZE_BLOCK_BIG_ARRAY = 3;
    public static final byte SERIALIZE_BLOCK_ORDINAL = 3;

    public Vector asVector();

    public int getTotalValueCount();

    public int getPositionCount();

    public int getFirstValueIndex(int var1);

    public int getValueCount(int var1);

    public ElementType elementType();

    public BlockFactory blockFactory();

    public void allowPassingToDifferentDriver();

    public boolean isReleased();

    public boolean isNull(int var1);

    public boolean mayHaveNulls();

    public boolean areAllValuesNull();

    public boolean mayHaveMultivaluedFields();

    public boolean doesHaveMultivaluedFields();

    public Block filter(int ... var1);

    public Block keepMask(BooleanVector var1);

    public ReleasableIterator<? extends Block> lookup(IntBlock var1, ByteSizeValue var2);

    public MvOrdering mvOrdering();

    default public boolean mvDeduplicated() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().deduplicated;
    }

    default public boolean mvSortedAscending() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().sortedAscending;
    }

    public Block expand();

    default public Block insertNulls(IntVector before) {
        int myCount = this.getPositionCount();
        int beforeCount = before.getPositionCount();
        try (Builder builder = this.elementType().newBlockBuilder(myCount + beforeCount, this.blockFactory());){
            int beforeP = 0;
            int nextNull = before.getInt(beforeP);
            for (int mainP = 0; mainP < myCount; ++mainP) {
                while (mainP == nextNull) {
                    builder.appendNull();
                    if (++beforeP >= beforeCount) {
                        builder.copyFrom(this, mainP, myCount);
                        Block block = builder.build();
                        return block;
                    }
                    nextNull = before.getInt(beforeP);
                }
                builder.copyFrom(this, mainP, mainP + 1);
            }
            if (!1.$assertionsDisabled && nextNull != myCount) {
                throw new AssertionError();
            }
            while (beforeP < beforeCount) {
                nextNull = before.getInt(beforeP++);
                if (!1.$assertionsDisabled && nextNull != myCount) {
                    throw new AssertionError();
                }
                builder.appendNull();
            }
            Block block = builder.build();
            return block;
        }
    }

    public void writeTo(StreamOutput var1) throws IOException;

    public static void writeTypedBlock(Block block, StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)TransportVersions.ESQL_AGGREGATE_METRIC_DOUBLE_BLOCK_8_19) && block instanceof AggregateMetricDoubleArrayBlock) {
            AggregateMetricDoubleArrayBlock aggregateMetricDoubleBlock = (AggregateMetricDoubleArrayBlock)block;
            block = aggregateMetricDoubleBlock.asCompositeBlock();
        }
        block.elementType().writeTo(out);
        block.writeTo(out);
    }

    public static Block readTypedBlock(BlockStreamInput in) throws IOException {
        ElementType elementType = ElementType.readFrom((StreamInput)in);
        Block block = elementType.reader.readBlock(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.ESQL_AGGREGATE_METRIC_DOUBLE_BLOCK_8_19) && block instanceof CompositeBlock) {
            CompositeBlock compositeBlock = (CompositeBlock)block;
            block = AggregateMetricDoubleArrayBlock.fromCompositeBlock(compositeBlock);
        }
        return block;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        PAGE_MEM_OVERHEAD_PER_BLOCK = RamUsageEstimator.NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static enum MvOrdering {
        UNORDERED(false, false),
        DEDUPLICATED_UNORDERD(true, false),
        DEDUPLICATED_AND_SORTED_ASCENDING(true, true),
        SORTED_ASCENDING(false, true);

        private final boolean deduplicated;
        private final boolean sortedAscending;

        private MvOrdering(boolean deduplicated, boolean sortedAscending) {
            this.deduplicated = deduplicated;
            this.sortedAscending = sortedAscending;
        }
    }

    public static interface Builder
    extends BlockLoader.Builder,
    Releasable {
        public Builder appendNull();

        public Builder beginPositionEntry();

        public Builder endPositionEntry();

        public Builder copyFrom(Block var1, int var2, int var3);

        public Builder mvOrdering(MvOrdering var1);

        public long estimatedBytes();

        public Block build();

        public static Block[] buildAll(Builder ... builders) {
            Releasable[] blocks = new Block[builders.length];
            try {
                for (int b = 0; b < blocks.length; ++b) {
                    blocks[b] = builders[b].build();
                }
            }
            finally {
                if (blocks[blocks.length - 1] == null) {
                    Releasables.closeExpectNoException((Releasable[])blocks);
                }
            }
            return blocks;
        }
    }
}

