/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoPointSourceValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGroupingStateWrappedLongitudeState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.INT), new IntermediateStateDesc("bottom", ElementType.INT), new IntermediateStateDesc("negLeft", ElementType.INT), new IntermediateStateDesc("negRight", ElementType.INT), new IntermediateStateDesc("posLeft", ElementType.INT), new IntermediateStateDesc("posRight", ElementType.INT));
    private final SpatialExtentGroupingStateWrappedLongitudeState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction(List<Integer> channels, SpatialExtentGroupingStateWrappedLongitudeState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction(channels, SpatialExtentGeoPointSourceValuesAggregator.initGrouping(), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        final BytesRefVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, groupId, values.getBytesRef(v, scratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefVector values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, groupId, values.getBytesRef(groupPosition + positionOffset, scratch));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, groupId, values.getBytesRef(v, scratch));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, BytesRefVector values) {
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                SpatialExtentGeoPointSourceValuesAggregator.combine(this.state, groupId, values.getBytesRef(groupPosition + positionOffset, scratch));
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (top.getPositionCount() == bottom.getPositionCount() && top.getPositionCount() == negLeft.getPositionCount() && top.getPositionCount() == negRight.getPositionCount() && top.getPositionCount() == posLeft.getPositionCount() && top.getPositionCount() == posRight.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            SpatialExtentGeoPointSourceValuesAggregator.combineIntermediate(this.state, groupId, top.getInt(groupPosition + positionOffset), bottom.getInt(groupPosition + positionOffset), negLeft.getInt(groupPosition + positionOffset), negRight.getInt(groupPosition + positionOffset), posLeft.getInt(groupPosition + positionOffset), posRight.getInt(groupPosition + positionOffset));
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + String.valueOf(this.getClass()) + "; got " + String.valueOf(input.getClass()));
        }
        SpatialExtentGroupingStateWrappedLongitudeState inState = ((SpatialExtentGeoPointSourceValuesGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        SpatialExtentGeoPointSourceValuesAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = SpatialExtentGeoPointSourceValuesAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

