/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.BaseCells;
import org.elasticsearch.h3.Constants;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.FaceIJK;
import org.elasticsearch.h3.H3;

final class H3Index {
    public static long H3_INIT = 0x1FFFFFFFFFFFL;
    public static int H3_MODE_OFFSET = 59;
    public static long H3_MODE_MASK = 15L << H3_MODE_OFFSET;
    public static long H3_MODE_MASK_NEGATIVE = H3_MODE_MASK ^ 0xFFFFFFFFFFFFFFFFL;
    public static int H3_BC_OFFSET = 45;
    public static long H3_BC_MASK = 127L << H3_BC_OFFSET;
    public static long H3_BC_MASK_NEGATIVE = H3_BC_MASK ^ 0xFFFFFFFFFFFFFFFFL;
    public static int H3_RES_OFFSET = 52;
    public static long H3_RES_MASK = 15L << H3_RES_OFFSET;
    public static long H3_RES_MASK_NEGATIVE = H3_RES_MASK ^ 0xFFFFFFFFFFFFFFFFL;
    public static int H3_MAX_OFFSET = 63;
    public static long H3_HIGH_BIT_MASK = 1L << H3_MAX_OFFSET;
    public static int H3_RESERVED_OFFSET = 56;
    public static long H3_RESERVED_MASK = 7L << H3_RESERVED_OFFSET;
    public static int H3_PER_DIGIT_OFFSET = 3;
    public static long H3_DIGIT_MASK = 7L;

    H3Index() {
    }

    public static int H3_get_base_cell(long h3) {
        return (int)((h3 & H3_BC_MASK) >> H3_BC_OFFSET);
    }

    public static boolean H3_is_pentagon(long h3) {
        return BaseCells.isBaseCellPentagon(H3Index.H3_get_base_cell(h3)) && H3Index.h3LeadingNonZeroDigit(h3) == 0;
    }

    public static long H3_set_mode(long h3, long mode) {
        return h3 & H3_MODE_MASK_NEGATIVE | mode << H3_MODE_OFFSET;
    }

    public static long H3_set_base_cell(long h3, long bc) {
        return h3 & H3_BC_MASK_NEGATIVE | bc << H3_BC_OFFSET;
    }

    public static int H3_get_high_bit(long h3) {
        return (int)((h3 & H3_HIGH_BIT_MASK) >> H3_MAX_OFFSET);
    }

    public static long H3_set_resolution(long h3, long res) {
        return h3 & H3_RES_MASK_NEGATIVE | res << H3_RES_OFFSET;
    }

    public static int H3_get_reserved_bits(long h3) {
        return (int)((h3 & H3_RESERVED_MASK) >> H3_RESERVED_OFFSET);
    }

    public static int H3_get_mode(long h3) {
        return (int)((h3 & H3_MODE_MASK) >> H3_MODE_OFFSET);
    }

    public static int H3_get_resolution(long h3) {
        return (int)((h3 & H3_RES_MASK) >> H3_RES_OFFSET);
    }

    public static int H3_get_index_digit(long h3, int res) {
        return (int)(h3 >> (H3.MAX_H3_RES - res) * H3_PER_DIGIT_OFFSET & H3_DIGIT_MASK);
    }

    public static long H3_set_index_digit(long h3, int res, long digit) {
        int x = (H3.MAX_H3_RES - res) * H3_PER_DIGIT_OFFSET;
        return h3 & (H3_DIGIT_MASK << x ^ 0xFFFFFFFFFFFFFFFFL) | digit << x;
    }

    public static boolean isResolutionClassIII(int res) {
        return (res & 1) == 1;
    }

    public static FaceIJK h3ToFaceIjk(long h3) {
        boolean pentLeading4;
        FaceIJK fijk;
        int baseCell = H3Index.H3_get_base_cell(h3);
        if (baseCell < 0 || baseCell >= Constants.NUM_BASE_CELLS) {
            throw new IllegalArgumentException();
        }
        if (BaseCells.isBaseCellPentagon(baseCell) && H3Index.h3LeadingNonZeroDigit(h3) == 5) {
            h3 = H3Index.h3Rotate60cw(h3);
        }
        if (!H3Index.h3ToFaceIjkWithInitializedFijk(h3, fijk = BaseCells.getBaseFaceIJK(baseCell))) {
            return fijk;
        }
        int origI = fijk.coord.i;
        int origJ = fijk.coord.j;
        int origK = fijk.coord.k;
        int res = H3Index.H3_get_resolution(h3);
        if (H3Index.isResolutionClassIII(res)) {
            fijk.coord.downAp7r();
            ++res;
        }
        boolean bl = pentLeading4 = BaseCells.isBaseCellPentagon(baseCell) && H3Index.h3LeadingNonZeroDigit(h3) == 4;
        if (fijk.adjustOverageClassII(res, pentLeading4, false) != FaceIJK.Overage.NO_OVERAGE) {
            if (BaseCells.isBaseCellPentagon(baseCell)) {
                FaceIJK.Overage overage;
                while ((overage = fijk.adjustOverageClassII(res, false, false)) != FaceIJK.Overage.NO_OVERAGE) {
                }
            }
            if (res != H3Index.H3_get_resolution(h3)) {
                fijk.coord.upAp7r();
            }
        } else if (res != H3Index.H3_get_resolution(h3)) {
            fijk.coord.reset(origI, origJ, origK);
        }
        return fijk;
    }

    public static int h3LeadingNonZeroDigit(long h) {
        for (int r = 1; r <= H3Index.H3_get_resolution(h); ++r) {
            int dir = H3Index.H3_get_index_digit(h, r);
            if (dir == CoordIJK.Direction.CENTER_DIGIT.digit()) continue;
            return dir;
        }
        return CoordIJK.Direction.CENTER_DIGIT.digit();
    }

    private static boolean h3ToFaceIjkWithInitializedFijk(long h, FaceIJK fijk) {
        int res = H3Index.H3_get_resolution(h);
        boolean possibleOverage = BaseCells.isBaseCellPentagon(H3Index.H3_get_base_cell(h)) || res != 0 && (fijk.coord.i != 0 || fijk.coord.j != 0 || fijk.coord.k != 0);
        for (int r = 1; r <= res; ++r) {
            if (H3Index.isResolutionClassIII(r)) {
                fijk.coord.downAp7();
            } else {
                fijk.coord.downAp7r();
            }
            fijk.coord.neighbor(H3Index.H3_get_index_digit(h, r));
        }
        return possibleOverage;
    }

    public static long h3Rotate60cw(long h) {
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60cw(H3Index.H3_get_index_digit(h, r)));
        }
        return h;
    }

    public static long h3Rotate60ccw(long h) {
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60ccw(H3Index.H3_get_index_digit(h, r)));
        }
        return h;
    }

    public static long h3RotatePent60ccw(long h) {
        boolean foundFirstNonZeroDigit = false;
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60ccw(H3Index.H3_get_index_digit(h, r)));
            if (foundFirstNonZeroDigit || H3Index.H3_get_index_digit(h, r) == 0) continue;
            foundFirstNonZeroDigit = true;
            if (H3Index.h3LeadingNonZeroDigit(h) != CoordIJK.Direction.K_AXES_DIGIT.digit()) continue;
            h = H3Index.h3Rotate60ccw(h);
        }
        return h;
    }
}

