/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.CreateDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateDataStreamAction
extends AcknowledgedTransportMasterNodeAction<CreateDataStreamAction.Request> {
    private final MetadataCreateDataStreamService metadataCreateDataStreamService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportCreateDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, MetadataCreateDataStreamService metadataCreateDataStreamService, SystemIndices systemIndices) {
        super("indices:admin/data_stream/create", transportService, clusterService, threadPool, actionFilters, CreateDataStreamAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.metadataCreateDataStreamService = metadataCreateDataStreamService;
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, CreateDataStreamAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        SystemDataStreamDescriptor systemDataStreamDescriptor = this.systemIndices.validateDataStreamAccess(request.getName(), this.threadPool.getThreadContext());
        MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest updateRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(request.getName(), request.getStartTime(), systemDataStreamDescriptor, request.masterNodeTimeout(), request.ackTimeout(), true);
        this.metadataCreateDataStreamService.createDataStream(updateRequest, listener);
    }

    protected ClusterBlockException checkBlock(CreateDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

