/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.ShapeValuesSource;

public abstract class GeoShapeValuesSource
extends ShapeValuesSource<GeoShapeValues> {
    public static final GeoShapeValuesSource EMPTY = new GeoShapeValuesSource(){

        @Override
        public GeoShapeValues shapeValues(LeafReaderContext context) {
            return GeoShapeValues.EMPTY;
        }
    };

    protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) {
        throw AggregationErrors.unsupportedRounding((String)"geo_shape");
    }

    public static class Fielddata
    extends GeoShapeValuesSource {
        protected final IndexShapeFieldData<GeoShapeValues> indexFieldData;

        public Fielddata(IndexShapeFieldData<GeoShapeValues> indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafShapeFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public GeoShapeValues shapeValues(LeafReaderContext context) {
            return (GeoShapeValues)((LeafShapeFieldData)this.indexFieldData.load(context)).getShapeValues();
        }
    }
}

