/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexCartesianPointFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.CartesianShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.ShapeValuesSourceType;

public class CartesianShapeValuesSourceType
extends ShapeValuesSourceType {
    static CartesianShapeValuesSourceType INSTANCE = new CartesianShapeValuesSourceType();

    public static CartesianShapeValuesSourceType instance() {
        return INSTANCE;
    }

    public ValuesSource getEmpty() {
        return CartesianShapeValuesSource.EMPTY;
    }

    @Override
    public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
        boolean isPoint = fieldContext.indexFieldData() instanceof IndexCartesianPointFieldData;
        boolean isShape = fieldContext.indexFieldData() instanceof IndexShapeFieldData;
        if (!isPoint && !isShape) {
            throw new IllegalArgumentException("Expected point or shape type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
        }
        if (isPoint) {
            return new CartesianPointValuesSource.Fielddata((IndexCartesianPointFieldData)fieldContext.indexFieldData());
        }
        return new CartesianShapeValuesSource.Fielddata((CartesianShapeIndexFieldData)fieldContext.indexFieldData());
    }

    public ValuesSource replaceMissing(final ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
        final CartesianShapeValuesSource shapeValuesSource = (CartesianShapeValuesSource)valuesSource;
        final CartesianShapeValues.CartesianShapeValue missing = (CartesianShapeValues.CartesianShapeValue)CartesianShapeValues.EMPTY.missing(rawMissing.toString());
        return new CartesianShapeValuesSource(){

            @Override
            public CartesianShapeValues shapeValues(LeafReaderContext context) {
                final CartesianShapeValues values = (CartesianShapeValues)shapeValuesSource.shapeValues(context);
                return new CartesianShapeValues(){
                    private boolean exists;

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        this.exists = values.advanceExact(doc);
                        return true;
                    }

                    @Override
                    public ValuesSourceType valuesSourceType() {
                        return values.valuesSourceType();
                    }

                    @Override
                    public CartesianShapeValues.CartesianShapeValue value() throws IOException {
                        return this.exists ? (CartesianShapeValues.CartesianShapeValue)values.value() : missing;
                    }

                    public String toString() {
                        return "anon MultiShapeValues of [" + super.toString() + "]";
                    }
                };
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing((SortedBinaryDocValues)valuesSource.bytesValues(context), (BytesRef)new BytesRef((CharSequence)missing.toString()));
            }
        };
    }

    public String typeName() {
        return "shape";
    }
}

