/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli.keystore;

import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cli.keystore.BaseKeyStoreCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;

class AddStringKeyStoreCommand
extends BaseKeyStoreCommand {
    private final OptionSpec<Void> stdinOption;
    private final OptionSpec<String> arguments;

    AddStringKeyStoreCommand() {
        super("Add string settings to the keystore", false);
        this.stdinOption = this.parser.acceptsAll(Arrays.asList("x", "stdin"), "Read setting values from stdin");
        this.forceOption = this.parser.acceptsAll(Arrays.asList("f", "force"), "Overwrite existing setting without prompting, creating keystore if necessary");
        this.arguments = this.parser.nonOptions("setting names");
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List settings = this.arguments.values(options);
        if (settings.isEmpty()) {
            throw new UserException(64, "the setting names can not be empty");
        }
        KeyStoreWrapper keyStore = this.getKeyStore();
        CheckedFunction valueSupplier = s -> {
            Object prompt = options.has(this.stdinOption) ? "" : "Enter value for " + s + ": ";
            return terminal.readSecret((String)prompt);
        };
        for (String setting : settings) {
            if (keyStore.getSettingNames().contains(setting) && !options.has(this.forceOption) && !terminal.promptYesNo("Setting " + setting + " already exists. Overwrite?", false)) {
                terminal.println((CharSequence)"Exiting without modifying keystore.");
                return;
            }
            try {
                keyStore.setString(setting, (char[])valueSupplier.apply((Object)setting));
            }
            catch (IllegalArgumentException e) {
                throw new UserException(65, e.getMessage());
            }
        }
        keyStore.save(env.configDir(), this.getKeyStorePassword().getChars());
    }
}

