/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;
import org.elasticsearch.xpack.ilm.action.TransportDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportPutLifecycleAction;

public class ReservedLifecycleAction
implements ReservedClusterStateHandler<List<LifecyclePolicy>> {
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;
    public static final String NAME = "ilm";

    public ReservedLifecycleAction(NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.licenseState = licenseState;
    }

    public String name() {
        return NAME;
    }

    public Collection<PutLifecycleRequest> prepare(Object input) throws IOException {
        ArrayList<PutLifecycleRequest> result = new ArrayList<PutLifecycleRequest>();
        List policies = (List)input;
        for (LifecyclePolicy policy : policies) {
            PutLifecycleRequest request = new PutLifecycleRequest(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, policy);
            this.validate((MasterNodeRequest)request);
            result.add(request);
        }
        return result;
    }

    public TransformState transform(Object source, TransformState prevState) throws Exception {
        Collection<PutLifecycleRequest> requests = this.prepare(source);
        ClusterState state = prevState.state();
        for (PutLifecycleRequest request : requests) {
            TransportPutLifecycleAction.UpdateLifecyclePolicyTask task = new TransportPutLifecycleAction.UpdateLifecyclePolicyTask(request, this.licenseState, this.xContentRegistry, this.client);
            state = task.execute(state);
        }
        Set entities = requests.stream().map(r -> r.getPolicy().getName()).collect(Collectors.toSet());
        HashSet toDelete = new HashSet(prevState.keys());
        toDelete.removeAll(entities);
        for (String policyToDelete : toDelete) {
            TransportDeleteLifecycleAction.DeleteLifecyclePolicyTask task = new TransportDeleteLifecycleAction.DeleteLifecyclePolicyTask(new DeleteLifecycleAction.Request(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, policyToDelete), (ActionListener<AcknowledgedResponse>)ActionListener.noop());
            state = task.execute(state);
        }
        return new TransformState(state, entities);
    }

    public ClusterState remove(TransformState prevState) throws Exception {
        return this.transform(List.of(), prevState).state();
    }

    public List<LifecyclePolicy> fromXContent(XContentParser parser) throws IOException {
        ArrayList<LifecyclePolicy> result = new ArrayList<LifecyclePolicy>();
        Map source = parser.map();
        XContentParserConfiguration config = XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry);
        for (String name : source.keySet()) {
            Map content = (Map)source.get(name);
            XContentParser policyParser = XContentHelper.mapToXContentParser((XContentParserConfiguration)config, (Map)content);
            try {
                result.add(LifecyclePolicy.parse((XContentParser)policyParser, (String)name));
            }
            finally {
                if (policyParser == null) continue;
                policyParser.close();
            }
        }
        return result;
    }

    public Collection<String> optionalDependencies() {
        return List.of("snapshot_repositories");
    }
}

