/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.InitializePolicyContextStep;
import org.elasticsearch.xpack.core.ilm.InitializePolicyException;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionStateUtils;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseCompleteStep;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TerminalPolicyStep;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;

public final class IndexLifecycleTransition {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleTransition.class);

    public static void validateTransition(IndexMetadata idxMeta, Step.StepKey currentStepKey, Step.StepKey newStepKey, PolicyStepsRegistry stepRegistry) {
        boolean isNewStepCached;
        String indexName = idxMeta.getIndex().getName();
        String policyName = idxMeta.getLifecyclePolicyName();
        if (Strings.isNullOrEmpty((String)policyName)) {
            throw new IllegalArgumentException("index [" + indexName + "] is not associated with an Index Lifecycle Policy");
        }
        LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
        Step.StepKey realKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        if (currentStepKey != null && !currentStepKey.equals((Object)realKey)) {
            throw new IllegalArgumentException("index [" + indexName + "] is not on current step [" + currentStepKey + "], currently: [" + realKey + "]");
        }
        Set<Step.StepKey> cachedStepKeys = stepRegistry.parseStepKeysFromPhase(policyName, lifecycleState.phase(), lifecycleState.phaseDefinition());
        boolean bl = isNewStepCached = cachedStepKeys != null && cachedStepKeys.contains(newStepKey);
        if (!(isNewStepCached || stepRegistry.stepExists(policyName, newStepKey) || newStepKey.equals((Object)TerminalPolicyStep.KEY) || newStepKey.equals((Object)PhaseCompleteStep.stepKey((String)lifecycleState.phase())))) {
            throw new IllegalArgumentException("step [" + newStepKey + "] for index [" + indexName + "] with policy [" + policyName + "] does not exist");
        }
    }

    static ClusterState moveClusterStateToStep(Index index, ClusterState state, Step.StepKey newStepKey, LongSupplier nowSupplier, PolicyStepsRegistry stepRegistry, boolean forcePhaseDefinitionRefresh) {
        IndexMetadata idxMeta = state.getMetadata().index(index);
        Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)idxMeta.getLifecycleExecutionState());
        IndexLifecycleTransition.validateTransition(idxMeta, currentStepKey, newStepKey, stepRegistry);
        String policyName = idxMeta.getLifecyclePolicyName();
        logger.info("moving index [{}] from [{}] to [{}] in policy [{}]", (Object)index.getName(), (Object)currentStepKey, (Object)newStepKey, (Object)policyName);
        IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(idxMeta.getLifecyclePolicyName());
        LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
        LifecycleExecutionState newLifecycleState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, lifecycleState, newStepKey, nowSupplier, forcePhaseDefinitionRefresh, true);
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState((ClusterState)state, (Index)idxMeta.getIndex(), (LifecycleExecutionState)newLifecycleState);
    }

    static ClusterState moveClusterStateToErrorStep(Index index, ClusterState clusterState, Exception cause, LongSupplier nowSupplier, BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction) {
        IndexMetadata idxMeta = clusterState.getMetadata().index(index);
        IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)clusterState.metadata().custom("index_lifecycle");
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(idxMeta.getLifecyclePolicyName());
        LifecycleExecutionState currentState = idxMeta.getLifecycleExecutionState();
        Step.StepKey currentStep = cause instanceof InitializePolicyException ? InitializePolicyContextStep.KEY : Objects.requireNonNull(Step.getCurrentStepKey((LifecycleExecutionState)currentState), "unable to move to an error step where there is no current step, state: " + currentState);
        LifecycleExecutionState nextStepState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, currentState, new Step.StepKey(currentStep.phase(), currentStep.action(), "ERROR"), nowSupplier, false, false);
        LifecycleExecutionState.Builder failedState = LifecycleExecutionState.builder((LifecycleExecutionState)nextStepState);
        failedState.setFailedStep(currentStep.name());
        failedState.setStepInfo(Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)cause);
            return builder;
        }));
        Step failedStep = stepLookupFunction.apply(idxMeta, currentStep);
        if (failedStep != null) {
            failedState.setIsAutoRetryableError(Boolean.valueOf(failedStep.isRetryable()));
            failedState.setFailedStepRetryCount(currentState.failedStepRetryCount());
        } else {
            logger.warn("failed step [{}] for index [{}] is not part of policy [{}] anymore, or it is invalid", (Object)currentStep.name(), (Object)index, (Object)policyMetadata.getName());
        }
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState((ClusterState)clusterState, (Index)idxMeta.getIndex(), (LifecycleExecutionState)failedState.build());
    }

    static ClusterState moveClusterStateToPreviouslyFailedStep(ClusterState currentState, String index, LongSupplier nowSupplier, PolicyStepsRegistry stepRegistry, boolean isAutomaticRetry) {
        LifecycleExecutionState.Builder retryStepState;
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (indexMetadata == null) {
            throw new IllegalArgumentException("index [" + index + "] does not exist");
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        String failedStep = lifecycleState.failedStep();
        if (currentStepKey != null && "ERROR".equals(currentStepKey.name()) && !Strings.isNullOrEmpty((String)failedStep)) {
            Step.StepKey nextStepKey = new Step.StepKey(currentStepKey.phase(), currentStepKey.action(), failedStep);
            IndexLifecycleTransition.validateTransition(indexMetadata, currentStepKey, nextStepKey, stepRegistry);
            IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
            LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(indexMetadata.getLifecyclePolicyName());
            Map policyPhases = policyMetadata.getPolicy().getPhases();
            boolean forcePhaseDefinitionRefresh = policyPhases.get(nextStepKey.phase()) != null && ((Phase)policyPhases.get(nextStepKey.phase())).getActions().get(nextStepKey.action()) != null;
            LifecycleExecutionState nextStepState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, lifecycleState, nextStepKey, nowSupplier, forcePhaseDefinitionRefresh, false);
            retryStepState = LifecycleExecutionState.builder((LifecycleExecutionState)nextStepState);
            retryStepState.setIsAutoRetryableError(lifecycleState.isAutoRetryableError());
            Integer currentRetryCount = lifecycleState.failedStepRetryCount();
            if (isAutomaticRetry) {
                int n;
                if (currentRetryCount == null) {
                    n = 1;
                } else {
                    currentRetryCount = currentRetryCount + 1;
                    n = currentRetryCount;
                }
                retryStepState.setFailedStepRetryCount(Integer.valueOf(n));
            } else {
                retryStepState.setFailedStepRetryCount(lifecycleState.failedStepRetryCount());
            }
        } else {
            throw new IllegalArgumentException("cannot retry an action for an index [" + index + "] that has not encountered an error when running a Lifecycle Policy");
        }
        ClusterState newState = LifecycleExecutionStateUtils.newClusterStateWithLifecycleState((ClusterState)currentState, (Index)indexMetadata.getIndex(), (LifecycleExecutionState)retryStepState.build());
        return newState;
    }

    private static LifecycleExecutionState updateExecutionStateToStep(LifecyclePolicyMetadata policyMetadata, LifecycleExecutionState existingState, Step.StepKey newStep, LongSupplier nowSupplier, boolean forcePhaseDefinitionRefresh, boolean allowNullPreviousStepInfo) {
        Step.StepKey currentStep = Step.getCurrentStepKey((LifecycleExecutionState)existingState);
        long nowAsMillis = nowSupplier.getAsLong();
        LifecycleExecutionState.Builder updatedState = LifecycleExecutionState.builder((LifecycleExecutionState)existingState);
        updatedState.setPhase(newStep.phase());
        updatedState.setAction(newStep.action());
        updatedState.setStep(newStep.name());
        updatedState.setStepTime(Long.valueOf(nowAsMillis));
        updatedState.setFailedStep(null);
        if (allowNullPreviousStepInfo || existingState.stepInfo() != null) {
            updatedState.setPreviousStepInfo(existingState.stepInfo());
        }
        updatedState.setStepInfo(null);
        updatedState.setIsAutoRetryableError(null);
        updatedState.setFailedStepRetryCount(null);
        if (currentStep == null || !currentStep.phase().equals(newStep.phase()) || forcePhaseDefinitionRefresh) {
            Phase nextPhase = "new".equals(newStep.phase()) || TerminalPolicyStep.KEY.equals((Object)newStep) ? null : (Phase)policyMetadata.getPolicy().getPhases().get(newStep.phase());
            PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(policyMetadata.getName(), nextPhase, policyMetadata.getVersion(), policyMetadata.getModifiedDate());
            String newPhaseDefinition = Strings.toString((ToXContent)phaseExecutionInfo, (boolean)false, (boolean)false);
            updatedState.setPhaseDefinition(newPhaseDefinition);
            updatedState.setPhaseTime(Long.valueOf(nowAsMillis));
        } else if (currentStep.phase().equals("new")) {
            updatedState.setPhaseTime(Long.valueOf(nowAsMillis));
        }
        if (currentStep == null || !currentStep.action().equals(newStep.action())) {
            updatedState.setActionTime(Long.valueOf(nowAsMillis));
        }
        return updatedState.build();
    }

    public static LifecycleExecutionState moveStateToNextActionAndUpdateCachedPhase(IndexMetadata indexMetadata, LifecycleExecutionState existingState, LongSupplier nowSupplier, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicyMetadata, Client client, XPackLicenseState licenseState) {
        String indexName = indexMetadata.getIndex().getName();
        String policyName = indexMetadata.getLifecyclePolicyName();
        Step.StepKey currentStepKey = Step.getCurrentStepKey((LifecycleExecutionState)existingState);
        if (currentStepKey == null) {
            logger.warn("unable to identify what the current step is for index [{}] as part of policy [{}]. the cached phase definition will not be updated for this index", (Object)indexName, (Object)policyName);
            return existingState;
        }
        List policySteps = oldPolicy.toSteps(client, licenseState);
        Optional<Step> currentStep = policySteps.stream().filter(step -> step.getKey().equals((Object)currentStepKey)).findFirst();
        if (!currentStep.isPresent()) {
            logger.warn("unable to find current step [{}] for index [{}] as part of policy [{}]. the cached phase definition will not be updated for this index", (Object)currentStepKey, (Object)indexName, (Object)policyName);
            return existingState;
        }
        int indexOfCurrentStep = policySteps.indexOf(currentStep.get());
        assert (indexOfCurrentStep != -1) : "the current step must be part of the old policy";
        Optional<Step> nextStepInActionAfterCurrent = policySteps.stream().skip(indexOfCurrentStep).filter(step -> !step.getKey().action().equals(currentStepKey.action())).findFirst();
        assert (nextStepInActionAfterCurrent.isPresent()) : "there should always be a complete step at the end of every phase";
        Step.StepKey nextStep = nextStepInActionAfterCurrent.get().getKey();
        logger.debug("moving index [{}] in policy [{}] out of step [{}] to new step [{}]", (Object)indexName, (Object)policyName, (Object)currentStepKey, (Object)nextStep);
        long nowAsMillis = nowSupplier.getAsLong();
        LifecycleExecutionState.Builder updatedState = LifecycleExecutionState.builder((LifecycleExecutionState)existingState);
        updatedState.setPhase(nextStep.phase());
        updatedState.setAction(nextStep.action());
        updatedState.setActionTime(Long.valueOf(nowAsMillis));
        updatedState.setStep(nextStep.name());
        updatedState.setStepTime(Long.valueOf(nowAsMillis));
        updatedState.setFailedStep(null);
        updatedState.setPreviousStepInfo(null);
        updatedState.setStepInfo(null);
        updatedState.setIsAutoRetryableError(null);
        updatedState.setFailedStepRetryCount(null);
        PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(newPolicyMetadata.getPolicy().getName(), (Phase)newPolicyMetadata.getPolicy().getPhases().get(currentStepKey.phase()), newPolicyMetadata.getVersion(), newPolicyMetadata.getModifiedDate());
        updatedState.setPhaseDefinition(Strings.toString((ToXContent)phaseExecutionInfo, (boolean)false, (boolean)false));
        return updatedState.build();
    }

    static ClusterState addStepInfoToClusterState(Index index, ClusterState clusterState, ToXContentObject stepInfo) {
        IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
        if (indexMetadata == null) {
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String stepInfoString = Strings.toString((ToXContent)stepInfo);
        if (stepInfoString.equals(lifecycleState.stepInfo())) {
            return clusterState;
        }
        LifecycleExecutionState.Builder newState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState);
        newState.setStepInfo(stepInfoString);
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState((ClusterState)clusterState, (Index)indexMetadata.getIndex(), (LifecycleExecutionState)newState.build());
    }

    public static ClusterState removePolicyForIndexes(Index[] indices, ClusterState currentState, List<String> failedIndexes) {
        Metadata.Builder newMetadata = Metadata.builder((Metadata)currentState.getMetadata());
        boolean clusterStateChanged = false;
        for (Index index : indices) {
            IndexMetadata indexMetadata = currentState.getMetadata().index(index);
            if (indexMetadata == null) {
                failedIndexes.add(index.getName());
                continue;
            }
            IndexMetadata.Builder newIdxMetadata = IndexLifecycleTransition.removePolicyForIndex(indexMetadata);
            if (newIdxMetadata == null) continue;
            newMetadata.put(newIdxMetadata);
            clusterStateChanged = true;
        }
        if (clusterStateChanged) {
            ClusterState.Builder newClusterState = ClusterState.builder((ClusterState)currentState);
            newClusterState.metadata(newMetadata);
            return newClusterState.build();
        }
        return currentState;
    }

    private static IndexMetadata.Builder removePolicyForIndex(IndexMetadata indexMetadata) {
        Settings idxSettings = indexMetadata.getSettings();
        Settings.Builder newSettings = Settings.builder().put(idxSettings);
        boolean notChanged = true;
        notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(LifecycleSettings.LIFECYCLE_NAME_SETTING.getKey()));
        notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.getKey()));
        notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(LifecycleSettings.LIFECYCLE_SKIP_SETTING.getKey()));
        long newSettingsVersion = (notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.getKey()))) ? indexMetadata.getSettingsVersion() : 1L + indexMetadata.getSettingsVersion();
        IndexMetadata.Builder builder = IndexMetadata.builder((IndexMetadata)indexMetadata);
        builder.removeCustom("ilm");
        return builder.settings(newSettings).settingsVersion(newSettingsVersion);
    }
}

