/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import java.util.function.Predicate;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.netty4.Netty4HttpContentSizeHandler;
import org.elasticsearch.http.netty4.internal.HttpHeadersAuthenticatorUtils;

public class Netty4HttpAggregator
extends HttpObjectAggregator {
    private static final Predicate<HttpPreRequest> IGNORE_TEST = req -> !req.uri().startsWith("/_test/request-stream");
    private final Predicate<HttpPreRequest> decider;
    private final Netty4HttpContentSizeHandler streamContentSizeHandler;
    private boolean aggregating = true;

    public Netty4HttpAggregator(int maxContentLength, Predicate<HttpPreRequest> decider, HttpRequestDecoder decoder) {
        super(maxContentLength);
        this.decider = decider;
        this.streamContentSizeHandler = new Netty4HttpContentSizeHandler(decoder, maxContentLength);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (msg instanceof HttpObject);
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            HttpPreRequest preReq = HttpHeadersAuthenticatorUtils.asHttpPreRequest(request);
            boolean bl = this.aggregating = this.decider.test(preReq) && IGNORE_TEST.test(preReq) || request.decoderResult().isFailure();
        }
        if (this.aggregating || msg instanceof FullHttpRequest) {
            super.channelRead(ctx, msg);
        } else {
            this.streamContentSizeHandler.channelRead(ctx, msg);
        }
    }
}

