/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.random.Random1D;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.RandomProcess;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public class Process1D<P extends AbstractProcess<?>> {
    private final Random1D myGenerator;
    private final P[] myProcesses;

    public static <P extends AbstractProcess<?>> Process1D of(Access2D<?> correlations, P ... processes) {
        return new Process1D(new Random1D(correlations), processes);
    }

    public static <P extends AbstractProcess<?>> Process1D of(P ... processes) {
        return new Process1D(new Random1D(processes.length), processes);
    }

    protected Process1D(Access2D<?> correlations, List<? extends P> processes) {
        this(new Random1D(correlations), processes.toArray(new AbstractProcess[processes.size()]));
    }

    protected Process1D(List<? extends P> processes) {
        this(new Random1D(processes.size()), processes.toArray(new AbstractProcess[processes.size()]));
    }

    Process1D(Random1D generator, P ... processes) {
        this.myGenerator = generator;
        this.myProcesses = processes;
    }

    public double getValue(int index) {
        return ((AbstractProcess)this.myProcesses[index]).getValue();
    }

    public Primitive64Array getValues() {
        int tmpLength = this.myProcesses.length;
        Primitive64Array retVal = Primitive64Array.make(tmpLength);
        for (int p = 0; p < tmpLength; ++p) {
            retVal.set((long)p, ((AbstractProcess)this.myProcesses[p]).getValue());
        }
        return retVal;
    }

    public void setValue(int index, double newValue) {
        ((AbstractProcess)this.myProcesses[index]).setValue(newValue);
    }

    public void setValues(Access1D<?> newValues) {
        for (int p = 0; p < this.myProcesses.length; ++p) {
            ((AbstractProcess)this.myProcesses[p]).setValue(newValues.doubleValue(p));
        }
    }

    public int size() {
        return this.myProcesses.length;
    }

    public Array1D<Double> step(double stepSize) {
        Array1D<Double> retVal = this.myGenerator.nextGaussian();
        for (int p = 0; p < this.myProcesses.length; ++p) {
            retVal.set((long)p, ((AbstractProcess)this.myProcesses[p]).step(this.getValue(p), stepSize, retVal.doubleValue(p)));
        }
        return retVal;
    }

    protected P getProcess(int index) {
        return this.myProcesses[index];
    }

    double getExpected(int index, double stepSize) {
        return ((AbstractProcess)this.myProcesses[index]).getExpected(stepSize);
    }

    double getLowerConfidenceQuantile(int index, double stepSize, double confidence) {
        return ((AbstractProcess)this.myProcesses[index]).getLowerConfidenceQuantile(stepSize, confidence);
    }

    double getStandardDeviation(int index, double stepSize) {
        return ((AbstractProcess)this.myProcesses[index]).getStandardDeviation(stepSize);
    }

    double getUpperConfidenceQuantile(int index, double stepSize, double confidence) {
        return ((AbstractProcess)this.myProcesses[index]).getUpperConfidenceQuantile(stepSize, confidence);
    }

    double getVariance(int index, double stepSize) {
        return ((AbstractProcess)this.myProcesses[index]).getVariance(stepSize);
    }

    RandomProcess.SimulationResults simulate(int index, int numberOfRealisations, int numberOfSteps, double stepSize) {
        return ((AbstractProcess)this.myProcesses[index]).simulate(numberOfRealisations, numberOfSteps, stepSize);
    }

    double step(int index, double stepSize) {
        return ((AbstractProcess)this.myProcesses[index]).step(stepSize);
    }
}

