/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.paging.Page;
import com.google.auth.ServiceAccountSigner;
import com.google.cloud.FieldSelector;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.Service;
import com.google.cloud.Tuple;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@InternalExtensionOnly
public interface Storage
extends Service<StorageOptions> {
    public Bucket create(BucketInfo var1, BucketTargetOption ... var2);

    public Blob create(BlobInfo var1, BlobTargetOption ... var2);

    public Blob create(BlobInfo var1, byte[] var2, BlobTargetOption ... var3);

    public Blob create(BlobInfo var1, byte[] var2, int var3, int var4, BlobTargetOption ... var5);

    @Deprecated
    public Blob create(BlobInfo var1, InputStream var2, BlobWriteOption ... var3);

    public Blob createFrom(BlobInfo var1, Path var2, BlobWriteOption ... var3) throws IOException;

    public Blob createFrom(BlobInfo var1, Path var2, int var3, BlobWriteOption ... var4) throws IOException;

    public Blob createFrom(BlobInfo var1, InputStream var2, BlobWriteOption ... var3) throws IOException;

    public Blob createFrom(BlobInfo var1, InputStream var2, int var3, BlobWriteOption ... var4) throws IOException;

    public Bucket get(String var1, BucketGetOption ... var2);

    public Bucket lockRetentionPolicy(BucketInfo var1, BucketTargetOption ... var2);

    public Blob get(String var1, String var2, BlobGetOption ... var3);

    public Blob get(BlobId var1, BlobGetOption ... var2);

    public Blob get(BlobId var1);

    public Page<Bucket> list(BucketListOption ... var1);

    public Page<Blob> list(String var1, BlobListOption ... var2);

    public Bucket update(BucketInfo var1, BucketTargetOption ... var2);

    public Blob update(BlobInfo var1, BlobTargetOption ... var2);

    public Blob update(BlobInfo var1);

    public boolean delete(String var1, BucketSourceOption ... var2);

    public boolean delete(String var1, String var2, BlobSourceOption ... var3);

    public boolean delete(BlobId var1, BlobSourceOption ... var2);

    public boolean delete(BlobId var1);

    public Blob compose(ComposeRequest var1);

    public CopyWriter copy(CopyRequest var1);

    public byte[] readAllBytes(String var1, String var2, BlobSourceOption ... var3);

    public byte[] readAllBytes(BlobId var1, BlobSourceOption ... var2);

    public StorageBatch batch();

    public ReadChannel reader(String var1, String var2, BlobSourceOption ... var3);

    public ReadChannel reader(BlobId var1, BlobSourceOption ... var2);

    public void downloadTo(BlobId var1, Path var2, BlobSourceOption ... var3);

    public void downloadTo(BlobId var1, OutputStream var2, BlobSourceOption ... var3);

    public WriteChannel writer(BlobInfo var1, BlobWriteOption ... var2);

    public WriteChannel writer(URL var1);

    public URL signUrl(BlobInfo var1, long var2, TimeUnit var4, SignUrlOption ... var5);

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostFieldsV4 var5, PostPolicyV4.PostConditionsV4 var6, PostPolicyV4Option ... var7);

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostFieldsV4 var5, PostPolicyV4Option ... var6);

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4.PostConditionsV4 var5, PostPolicyV4Option ... var6);

    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo var1, long var2, TimeUnit var4, PostPolicyV4Option ... var5);

    public List<Blob> get(BlobId ... var1);

    public List<Blob> get(Iterable<BlobId> var1);

    public List<Blob> update(BlobInfo ... var1);

    public List<Blob> update(Iterable<BlobInfo> var1);

    public List<Boolean> delete(BlobId ... var1);

    public List<Boolean> delete(Iterable<BlobId> var1);

    public Acl getAcl(String var1, Acl.Entity var2, BucketSourceOption ... var3);

    public Acl getAcl(String var1, Acl.Entity var2);

    public boolean deleteAcl(String var1, Acl.Entity var2, BucketSourceOption ... var3);

    public boolean deleteAcl(String var1, Acl.Entity var2);

    public Acl createAcl(String var1, Acl var2, BucketSourceOption ... var3);

    public Acl createAcl(String var1, Acl var2);

    public Acl updateAcl(String var1, Acl var2, BucketSourceOption ... var3);

    public Acl updateAcl(String var1, Acl var2);

    public List<Acl> listAcls(String var1, BucketSourceOption ... var2);

    public List<Acl> listAcls(String var1);

    public Acl getDefaultAcl(String var1, Acl.Entity var2);

    public boolean deleteDefaultAcl(String var1, Acl.Entity var2);

    public Acl createDefaultAcl(String var1, Acl var2);

    public Acl updateDefaultAcl(String var1, Acl var2);

    public List<Acl> listDefaultAcls(String var1);

    public Acl getAcl(BlobId var1, Acl.Entity var2);

    public boolean deleteAcl(BlobId var1, Acl.Entity var2);

    public Acl createAcl(BlobId var1, Acl var2);

    public Acl updateAcl(BlobId var1, Acl var2);

    public List<Acl> listAcls(BlobId var1);

    public HmacKey createHmacKey(ServiceAccount var1, CreateHmacKeyOption ... var2);

    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(ListHmacKeysOption ... var1);

    public HmacKey.HmacKeyMetadata getHmacKey(String var1, GetHmacKeyOption ... var2);

    public void deleteHmacKey(HmacKey.HmacKeyMetadata var1, DeleteHmacKeyOption ... var2);

    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata var1, HmacKey.HmacKeyState var2, UpdateHmacKeyOption ... var3);

    public Policy getIamPolicy(String var1, BucketSourceOption ... var2);

    public Policy setIamPolicy(String var1, Policy var2, BucketSourceOption ... var3);

    public List<Boolean> testIamPermissions(String var1, List<String> var2, BucketSourceOption ... var3);

    public ServiceAccount getServiceAccount(String var1);

    public Notification createNotification(String var1, NotificationInfo var2);

    public Notification getNotification(String var1, String var2);

    public List<Notification> listNotifications(String var1);

    public boolean deleteNotification(String var1, String var2);

    public static class CopyRequest
    implements Serializable {
        private static final long serialVersionUID = -4498650529476219937L;
        private final BlobId source;
        private final List<BlobSourceOption> sourceOptions;
        private final boolean overrideInfo;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;
        private final Long megabytesCopiedPerChunk;

        private CopyRequest(Builder builder) {
            this.source = (BlobId)Preconditions.checkNotNull((Object)builder.source);
            this.sourceOptions = ImmutableList.copyOf((Collection)builder.sourceOptions);
            this.overrideInfo = builder.overrideInfo;
            this.target = (BlobInfo)Preconditions.checkNotNull((Object)builder.target);
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        public BlobId getSource() {
            return this.source;
        }

        public List<BlobSourceOption> getSourceOptions() {
            return this.sourceOptions;
        }

        public BlobInfo getTarget() {
            return this.target;
        }

        public boolean overrideInfo() {
            return this.overrideInfo;
        }

        public List<BlobTargetOption> getTargetOptions() {
            return this.targetOptions;
        }

        public Long getMegabytesCopiedPerChunk() {
            return this.megabytesCopiedPerChunk;
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobInfo target) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobInfo target) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, String targetBlob) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(BlobId.of(sourceBucket, targetBlob)).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobId target) {
            return CopyRequest.newBuilder().setSource(sourceBucket, sourceBlob).setTarget(target).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, String targetBlob) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(BlobId.of(sourceBlobId.getBucket(), targetBlob)).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobId targetBlobId) {
            return CopyRequest.newBuilder().setSource(sourceBlobId).setTarget(targetBlobId).build();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final Set<BlobSourceOption> sourceOptions = new LinkedHashSet<BlobSourceOption>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobId source;
            private boolean overrideInfo;
            private BlobInfo target;
            private Long megabytesCopiedPerChunk;

            public Builder setSource(String bucket, String blob) {
                this.source = BlobId.of(bucket, blob);
                return this;
            }

            public Builder setSource(BlobId source) {
                this.source = source;
                return this;
            }

            public Builder setSourceOptions(BlobSourceOption ... options) {
                Collections.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder setSourceOptions(Iterable<BlobSourceOption> options) {
                Iterables.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder setTarget(BlobId targetId) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                return this;
            }

            public Builder setTarget(BlobId targetId, BlobTargetOption ... options) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobInfo target, BlobTargetOption ... options) {
                this.overrideInfo = true;
                this.target = (BlobInfo)Preconditions.checkNotNull((Object)target);
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobInfo target, Iterable<BlobTargetOption> options) {
                this.overrideInfo = true;
                this.target = (BlobInfo)Preconditions.checkNotNull((Object)target);
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTarget(BlobId targetId, Iterable<BlobTargetOption> options) {
                this.overrideInfo = false;
                this.target = BlobInfo.newBuilder(targetId).build();
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setMegabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            public CopyRequest build() {
                return new CopyRequest(this);
            }
        }
    }

    public static class ComposeRequest
    implements Serializable {
        private static final long serialVersionUID = -7385681353748590911L;
        private final List<SourceBlob> sourceBlobs;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;

        private ComposeRequest(Builder builder) {
            this.sourceBlobs = ImmutableList.copyOf((Collection)builder.sourceBlobs);
            this.target = builder.target;
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
        }

        public List<SourceBlob> getSourceBlobs() {
            return this.sourceBlobs;
        }

        public BlobInfo getTarget() {
            return this.target;
        }

        public List<BlobTargetOption> getTargetOptions() {
            return this.targetOptions;
        }

        public static ComposeRequest of(Iterable<String> sources, BlobInfo target) {
            return ComposeRequest.newBuilder().setTarget(target).addSource(sources).build();
        }

        public static ComposeRequest of(String bucket, Iterable<String> sources, String target) {
            return ComposeRequest.of(sources, BlobInfo.newBuilder(BlobId.of(bucket, target)).build());
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final List<SourceBlob> sourceBlobs = new LinkedList<SourceBlob>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobInfo target;

            public Builder addSource(Iterable<String> blobs) {
                for (String blob : blobs) {
                    this.sourceBlobs.add(new SourceBlob(blob));
                }
                return this;
            }

            public Builder addSource(String ... blobs) {
                return this.addSource(Arrays.asList(blobs));
            }

            public Builder addSource(String blob, long generation) {
                this.sourceBlobs.add(new SourceBlob(blob, generation));
                return this;
            }

            public Builder setTarget(BlobInfo target) {
                this.target = target;
                return this;
            }

            public Builder setTargetOptions(BlobTargetOption ... options) {
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder setTargetOptions(Iterable<BlobTargetOption> options) {
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public ComposeRequest build() {
                Preconditions.checkArgument((!this.sourceBlobs.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)this.target);
                return new ComposeRequest(this);
            }
        }

        public static class SourceBlob
        implements Serializable {
            private static final long serialVersionUID = 4094962795951990439L;
            final String name;
            final Long generation;

            SourceBlob(String name) {
                this(name, null);
            }

            SourceBlob(String name, Long generation) {
                this.name = name;
                this.generation = generation;
            }

            public String getName() {
                return this.name;
            }

            public Long getGeneration() {
                return this.generation;
            }
        }
    }

    public static class SignUrlOption
    implements Serializable {
        private static final long serialVersionUID = 7850569877451099267L;
        private final Option option;
        private final Object value;

        private SignUrlOption(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        Option getOption() {
            return this.option;
        }

        Object getValue() {
            return this.value;
        }

        public static SignUrlOption httpMethod(HttpMethod httpMethod) {
            return new SignUrlOption(Option.HTTP_METHOD, (Object)httpMethod);
        }

        public static SignUrlOption withContentType() {
            return new SignUrlOption(Option.CONTENT_TYPE, true);
        }

        public static SignUrlOption withMd5() {
            return new SignUrlOption(Option.MD5, true);
        }

        public static SignUrlOption withExtHeaders(Map<String, String> extHeaders) {
            return new SignUrlOption(Option.EXT_HEADERS, extHeaders);
        }

        public static SignUrlOption withV2Signature() {
            return new SignUrlOption(Option.SIGNATURE_VERSION, (Object)SignatureVersion.V2);
        }

        public static SignUrlOption withV4Signature() {
            return new SignUrlOption(Option.SIGNATURE_VERSION, (Object)SignatureVersion.V4);
        }

        public static SignUrlOption signWith(ServiceAccountSigner signer) {
            return new SignUrlOption(Option.SERVICE_ACCOUNT_CRED, signer);
        }

        public static SignUrlOption withHostName(String hostName) {
            return new SignUrlOption(Option.HOST_NAME, hostName);
        }

        public static SignUrlOption withVirtualHostedStyle() {
            return new SignUrlOption(Option.VIRTUAL_HOSTED_STYLE, "");
        }

        public static SignUrlOption withPathStyle() {
            return new SignUrlOption(Option.PATH_STYLE, "");
        }

        public static SignUrlOption withBucketBoundHostname(String bucketBoundHostname) {
            return SignUrlOption.withBucketBoundHostname(bucketBoundHostname, UriScheme.HTTP);
        }

        public static SignUrlOption withBucketBoundHostname(String bucketBoundHostname, UriScheme uriScheme) {
            return new SignUrlOption(Option.BUCKET_BOUND_HOST_NAME, uriScheme.getScheme() + "://" + bucketBoundHostname);
        }

        public static SignUrlOption withQueryParams(Map<String, String> queryParams) {
            return new SignUrlOption(Option.QUERY_PARAMS, queryParams);
        }

        static enum SignatureVersion {
            V2,
            V4;

        }

        static enum Option {
            HTTP_METHOD,
            CONTENT_TYPE,
            MD5,
            EXT_HEADERS,
            SERVICE_ACCOUNT_CRED,
            SIGNATURE_VERSION,
            HOST_NAME,
            PATH_STYLE,
            VIRTUAL_HOSTED_STYLE,
            BUCKET_BOUND_HOST_NAME,
            QUERY_PARAMS;

        }
    }

    public static class PostPolicyV4Option
    implements Serializable {
        private static final long serialVersionUID = 8150867146534084543L;
        private final Option option;
        private final Object value;

        private PostPolicyV4Option(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        Option getOption() {
            return this.option;
        }

        Object getValue() {
            return this.value;
        }

        public static PostPolicyV4Option signWith(ServiceAccountSigner signer) {
            return new PostPolicyV4Option(Option.SERVICE_ACCOUNT_CRED, signer);
        }

        public static PostPolicyV4Option withVirtualHostedStyle() {
            return new PostPolicyV4Option(Option.VIRTUAL_HOSTED_STYLE, "");
        }

        public static PostPolicyV4Option withPathStyle() {
            return new PostPolicyV4Option(Option.PATH_STYLE, "");
        }

        public static PostPolicyV4Option withBucketBoundHostname(String bucketBoundHostname) {
            return PostPolicyV4Option.withBucketBoundHostname(bucketBoundHostname, UriScheme.HTTP);
        }

        public static PostPolicyV4Option withBucketBoundHostname(String bucketBoundHostname, UriScheme uriScheme) {
            return new PostPolicyV4Option(Option.BUCKET_BOUND_HOST_NAME, uriScheme.getScheme() + "://" + bucketBoundHostname);
        }

        static enum Option {
            PATH_STYLE,
            VIRTUAL_HOSTED_STYLE,
            BUCKET_BOUND_HOST_NAME,
            SERVICE_ACCOUNT_CRED;

        }
    }

    public static class BlobListOption
    extends Option {
        private static final String[] TOP_LEVEL_FIELDS = new String[]{"prefixes"};
        private static final long serialVersionUID = 9083383524788661294L;

        private BlobListOption(StorageRpc.Option option, Object value) {
            super(option, value);
        }

        public static BlobListOption pageSize(long pageSize) {
            return new BlobListOption(StorageRpc.Option.MAX_RESULTS, pageSize);
        }

        public static BlobListOption pageToken(String pageToken) {
            return new BlobListOption(StorageRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static BlobListOption prefix(String prefix) {
            return new BlobListOption(StorageRpc.Option.PREFIX, prefix);
        }

        public static BlobListOption currentDirectory() {
            return new BlobListOption(StorageRpc.Option.DELIMITER, true);
        }

        public static BlobListOption delimiter(String delimiter) {
            return new BlobListOption(StorageRpc.Option.DELIMITER, delimiter);
        }

        public static BlobListOption startOffset(String startOffset) {
            return new BlobListOption(StorageRpc.Option.START_OFF_SET, startOffset);
        }

        public static BlobListOption endOffset(String endOffset) {
            return new BlobListOption(StorageRpc.Option.END_OFF_SET, endOffset);
        }

        public static BlobListOption userProject(String userProject) {
            return new BlobListOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BlobListOption versions(boolean versions) {
            return new BlobListOption(StorageRpc.Option.VERSIONS, versions);
        }

        public static BlobListOption fields(BlobField ... fields) {
            return new BlobListOption(StorageRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String[])TOP_LEVEL_FIELDS, (String)"items", BlobField.REQUIRED_FIELDS, (FieldSelector[])fields, (String[])new String[0]));
        }
    }

    public static class BucketListOption
    extends Option {
        private static final long serialVersionUID = 8754017079673290353L;

        private BucketListOption(StorageRpc.Option option, Object value) {
            super(option, value);
        }

        public static BucketListOption pageSize(long pageSize) {
            return new BucketListOption(StorageRpc.Option.MAX_RESULTS, pageSize);
        }

        public static BucketListOption pageToken(String pageToken) {
            return new BucketListOption(StorageRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static BucketListOption prefix(String prefix) {
            return new BucketListOption(StorageRpc.Option.PREFIX, prefix);
        }

        public static BucketListOption userProject(String userProject) {
            return new BucketListOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BucketListOption fields(BucketField ... fields) {
            return new BucketListOption(StorageRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"items", BucketField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class BlobGetOption
    extends Option {
        private static final long serialVersionUID = 803817709703661480L;

        private BlobGetOption(StorageRpc.Option rpcOption, Long value) {
            super(rpcOption, value);
        }

        private BlobGetOption(StorageRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        private BlobGetOption(StorageRpc.Option rpcOption, boolean value) {
            super(rpcOption, value);
        }

        public static BlobGetOption generationMatch() {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_MATCH, (Long)null);
        }

        public static BlobGetOption generationMatch(long generation) {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobGetOption generationNotMatch() {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, (Long)null);
        }

        public static BlobGetOption generationNotMatch(long generation) {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobGetOption metagenerationMatch(long metageneration) {
            return new BlobGetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobGetOption metagenerationNotMatch(long metageneration) {
            return new BlobGetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobGetOption fields(BlobField ... fields) {
            return new BlobGetOption(StorageRpc.Option.FIELDS, FieldSelector.Helper.selector(BlobField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }

        public static BlobGetOption userProject(String userProject) {
            return new BlobGetOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BlobGetOption decryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobGetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobGetOption decryptionKey(String key) {
            return new BlobGetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobGetOption shouldReturnRawInputStream(boolean shouldReturnRawInputStream) {
            return new BlobGetOption(StorageRpc.Option.RETURN_RAW_INPUT_STREAM, shouldReturnRawInputStream);
        }
    }

    public static class BlobSourceOption
    extends Option {
        private static final long serialVersionUID = -3712768261070182991L;

        private BlobSourceOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH, null);
        }

        public static BlobSourceOption generationMatch(long generation) {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, null);
        }

        public static BlobSourceOption generationNotMatch(long generation) {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobSourceOption metagenerationMatch(long metageneration) {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobSourceOption metagenerationNotMatch(long metageneration) {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobSourceOption decryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobSourceOption decryptionKey(String key) {
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobSourceOption userProject(String userProject) {
            return new BlobSourceOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BlobSourceOption shouldReturnRawInputStream(boolean shouldReturnRawInputStream) {
            return new BlobSourceOption(StorageRpc.Option.RETURN_RAW_INPUT_STREAM, shouldReturnRawInputStream);
        }
    }

    public static class BlobWriteOption
    implements Serializable {
        private static final long serialVersionUID = -3880421670966224580L;
        private final Option option;
        private final Object value;

        BlobTargetOption toTargetOption() {
            return new BlobTargetOption(this.option.toRpcOption(), this.value);
        }

        private BlobWriteOption(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        private BlobWriteOption(Option option) {
            this(option, null);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.option, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BlobWriteOption)) {
                return false;
            }
            BlobWriteOption other = (BlobWriteOption)obj;
            return this.option == other.option && Objects.equals(this.value, other.value);
        }

        public static BlobWriteOption predefinedAcl(PredefinedAcl acl) {
            return new BlobWriteOption(Option.PREDEFINED_ACL, acl.getEntry());
        }

        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobWriteOption generationMatch() {
            return new BlobWriteOption(Option.IF_GENERATION_MATCH);
        }

        public static BlobWriteOption generationNotMatch() {
            return new BlobWriteOption(Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobWriteOption metagenerationMatch() {
            return new BlobWriteOption(Option.IF_METAGENERATION_MATCH);
        }

        public static BlobWriteOption metagenerationNotMatch() {
            return new BlobWriteOption(Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BlobWriteOption md5Match() {
            return new BlobWriteOption(Option.IF_MD5_MATCH, true);
        }

        public static BlobWriteOption crc32cMatch() {
            return new BlobWriteOption(Option.IF_CRC32C_MATCH, true);
        }

        public static BlobWriteOption encryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobWriteOption(Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobWriteOption encryptionKey(String key) {
            return new BlobWriteOption(Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobWriteOption kmsKeyName(String kmsKeyName) {
            return new BlobWriteOption(Option.KMS_KEY_NAME, kmsKeyName);
        }

        public static BlobWriteOption userProject(String userProject) {
            return new BlobWriteOption(Option.USER_PROJECT, userProject);
        }

        public static BlobWriteOption disableGzipContent() {
            return new BlobWriteOption(Option.IF_DISABLE_GZIP_CONTENT, true);
        }

        public static BlobWriteOption detectContentType() {
            return new BlobWriteOption(Option.DETECT_CONTENT_TYPE, true);
        }

        static enum Option {
            PREDEFINED_ACL,
            IF_GENERATION_MATCH,
            IF_GENERATION_NOT_MATCH,
            IF_METAGENERATION_MATCH,
            IF_METAGENERATION_NOT_MATCH,
            IF_MD5_MATCH,
            IF_CRC32C_MATCH,
            CUSTOMER_SUPPLIED_KEY,
            KMS_KEY_NAME,
            USER_PROJECT,
            DETECT_CONTENT_TYPE,
            IF_DISABLE_GZIP_CONTENT;


            StorageRpc.Option toRpcOption() {
                return StorageRpc.Option.valueOf(this.name());
            }
        }
    }

    public static class BlobTargetOption
    extends Option {
        private static final long serialVersionUID = 214616862061934846L;

        private BlobTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private BlobTargetOption(StorageRpc.Option rpcOption) {
            this(rpcOption, null);
        }

        public static BlobTargetOption predefinedAcl(PredefinedAcl acl) {
            return new BlobTargetOption(StorageRpc.Option.PREDEFINED_ACL, acl.getEntry());
        }

        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobTargetOption generationMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH);
        }

        public static BlobTargetOption generationNotMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobTargetOption metagenerationMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BlobTargetOption metagenerationNotMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BlobTargetOption disableGzipContent() {
            return new BlobTargetOption(StorageRpc.Option.IF_DISABLE_GZIP_CONTENT, true);
        }

        public static BlobTargetOption detectContentType() {
            return new BlobTargetOption(StorageRpc.Option.DETECT_CONTENT_TYPE, true);
        }

        public static BlobTargetOption encryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobTargetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobTargetOption userProject(String userProject) {
            return new BlobTargetOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BlobTargetOption encryptionKey(String key) {
            return new BlobTargetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobTargetOption kmsKeyName(String kmsKeyName) {
            return new BlobTargetOption(StorageRpc.Option.KMS_KEY_NAME, kmsKeyName);
        }

        static Tuple<BlobInfo, BlobTargetOption[]> convert(BlobInfo info, BlobWriteOption ... options) {
            BlobInfo.Builder infoBuilder = info.toBuilder().setCrc32c(null).setMd5(null);
            ArrayList targetOptions = Lists.newArrayListWithCapacity((int)options.length);
            block4: for (BlobWriteOption option : options) {
                switch (option.option) {
                    case IF_CRC32C_MATCH: {
                        infoBuilder.setCrc32c(info.getCrc32c());
                        continue block4;
                    }
                    case IF_MD5_MATCH: {
                        infoBuilder.setMd5(info.getMd5());
                        continue block4;
                    }
                    default: {
                        targetOptions.add(option.toTargetOption());
                    }
                }
            }
            return Tuple.of((Object)infoBuilder.build(), (Object)targetOptions.toArray(new BlobTargetOption[targetOptions.size()]));
        }
    }

    public static class BucketGetOption
    extends Option {
        private static final long serialVersionUID = 1901844869484087395L;

        private BucketGetOption(StorageRpc.Option rpcOption, long metageneration) {
            super(rpcOption, metageneration);
        }

        private BucketGetOption(StorageRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        public static BucketGetOption metagenerationMatch(long metageneration) {
            return new BucketGetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BucketGetOption metagenerationNotMatch(long metageneration) {
            return new BucketGetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BucketGetOption userProject(String userProject) {
            return new BucketGetOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BucketGetOption fields(BucketField ... fields) {
            return new BucketGetOption(StorageRpc.Option.FIELDS, FieldSelector.Helper.selector(BucketField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class UpdateHmacKeyOption
    extends Option {
        private UpdateHmacKeyOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static UpdateHmacKeyOption userProject(String userProject) {
            return new UpdateHmacKeyOption(StorageRpc.Option.USER_PROJECT, userProject);
        }
    }

    public static class DeleteHmacKeyOption
    extends Option {
        private DeleteHmacKeyOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static DeleteHmacKeyOption userProject(String userProject) {
            return new DeleteHmacKeyOption(StorageRpc.Option.USER_PROJECT, userProject);
        }
    }

    public static class GetHmacKeyOption
    extends Option {
        private GetHmacKeyOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static GetHmacKeyOption userProject(String userProject) {
            return new GetHmacKeyOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static GetHmacKeyOption projectId(String projectId) {
            return new GetHmacKeyOption(StorageRpc.Option.PROJECT_ID, projectId);
        }
    }

    public static class CreateHmacKeyOption
    extends Option {
        private CreateHmacKeyOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static CreateHmacKeyOption userProject(String userProject) {
            return new CreateHmacKeyOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static CreateHmacKeyOption projectId(String projectId) {
            return new CreateHmacKeyOption(StorageRpc.Option.PROJECT_ID, projectId);
        }
    }

    public static class ListHmacKeysOption
    extends Option {
        private ListHmacKeysOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static ListHmacKeysOption serviceAccount(ServiceAccount serviceAccount) {
            return new ListHmacKeysOption(StorageRpc.Option.SERVICE_ACCOUNT_EMAIL, serviceAccount.getEmail());
        }

        public static ListHmacKeysOption maxResults(long pageSize) {
            return new ListHmacKeysOption(StorageRpc.Option.MAX_RESULTS, pageSize);
        }

        public static ListHmacKeysOption pageToken(String pageToken) {
            return new ListHmacKeysOption(StorageRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ListHmacKeysOption showDeletedKeys(boolean showDeletedKeys) {
            return new ListHmacKeysOption(StorageRpc.Option.SHOW_DELETED_KEYS, showDeletedKeys);
        }

        public static ListHmacKeysOption userProject(String userProject) {
            return new ListHmacKeysOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static ListHmacKeysOption projectId(String projectId) {
            return new ListHmacKeysOption(StorageRpc.Option.PROJECT_ID, projectId);
        }
    }

    public static class BucketSourceOption
    extends Option {
        private static final long serialVersionUID = 5185657617120212117L;

        private BucketSourceOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        public static BucketSourceOption metagenerationMatch(long metageneration) {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BucketSourceOption metagenerationNotMatch(long metageneration) {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BucketSourceOption userProject(String userProject) {
            return new BucketSourceOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BucketSourceOption requestedPolicyVersion(long version) {
            return new BucketSourceOption(StorageRpc.Option.REQUESTED_POLICY_VERSION, version);
        }
    }

    public static class BucketTargetOption
    extends Option {
        private static final long serialVersionUID = -5880204616982900975L;

        private BucketTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private BucketTargetOption(StorageRpc.Option rpcOption) {
            this(rpcOption, null);
        }

        public static BucketTargetOption predefinedAcl(PredefinedAcl acl) {
            return new BucketTargetOption(StorageRpc.Option.PREDEFINED_ACL, acl.getEntry());
        }

        public static BucketTargetOption predefinedDefaultObjectAcl(PredefinedAcl acl) {
            return new BucketTargetOption(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL, acl.getEntry());
        }

        public static BucketTargetOption metagenerationMatch() {
            return new BucketTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BucketTargetOption metagenerationNotMatch() {
            return new BucketTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BucketTargetOption userProject(String userProject) {
            return new BucketTargetOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        public static BucketTargetOption projection(String projection) {
            return new BucketTargetOption(StorageRpc.Option.PROJECTION, projection);
        }
    }

    public static enum UriScheme {
        HTTP("http"),
        HTTPS("https");

        private final String scheme;

        private UriScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static enum BlobField implements FieldSelector
    {
        ACL("acl"),
        BUCKET("bucket"),
        CACHE_CONTROL("cacheControl"),
        COMPONENT_COUNT("componentCount"),
        CONTENT_DISPOSITION("contentDisposition"),
        CONTENT_ENCODING("contentEncoding"),
        CONTENT_LANGUAGE("contentLanguage"),
        CONTENT_TYPE("contentType"),
        CRC32C("crc32c"),
        ETAG("etag"),
        GENERATION("generation"),
        ID("id"),
        KIND("kind"),
        MD5HASH("md5Hash"),
        MEDIA_LINK("mediaLink"),
        METADATA("metadata"),
        METAGENERATION("metageneration"),
        NAME("name"),
        OWNER("owner"),
        SELF_LINK("selfLink"),
        SIZE("size"),
        STORAGE_CLASS("storageClass"),
        TIME_DELETED("timeDeleted"),
        TIME_CREATED("timeCreated"),
        KMS_KEY_NAME("kmsKeyName"),
        EVENT_BASED_HOLD("eventBasedHold"),
        TEMPORARY_HOLD("temporaryHold"),
        RETENTION_EXPIRATION_TIME("retentionExpirationTime"),
        UPDATED("updated"),
        CUSTOM_TIME("customTime"),
        TIME_STORAGE_CLASS_UPDATED("timeStorageClassUpdated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private BlobField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)BUCKET), (Object)((Object)NAME));
        }
    }

    public static enum BucketField implements FieldSelector
    {
        ID("id"),
        SELF_LINK("selfLink"),
        NAME("name"),
        TIME_CREATED("timeCreated"),
        METAGENERATION("metageneration"),
        ACL("acl"),
        DEFAULT_OBJECT_ACL("defaultObjectAcl"),
        OWNER("owner"),
        LABELS("labels"),
        LOCATION("location"),
        LOCATION_TYPE("locationType"),
        WEBSITE("website"),
        VERSIONING("versioning"),
        CORS("cors"),
        LIFECYCLE("lifecycle"),
        STORAGE_CLASS("storageClass"),
        ETAG("etag"),
        ENCRYPTION("encryption"),
        BILLING("billing"),
        DEFAULT_EVENT_BASED_HOLD("defaultEventBasedHold"),
        RETENTION_POLICY("retentionPolicy"),
        IAMCONFIGURATION("iamConfiguration"),
        LOGGING("logging"),
        UPDATED("updated");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private BucketField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)NAME));
        }
    }

    public static enum PredefinedAcl {
        AUTHENTICATED_READ("authenticatedRead"),
        ALL_AUTHENTICATED_USERS("allAuthenticatedUsers"),
        PRIVATE("private"),
        PROJECT_PRIVATE("projectPrivate"),
        PUBLIC_READ("publicRead"),
        PUBLIC_READ_WRITE("publicReadWrite"),
        BUCKET_OWNER_READ("bucketOwnerRead"),
        BUCKET_OWNER_FULL_CONTROL("bucketOwnerFullControl");

        private final String entry;

        private PredefinedAcl(String entry) {
            this.entry = entry;
        }

        String getEntry() {
            return this.entry;
        }
    }
}

