/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.email.Account;
import org.elasticsearch.xpack.watcher.notification.email.Authentication;
import org.elasticsearch.xpack.watcher.notification.email.Email;
import org.elasticsearch.xpack.watcher.notification.email.Profile;

public class EmailService
extends NotificationService<Account> {
    private static final Setting<String> SETTING_DEFAULT_ACCOUNT = Setting.simpleString((String)"xpack.notification.email.default_account", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<String> SETTING_PROFILE = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"profile", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final List<String> ALLOW_ALL_DEFAULT = List.of("*");
    private static final Setting<List<String>> SETTING_DOMAIN_ALLOWLIST = Setting.stringListSetting((String)"xpack.notification.email.account.domain_allowlist", ALLOW_ALL_DEFAULT, (Setting.Validator)new Setting.Validator<List<String>>(){

        public void validate(List<String> value) {
        }

        public void validate(List<String> value, Map<Setting<?>, Object> settings) {
            List recipientAllowPatterns = (List)settings.get(SETTING_RECIPIENT_ALLOW_PATTERNS);
            if (!value.equals(ALLOW_ALL_DEFAULT) && !recipientAllowPatterns.equals(ALLOW_ALL_DEFAULT)) {
                throw new IllegalArgumentException("Cannot set both [" + SETTING_RECIPIENT_ALLOW_PATTERNS.getKey() + "] and [" + SETTING_DOMAIN_ALLOWLIST.getKey() + "] to a non [\"*\"] value at the same time.");
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting<List<String>>> settingRecipientAllowPatterns = List.of(SETTING_RECIPIENT_ALLOW_PATTERNS);
            return settingRecipientAllowPatterns.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting<List<String>> SETTING_RECIPIENT_ALLOW_PATTERNS = Setting.stringListSetting((String)"xpack.notification.email.recipient_allowlist", ALLOW_ALL_DEFAULT, (Setting.Validator)new Setting.Validator<List<String>>(){

        public void validate(List<String> value) {
        }

        public void validate(List<String> value, Map<Setting<?>, Object> settings) {
            List domainAllowList = (List)settings.get(SETTING_DOMAIN_ALLOWLIST);
            if (!value.equals(ALLOW_ALL_DEFAULT) && !domainAllowList.equals(ALLOW_ALL_DEFAULT)) {
                throw new IllegalArgumentException("Connect set both [" + SETTING_RECIPIENT_ALLOW_PATTERNS.getKey() + "] and [" + SETTING_DOMAIN_ALLOWLIST.getKey() + "] to a non [\"*\"] value at the same time.");
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting<List<String>>> settingDomainAllowlist = List.of(SETTING_DOMAIN_ALLOWLIST);
            return settingDomainAllowlist.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<Settings> SETTING_EMAIL_DEFAULTS = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"email_defaults", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Boolean> SETTING_SMTP_AUTH = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.auth", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Boolean> SETTING_SMTP_STARTTLS_ENABLE = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.starttls.enable", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Boolean> SETTING_SMTP_STARTTLS_REQUIRED = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.starttls.required", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<String> SETTING_SMTP_HOST = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Integer> SETTING_SMTP_PORT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.port", key -> Setting.intSetting((String)key, (int)587, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<String> SETTING_SMTP_USER = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.user", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<SecureString> SETTING_SECURE_PASSWORD = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.secure_password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<TimeValue> SETTING_SMTP_TIMEOUT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)2L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<TimeValue> SETTING_SMTP_CONNECTION_TIMEOUT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.connection_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)2L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<TimeValue> SETTING_SMTP_WRITE_TIMEOUT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.write_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)2L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<String> SETTING_SMTP_LOCAL_ADDRESS = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.local_address", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<String> SETTING_SMTP_SSL_TRUST_ADDRESS = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.ssl.trust", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Integer> SETTING_SMTP_LOCAL_PORT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.local_port", key -> Setting.intSetting((String)key, (int)25, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Boolean> SETTING_SMTP_SEND_PARTIAL = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.send_partial", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final Setting.AffixSetting<Boolean> SETTING_SMTP_WAIT_ON_QUIT = Setting.affixKeySetting((String)"xpack.notification.email.account.", (String)"smtp.wait_on_quit", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final SSLConfigurationSettings SSL_SETTINGS = SSLConfigurationSettings.withPrefix((String)"xpack.notification.email.ssl.", (boolean)true);
    private static final Logger logger = LogManager.getLogger(EmailService.class);
    private final CryptoService cryptoService;
    private final SSLService sslService;
    private volatile Set<String> allowedDomains;
    private volatile Set<String> allowedRecipientPatterns;

    public EmailService(Settings settings, @Nullable CryptoService cryptoService, SSLService sslService, ClusterSettings clusterSettings) {
        super("email", settings, clusterSettings, EmailService.getDynamicSettings(), EmailService.getSecureSettings());
        this.cryptoService = cryptoService;
        this.sslService = sslService;
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_ACCOUNT, s -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_PROFILE, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_EMAIL_DEFAULTS, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_AUTH, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_STARTTLS_ENABLE, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_STARTTLS_REQUIRED, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_HOST, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_PORT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_USER, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_TIMEOUT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_CONNECTION_TIMEOUT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_WRITE_TIMEOUT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_SSL_TRUST_ADDRESS, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_LOCAL_ADDRESS, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_LOCAL_PORT, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_SEND_PARTIAL, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_SMTP_WAIT_ON_QUIT, (s, o) -> {}, (s, o) -> {});
        this.allowedDomains = new HashSet<String>((Collection)SETTING_DOMAIN_ALLOWLIST.get(settings));
        this.allowedRecipientPatterns = new HashSet<String>((Collection)SETTING_RECIPIENT_ALLOW_PATTERNS.get(settings));
        clusterSettings.addSettingsUpdateConsumer(SETTING_DOMAIN_ALLOWLIST, this::updateAllowedDomains);
        clusterSettings.addSettingsUpdateConsumer(SETTING_RECIPIENT_ALLOW_PATTERNS, this::updateAllowedRecipientPatterns);
        this.reload(settings);
    }

    void updateAllowedDomains(List<String> newDomains) {
        this.allowedDomains = new HashSet<String>(newDomains);
    }

    void updateAllowedRecipientPatterns(List<String> newPatterns) {
        this.allowedRecipientPatterns = new HashSet<String>(newPatterns);
    }

    @Override
    protected Account createAccount(String name, Settings accountSettings) {
        Account.Config config = new Account.Config(name, accountSettings, this.getSmtpSslSocketFactory(), logger);
        return new Account(config, this.cryptoService, logger);
    }

    @Nullable
    private SSLSocketFactory getSmtpSslSocketFactory() {
        SslConfiguration sslConfiguration = this.sslService.getSSLConfiguration("xpack.notification.email.ssl.");
        if (sslConfiguration == null || !sslConfiguration.explicitlyConfigured()) {
            return null;
        }
        return this.sslService.sslSocketFactory(sslConfiguration);
    }

    public EmailSent send(Email email, Authentication auth, Profile profile, String accountName) throws MessagingException {
        Account account = (Account)this.getAccount(accountName);
        if (account == null) {
            throw new IllegalArgumentException("failed to send email with subject [" + email.subject() + "] via account [" + accountName + "]. account does not exist");
        }
        if (!EmailService.recipientDomainsInAllowList(email, this.allowedDomains)) {
            throw new IllegalArgumentException("failed to send email with subject [" + email.subject() + "] and recipient domains " + EmailService.getRecipients(email, true) + ", one or more recipients is not specified in the domain allow list setting [" + SETTING_DOMAIN_ALLOWLIST.getKey() + "].");
        }
        if (!EmailService.recipientAddressInAllowList(email, this.allowedRecipientPatterns)) {
            throw new IllegalArgumentException("failed to send email with subject [" + email.subject() + "] and recipients " + EmailService.getRecipients(email, false) + ", one or more recipients is not specified in the domain allow list setting [" + SETTING_RECIPIENT_ALLOW_PATTERNS.getKey() + "].");
        }
        return EmailService.send(email, auth, profile, account);
    }

    static Set<String> getRecipients(Email email, boolean domainsOnly) {
        Stream<String> stream = Stream.concat(Optional.ofNullable(email.to()).map(addrs -> Arrays.stream(addrs.toArray())).orElse(Stream.empty()), Stream.concat(Optional.ofNullable(email.cc()).map(addrs -> Arrays.stream(addrs.toArray())).orElse(Stream.empty()), Optional.ofNullable(email.bcc()).map(addrs -> Arrays.stream(addrs.toArray())).orElse(Stream.empty()))).map(InternetAddress::getAddress);
        if (domainsOnly) {
            stream = stream.map(emailAddress -> emailAddress.substring(emailAddress.lastIndexOf(64) + 1));
        }
        return stream.collect(Collectors.toSet());
    }

    static boolean recipientDomainsInAllowList(Email email, Set<String> allowedDomainSet) {
        if (allowedDomainSet.isEmpty()) {
            return false;
        }
        if (allowedDomainSet.contains("*")) {
            return true;
        }
        Set<String> domains = EmailService.getRecipients(email, true);
        Predicate<String> matchesAnyAllowedDomain = domain -> allowedDomainSet.stream().anyMatch(allowedDomain -> Regex.simpleMatch((String)allowedDomain, (String)domain, (boolean)true));
        return domains.stream().allMatch(matchesAnyAllowedDomain);
    }

    static boolean recipientAddressInAllowList(Email email, Set<String> allowedRecipientPatterns) {
        if (allowedRecipientPatterns.isEmpty()) {
            return false;
        }
        if (allowedRecipientPatterns.contains("*")) {
            return true;
        }
        Set<String> recipients = EmailService.getRecipients(email, false);
        Predicate<String> matchesAnyAllowedRecipient = recipient -> allowedRecipientPatterns.stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)recipient, (boolean)true));
        return recipients.stream().allMatch(matchesAnyAllowedRecipient);
    }

    private static EmailSent send(Email email, Authentication auth, Profile profile, Account account) throws MessagingException {
        assert (account != null);
        try {
            email = account.send(email, auth, profile);
        }
        catch (MessagingException me) {
            throw new MessagingException("failed to send email with subject [" + email.subject() + "] via account [" + account.name() + "]", (Exception)((Object)me));
        }
        return new EmailSent(account.name(), email);
    }

    private static List<Setting<?>> getDynamicSettings() {
        return Arrays.asList(SETTING_DEFAULT_ACCOUNT, SETTING_DOMAIN_ALLOWLIST, SETTING_RECIPIENT_ALLOW_PATTERNS, SETTING_PROFILE, SETTING_EMAIL_DEFAULTS, SETTING_SMTP_AUTH, SETTING_SMTP_HOST, SETTING_SMTP_PORT, SETTING_SMTP_STARTTLS_ENABLE, SETTING_SMTP_USER, SETTING_SMTP_STARTTLS_REQUIRED, SETTING_SMTP_TIMEOUT, SETTING_SMTP_CONNECTION_TIMEOUT, SETTING_SMTP_WRITE_TIMEOUT, SETTING_SMTP_LOCAL_ADDRESS, SETTING_SMTP_LOCAL_PORT, SETTING_SMTP_SEND_PARTIAL, SETTING_SMTP_WAIT_ON_QUIT, SETTING_SMTP_SSL_TRUST_ADDRESS);
    }

    private static List<Setting<?>> getSecureSettings() {
        return Arrays.asList(SETTING_SECURE_PASSWORD);
    }

    public static List<Setting<?>> getSettings() {
        ArrayList allSettings = new ArrayList(EmailService.getDynamicSettings());
        allSettings.addAll(EmailService.getSecureSettings());
        allSettings.addAll(SSL_SETTINGS.getEnabledSettings());
        return allSettings;
    }

    public static class EmailSent {
        private final String account;
        private final Email email;

        public EmailSent(String account, Email email) {
            this.account = account;
            this.email = email;
        }

        public String account() {
            return this.account;
        }

        public Email email() {
            return this.email;
        }
    }
}

