/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.sql.action.SqlClearCursorAction;
import org.elasticsearch.xpack.sql.action.SqlClearCursorRequest;
import org.elasticsearch.xpack.sql.action.SqlClearCursorResponse;
import org.elasticsearch.xpack.sql.proto.Mode;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSqlClearCursorAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_sql/close").replaces(RestRequest.Method.POST, "/_xpack/sql/close", RestApiVersion.V_7).build());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        SqlClearCursorRequest sqlRequest;
        try (XContentParser parser = request.contentParser();){
            sqlRequest = SqlClearCursorRequest.fromXContent((XContentParser)parser);
        }
        return channel -> client.executeLocally((ActionType)SqlClearCursorAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new RestResponseListener<SqlClearCursorResponse>(channel){

            public RestResponse buildResponse(SqlClearCursorResponse response) throws Exception {
                Boolean binaryRequest = sqlRequest.binaryCommunication();
                XContentType type = Boolean.TRUE.equals(binaryRequest) || binaryRequest == null && Mode.isDriver((Mode)sqlRequest.mode()) ? XContentType.CBOR : XContentType.JSON;
                XContentBuilder builder = this.channel.newBuilder(request.getXContentType(), type, false);
                response.toXContent(builder, (ToXContent.Params)request);
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    public String getName() {
        return "sql_clear_cursor";
    }
}

