/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.io.ansi;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiPrintStream;
import org.fusesource.jansi.AnsiType;
import org.fusesource.jansi.io.AnsiOutputStream;

public class AnsiConsoleLoader
implements Supplier<ConsoleLoader.Console> {
    private static final Logger logger = LogManager.getLogger(AnsiConsoleLoader.class);

    @Override
    public ConsoleLoader.Console get() {
        AnsiPrintStream out = AnsiConsole.out();
        return AnsiConsoleLoader.newConsole(out);
    }

    @Nullable
    static ConsoleLoader.Console newConsole(AnsiPrintStream out) {
        if (AnsiConsoleLoader.isValidConsole(out)) {
            boolean ansiEnabled = Ansi.isEnabled() && out.getType() != AnsiType.VirtualTerminal;
            return new ConsoleLoader.Console((PrintStream)out, () -> out.getTerminalWidth(), Boolean.valueOf(ansiEnabled), AnsiConsoleLoader.tryExtractPrintCharset(out));
        }
        return null;
    }

    private static boolean isValidConsole(AnsiPrintStream out) {
        return out != null && out.getType() != AnsiType.Redirected && out.getType() != AnsiType.Unsupported && out.getTerminalWidth() > 0;
    }

    @Nullable
    @SuppressForbidden(reason="Best effort exposing print stream's charset with reflection")
    private static Charset tryExtractPrintCharset(AnsiPrintStream ansiPrintStream) {
        try {
            Method getOutMethod = ansiPrintStream.getClass().getDeclaredMethod("getOut", new Class[0]);
            getOutMethod.setAccessible(true);
            AnsiOutputStream ansiOutputStream = (AnsiOutputStream)getOutMethod.invoke((Object)ansiPrintStream, new Object[0]);
            Field charsetField = ansiOutputStream.getClass().getDeclaredField("cs");
            charsetField.setAccessible(true);
            return (Charset)charsetField.get(ansiOutputStream);
        }
        catch (Throwable t) {
            logger.info("Failed to detect JANSI's print stream encoding", t);
            return null;
        }
    }
}

