/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.blobstore.testkit.integrity.IndexDescription;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record RepositoryVerifyIntegrityResponseChunk(long timestampMillis, Type type, @Nullable String anomaly, @Nullable SnapshotId snapshotId, @Nullable SnapshotInfo snapshotInfo, @Nullable IndexDescription indexDescription, int shardId, @Nullable ShardGeneration shardGeneration, @Nullable String blobName, @Nullable String physicalFileName, int partIndex, int partCount, ByteSizeValue fileLength, ByteSizeValue partLength, ByteSizeValue blobLength, int totalSnapshotCount, int restorableSnapshotCount, @Nullable Exception exception) implements Writeable,
ToXContentFragment
{
    public RepositoryVerifyIntegrityResponseChunk(long timestampMillis, Type type, @Nullable String anomaly, @Nullable SnapshotId snapshotId, @Nullable SnapshotInfo snapshotInfo, @Nullable IndexDescription indexDescription, int shardId, @Nullable ShardGeneration shardGeneration, @Nullable String blobName, @Nullable String physicalFileName, int partIndex, int partCount, ByteSizeValue fileLength, ByteSizeValue partLength, ByteSizeValue blobLength, int totalSnapshotCount, int restorableSnapshotCount, @Nullable Exception exception) {
        if (fileLength == null || partLength == null || blobLength == null || shardId < -1 || partIndex < -1 || partCount < -1 || totalSnapshotCount < -1 || restorableSnapshotCount < -1 || totalSnapshotCount >= 0 != restorableSnapshotCount >= 0) {
            throw new IllegalArgumentException("invalid: " + this);
        }
        this.timestampMillis = timestampMillis;
        this.type = type;
        this.anomaly = anomaly;
        this.snapshotId = snapshotId;
        this.snapshotInfo = snapshotInfo;
        this.indexDescription = indexDescription;
        this.shardId = shardId;
        this.shardGeneration = shardGeneration;
        this.blobName = blobName;
        this.physicalFileName = physicalFileName;
        this.partIndex = partIndex;
        this.partCount = partCount;
        this.fileLength = fileLength;
        this.partLength = partLength;
        this.blobLength = blobLength;
        this.totalSnapshotCount = totalSnapshotCount;
        this.restorableSnapshotCount = restorableSnapshotCount;
        this.exception = exception;
    }

    public RepositoryVerifyIntegrityResponseChunk(StreamInput in) throws IOException {
        this(in.readVLong(), (Type)in.readEnum(Type.class), in.readOptionalString(), (SnapshotId)in.readOptionalWriteable(SnapshotId::new), (SnapshotInfo)in.readOptionalWriteable(SnapshotInfo::readFrom), (IndexDescription)in.readOptionalWriteable(IndexDescription::new), in.readInt(), (ShardGeneration)in.readOptionalWriteable(ShardGeneration::new), in.readOptionalString(), in.readOptionalString(), in.readInt(), in.readInt(), ByteSizeValue.readFrom((StreamInput)in), ByteSizeValue.readFrom((StreamInput)in), ByteSizeValue.readFrom((StreamInput)in), in.readInt(), in.readInt(), (Exception)in.readOptional(StreamInput::readException));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestampMillis);
        out.writeEnum((Enum)this.type);
        out.writeOptionalString(this.anomaly);
        out.writeOptionalWriteable((Writeable)this.snapshotId);
        out.writeOptionalWriteable((Writeable)this.snapshotInfo);
        out.writeOptionalWriteable((Writeable)this.indexDescription);
        out.writeInt(this.shardId);
        out.writeOptionalWriteable((Writeable)this.shardGeneration);
        out.writeOptionalString(this.blobName);
        out.writeOptionalString(this.physicalFileName);
        out.writeInt(this.partIndex);
        out.writeInt(this.partCount);
        this.fileLength.writeTo(out);
        this.partLength.writeTo(out);
        this.blobLength.writeTo(out);
        out.writeInt(this.totalSnapshotCount);
        out.writeInt(this.restorableSnapshotCount);
        out.writeOptional(StreamOutput::writeException, (Object)this.exception);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.timestampFieldsFromUnixEpochMillis("timestamp_in_millis", "timestamp", this.timestampMillis);
        if (this.anomaly() != null) {
            builder.field("anomaly", this.anomaly());
        }
        if (this.snapshotInfo() != null) {
            builder.field("snapshot");
            this.snapshotInfo().toXContentExternal(builder, params);
        } else if (this.snapshotId() != null) {
            builder.startObject("snapshot");
            builder.field("snapshot", this.snapshotId().getName());
            builder.field("uuid", this.snapshotId().getUUID());
            builder.endObject();
        }
        if (this.indexDescription() != null) {
            builder.field("index", (ToXContent)this.indexDescription(), params);
        }
        if (this.shardId() >= 0) {
            builder.field("shard_id", this.shardId());
        }
        if (this.shardGeneration() != null) {
            builder.field("shard_generation", (ToXContent)this.shardGeneration(), params);
        }
        if (this.blobName() != null) {
            builder.field("blob_name", this.blobName());
        }
        if (this.physicalFileName() != null) {
            builder.field("physical_file_name", this.physicalFileName());
        }
        if (this.partIndex() >= 0) {
            builder.field("part_index", this.partIndex());
        }
        if (this.partCount() >= 0) {
            builder.field("part_count", this.partCount());
        }
        if (this.fileLength() != ByteSizeValue.MINUS_ONE) {
            builder.humanReadableField("file_length_in_bytes", "file_length", (Object)this.fileLength());
        }
        if (this.partLength() != ByteSizeValue.MINUS_ONE) {
            builder.humanReadableField("part_length_in_bytes", "part_length", (Object)this.partLength());
        }
        if (this.blobLength() != ByteSizeValue.MINUS_ONE) {
            builder.humanReadableField("blob_length_in_bytes", "blob_length", (Object)this.blobLength());
        }
        if (this.totalSnapshotCount() >= 0 && this.restorableSnapshotCount() >= 0) {
            builder.startObject("snapshot_restorability");
            builder.field("total_snapshot_count", this.totalSnapshotCount());
            builder.field("restorable_snapshot_count", this.restorableSnapshotCount());
            builder.endObject();
        }
        if (this.exception() != null) {
            builder.startObject("exception").value((bb, pp) -> ElasticsearchException.generateFailureXContent((XContentBuilder)bb, (ToXContent.Params)pp, (Exception)this.exception(), (boolean)true)).field("status", (Enum)ExceptionsHelper.status((Throwable)this.exception())).endObject();
        }
        return builder;
    }

    public static enum Type {
        START_RESPONSE,
        SNAPSHOT_INFO,
        INDEX_RESTORABILITY,
        ANOMALY;

    }

    static interface Writer {
        public void writeResponseChunk(RepositoryVerifyIntegrityResponseChunk var1, ActionListener<Void> var2);
    }

    static class Builder {
        private final Writer responseWriter;
        private final Type type;
        private final long timestampMillis;
        private String anomaly;
        private SnapshotId snapshotId;
        private SnapshotInfo snapshotInfo;
        private IndexDescription indexDescription;
        private int shardId = -1;
        private ShardGeneration shardGeneration;
        private String blobName;
        private String physicalFileName;
        private int partIndex = -1;
        private int partCount = -1;
        private ByteSizeValue fileLength = ByteSizeValue.MINUS_ONE;
        private ByteSizeValue partLength = ByteSizeValue.MINUS_ONE;
        private ByteSizeValue blobLength = ByteSizeValue.MINUS_ONE;
        private int totalSnapshotCount = -1;
        private int restorableSnapshotCount = -1;
        private Exception exception;

        Builder(Writer responseWriter, Type type, long timestampMillis) {
            this.responseWriter = responseWriter;
            this.type = type;
            this.timestampMillis = timestampMillis;
        }

        Builder anomaly(String anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        Builder snapshotId(SnapshotId snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        Builder snapshotInfo(SnapshotInfo snapshotInfo) {
            this.snapshotInfo = snapshotInfo;
            return this;
        }

        Builder indexDescription(IndexDescription indexDescription) {
            this.indexDescription = indexDescription;
            return this;
        }

        Builder shardDescription(IndexDescription indexDescription, int shardId) {
            this.indexDescription = indexDescription;
            this.shardId = shardId;
            return this;
        }

        Builder shardGeneration(ShardGeneration shardGeneration) {
            this.shardGeneration = shardGeneration;
            return this;
        }

        Builder blobName(String blobName, String physicalFileName) {
            this.blobName = blobName;
            this.physicalFileName = physicalFileName;
            return this;
        }

        Builder physicalFileName(String physicalFileName) {
            this.physicalFileName = physicalFileName;
            return this;
        }

        Builder part(int partIndex, int partCount) {
            this.partIndex = partIndex;
            this.partCount = partCount;
            return this;
        }

        Builder fileLength(ByteSizeValue fileLength) {
            this.fileLength = Objects.requireNonNull(fileLength);
            return this;
        }

        Builder partLength(ByteSizeValue partLength) {
            this.partLength = Objects.requireNonNull(partLength);
            return this;
        }

        Builder blobLength(ByteSizeValue blobLength) {
            this.blobLength = Objects.requireNonNull(blobLength);
            return this;
        }

        Builder indexRestorability(IndexId indexId, int totalSnapshotCount, int restorableSnapshotCount) {
            this.indexDescription = new IndexDescription(indexId, null, 0);
            this.totalSnapshotCount = totalSnapshotCount;
            this.restorableSnapshotCount = restorableSnapshotCount;
            return this;
        }

        Builder exception(Exception exception) {
            this.exception = exception;
            return this;
        }

        void write(ActionListener<Void> listener) {
            this.responseWriter.writeResponseChunk(new RepositoryVerifyIntegrityResponseChunk(this.timestampMillis, this.type, this.anomaly, this.snapshotId, this.snapshotInfo, this.indexDescription, this.shardId, this.shardGeneration, this.blobName, this.physicalFileName, this.partIndex, this.partCount, this.fileLength, this.partLength, this.blobLength, this.totalSnapshotCount, this.restorableSnapshotCount, this.exception), (ActionListener<Void>)ActionListener.assertOnce(listener));
        }
    }
}

