/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.persistence;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.profiling.persistence.AbstractProfilingPersistenceManager;
import org.elasticsearch.xpack.profiling.persistence.IndexState;
import org.elasticsearch.xpack.profiling.persistence.IndexStateResolver;
import org.elasticsearch.xpack.profiling.persistence.IndexStatus;
import org.elasticsearch.xpack.profiling.persistence.Migration;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexAbstraction;

public class ProfilingIndexManager
extends AbstractProfilingPersistenceManager<ProfilingIndex> {
    public static final List<ProfilingIndex> PROFILING_INDICES = List.of(ProfilingIndex.regular("profiling-returnpads-private", 1, OnVersionBump.KEEP_OLD), ProfilingIndex.regular("profiling-sq-executables", 1, OnVersionBump.DELETE_OLD), ProfilingIndex.regular("profiling-sq-leafframes", 1, OnVersionBump.DELETE_OLD), ProfilingIndex.regular("profiling-symbols-private", 1, OnVersionBump.KEEP_OLD), ProfilingIndex.kv("profiling-executables", 1), ProfilingIndex.kv("profiling-stackframes", 1), ProfilingIndex.kv("profiling-stacktraces", 1), ProfilingIndex.kv("profiling-symbols-global", 1));

    public ProfilingIndexManager(ThreadPool threadPool, Client client, ClusterService clusterService, IndexStateResolver indexStateResolver) {
        super(threadPool, client, clusterService, indexStateResolver);
    }

    @Override
    protected void onIndexState(ClusterState clusterState, IndexState<ProfilingIndex> indexState, ActionListener<? super ActionResponse> listener) {
        IndexStatus status = indexState.getStatus();
        switch (status) {
            case NEEDS_CREATION: {
                this.createIndex(clusterState, indexState.getIndex(), listener);
                break;
            }
            case NEEDS_VERSION_BUMP: {
                this.bumpVersion(clusterState, indexState.getIndex(), listener);
                break;
            }
            case NEEDS_MAPPINGS_UPDATE: {
                this.applyMigrations(indexState, listener);
                break;
            }
            default: {
                this.logger.trace("Skipping status change [{}] for index [{}].", (Object)status, (Object)indexState.getIndex());
                listener.onResponse(null);
            }
        }
    }

    private void bumpVersion(ClusterState state, ProfilingIndex index, ActionListener<? super ActionResponse> listener) {
        if (index.getOnVersionBump() == OnVersionBump.DELETE_OLD) {
            Map indicesMetadata = state.metadata().indices();
            List<String> priorIndexVersions = indicesMetadata.keySet().stream().filter(Predicate.not(index::isFullMatch)).filter(index::isMatchWithoutVersion).toList();
            if (!priorIndexVersions.isEmpty()) {
                this.logger.debug("deleting indices [{}] on index version bump for [{}].", priorIndexVersions, (Object)index.getAlias());
                this.deleteIndices(priorIndexVersions.toArray(new String[0]), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> this.putIndex(index.getName(), index.getAlias(), listener), arg_0 -> listener.onFailure(arg_0)));
            } else {
                this.createIndex(state, index, listener);
            }
        } else {
            this.createIndex(state, index, listener);
        }
    }

    @Override
    protected Iterable<ProfilingIndex> getManagedIndices() {
        return PROFILING_INDICES;
    }

    private void onCreateIndexFailure(String index, Exception ex) {
        this.logger.error(() -> Strings.format((String)"error adding index [%s] for [%s]", (Object[])new Object[]{index, "profiling"}), (Throwable)ex);
    }

    private void createIndex(ClusterState state, ProfilingIndex index, ActionListener<? super ActionResponse> listener) {
        if (state.metadata().hasAlias(index.getAlias())) {
            this.rolloverIndex(index.getName(), index.getAlias(), listener);
        } else {
            this.putIndex(index.getName(), index.getAlias(), listener);
        }
    }

    private void rolloverIndex(final String newIndex, final String alias, final ActionListener<? super ActionResponse> listener) {
        this.logger.debug("rolling over to index [{}] for alias [{}].", (Object)newIndex, (Object)alias);
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            RolloverRequest request = new RolloverRequest(alias, newIndex);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"profiling", (Object)request, (ActionListener)new ActionListener<RolloverResponse>(){

                public void onResponse(RolloverResponse response) {
                    if (!response.isAcknowledged()) {
                        ProfilingIndexManager.this.logger.error("error rolling over index [{}] for [{}], request was not acknowledged", (Object)newIndex, (Object)"profiling");
                    } else if (!response.isShardsAcknowledged()) {
                        ProfilingIndexManager.this.logger.warn("rolling over index [{}] for [{}], shards were not acknowledged", (Object)newIndex, (Object)"profiling");
                    } else if (!response.isRolledOver()) {
                        ProfilingIndexManager.this.logger.warn("could not rollover alias [{}] to index [{}] for [{}].", (Object)alias, (Object)newIndex, (Object)"profiling");
                    } else {
                        ProfilingIndexManager.this.logger.debug("rolled over alias [{}] from [{}] to index [{}] for [{}].", (Object)alias, (Object)response.getOldIndex(), (Object)response.getNewIndex(), (Object)"profiling");
                    }
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    ProfilingIndexManager.this.onCreateIndexFailure(newIndex, e);
                    listener.onFailure(e);
                }
            }, (req, l) -> this.client.admin().indices().rolloverIndex(req, l));
        });
    }

    private void putIndex(final String index, String alias, final ActionListener<? super ActionResponse> listener) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            CreateIndexRequest request = new CreateIndexRequest(index);
            if (alias != null) {
                try {
                    Map<String, Map<String, Map<String, Boolean>>> sourceAsMap = Map.of("aliases", Map.of(alias, Map.of("is_write_index", true)));
                    request.source(sourceAsMap, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
                }
                catch (Exception ex) {
                    this.onCreateIndexFailure(index, ex);
                    listener.onFailure(ex);
                    return;
                }
            }
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"profiling", (Object)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    if (!response.isAcknowledged()) {
                        ProfilingIndexManager.this.logger.error("error adding index [{}] for [{}], request was not acknowledged", (Object)index, (Object)"profiling");
                    } else if (!response.isShardsAcknowledged()) {
                        ProfilingIndexManager.this.logger.warn("adding index [{}] for [{}], shards were not acknowledged", (Object)index, (Object)"profiling");
                    }
                    listener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    ProfilingIndexManager.this.onCreateIndexFailure(index, e);
                    listener.onFailure(e);
                }
            }, (req, l) -> this.client.admin().indices().create(req, l));
        });
    }

    private void deleteIndices(String[] indices, ActionListener<AcknowledgedResponse> listener) {
        DeleteIndexRequest request = new DeleteIndexRequest(indices);
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        this.executeAsync("delete", request, listener, (req, l) -> this.client.admin().indices().delete(req, l));
    }

    public static boolean isAllResourcesCreated(ClusterState state, IndexStateResolver indexStateResolver) {
        for (ProfilingIndex profilingIndex : PROFILING_INDICES) {
            if (indexStateResolver.getIndexState(state, profilingIndex).getStatus() == IndexStatus.UP_TO_DATE) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyResourceTooOld(ClusterState state, IndexStateResolver indexStateResolver) {
        for (ProfilingIndex profilingIndex : PROFILING_INDICES) {
            if (indexStateResolver.getIndexState(state, profilingIndex).getStatus() != IndexStatus.TOO_OLD) continue;
            return true;
        }
        return false;
    }

    public static class ProfilingIndex
    implements ProfilingIndexAbstraction {
        private final String namePrefix;
        private final int version;
        private final String generation;
        private final OnVersionBump onVersionBump;
        private final List<Migration> migrations;

        static ProfilingIndex regular(String name, int version, OnVersionBump onVersionBump) {
            return ProfilingIndex.regular(name, version, onVersionBump, null);
        }

        static ProfilingIndex regular(String name, int version, OnVersionBump onVersionBump, Migration.Builder builder) {
            List<Migration> migrations = builder != null ? builder.build(version) : null;
            return new ProfilingIndex(name, version, null, onVersionBump, migrations);
        }

        static ProfilingIndex kv(String name, int version) {
            return ProfilingIndex.kv(name, version, null);
        }

        static ProfilingIndex kv(String name, int version, Migration.Builder builder) {
            List<Migration> migrations = builder != null ? builder.build(version) : null;
            return new ProfilingIndex(name, version, "000001", OnVersionBump.KEEP_OLD, migrations);
        }

        private ProfilingIndex(String namePrefix, int version, String generation, OnVersionBump onVersionBump, List<Migration> migrations) {
            this.namePrefix = namePrefix;
            this.version = version;
            this.generation = generation;
            this.onVersionBump = onVersionBump;
            this.migrations = migrations;
        }

        public ProfilingIndex withVersion(int version) {
            return new ProfilingIndex(this.namePrefix, version, this.generation, this.onVersionBump, this.migrations);
        }

        public ProfilingIndex withGeneration(String generation) {
            return new ProfilingIndex(this.namePrefix, this.version, generation, this.onVersionBump, this.migrations);
        }

        public boolean isMatchWithoutVersion(String indexName) {
            String expectedPrefix = "." + this.namePrefix + "-v";
            return indexName.startsWith(expectedPrefix) && this.isVersionNumber(indexName, expectedPrefix.length());
        }

        private boolean isVersionNumber(String name, int startIndex) {
            int versionNumberLength = 3;
            String versionNumberCandidate = name.substring(startIndex, Math.min(startIndex + 3, name.length()));
            return versionNumberCandidate.length() == 3 && versionNumberCandidate.chars().allMatch(c -> 48 <= c && c <= 57);
        }

        public boolean isMatchWithoutGeneration(String indexName) {
            return indexName.startsWith(this.indexPrefix());
        }

        public boolean isFullMatch(String indexName) {
            return this.toString().equals(indexName);
        }

        public boolean isKvIndex() {
            return this.generation != null;
        }

        public String getAlias() {
            return this.namePrefix;
        }

        @Override
        public String getName() {
            return this.isKvIndex() ? String.format(Locale.ROOT, "%s-%s", this.indexPrefix(), this.generation) : this.indexPrefix();
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public List<Migration> getMigrations(int currentIndexTemplateVersion) {
            return this.migrations != null ? this.migrations.stream().filter(m -> m.getTargetIndexTemplateVersion() > currentIndexTemplateVersion).toList() : Collections.emptyList();
        }

        @Override
        public IndexMetadata indexMetadata(ClusterState state) {
            Map indicesMetadata = state.metadata().indices();
            if (indicesMetadata == null) {
                return null;
            }
            IndexMetadata metadata = (IndexMetadata)indicesMetadata.get(this.toString());
            if (metadata == null && this.isKvIndex()) {
                metadata = indicesMetadata.entrySet().stream().filter(e -> this.isMatchWithoutGeneration((String)e.getKey())).max(Comparator.comparingLong(e -> ((IndexMetadata)e.getValue()).getCreationDate())).map(Map.Entry::getValue).orElse(null);
            }
            if (metadata == null) {
                metadata = indicesMetadata.entrySet().stream().filter(e -> this.isMatchWithoutVersion((String)e.getKey())).max(Comparator.comparingLong(e -> ((IndexMetadata)e.getValue()).getCreationDate())).map(Map.Entry::getValue).orElse(null);
            }
            return metadata;
        }

        public OnVersionBump getOnVersionBump() {
            return this.onVersionBump;
        }

        private String indexPrefix() {
            return String.format(Locale.ROOT, ".%s-v%03d", this.namePrefix, this.version);
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfilingIndex index = (ProfilingIndex)o;
            return this.version == index.version && Objects.equals(this.namePrefix, index.namePrefix) && Objects.equals(this.generation, index.generation) && this.onVersionBump == index.onVersionBump;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.namePrefix, this.version, this.generation, this.onVersionBump});
        }
    }

    public static enum OnVersionBump {
        DELETE_OLD,
        KEEP_OLD;

    }
}

