/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.persistence;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.profiling.persistence.IndexState;
import org.elasticsearch.xpack.profiling.persistence.IndexStateResolver;
import org.elasticsearch.xpack.profiling.persistence.IndexStatus;
import org.elasticsearch.xpack.profiling.persistence.Migration;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexAbstraction;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexTemplateRegistry;

abstract class AbstractProfilingPersistenceManager<T extends ProfilingIndexAbstraction>
implements ClusterStateListener,
Closeable {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final ClusterService clusterService;
    protected final ThreadPool threadPool;
    protected final Client client;
    private final IndexStateResolver indexStateResolver;
    private volatile boolean templatesEnabled;

    AbstractProfilingPersistenceManager(ThreadPool threadPool, Client client, ClusterService clusterService, IndexStateResolver indexStateResolver) {
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService = clusterService;
        this.indexStateResolver = indexStateResolver;
    }

    public void initialize() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    @Override
    public void close() {
        this.clusterService.removeListener((ClusterStateListener)this);
    }

    public void setTemplatesEnabled(boolean templatesEnabled) {
        this.templatesEnabled = templatesEnabled;
    }

    private static boolean isMixedVersionCluster(DiscoveryNodes nodes) {
        Version version = null;
        for (DiscoveryNode n : nodes) {
            if (version == null) {
                version = n.getVersion();
                continue;
            }
            if (version.equals((Object)n.getVersion())) continue;
            return true;
        }
        return false;
    }

    public final void clusterChanged(ClusterChangedEvent event) {
        if (!this.templatesEnabled) {
            return;
        }
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (AbstractProfilingPersistenceManager.isMixedVersionCluster(event.state().nodes())) {
            this.logger.debug("Skipping up-to-date check as cluster has mixed versions");
            return;
        }
        if (!this.areAllIndexTemplatesCreated(event, this.clusterService.getSettings())) {
            this.logger.trace("Skipping index creation; not all required resources are present yet");
            return;
        }
        if (!this.inProgress.compareAndSet(false, true)) {
            this.logger.trace("Skipping index creation as changes are already in progress");
            return;
        }
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> this.inProgress.set(false));){
            ClusterState clusterState = event.state();
            for (ProfilingIndexAbstraction index : this.getManagedIndices()) {
                IndexState<ProfilingIndexAbstraction> state = this.indexStateResolver.getIndexState(clusterState, index);
                if (state.getStatus().actionable) {
                    this.onIndexState(clusterState, state, (ActionListener<ActionResponse>)ActionListener.releasing((Releasable)refs.acquire()));
                    continue;
                }
                if (state.getStatus() != IndexStatus.TOO_OLD) continue;
                this.logger.info("Aborting index creation as index [{}] is considered too old.", (Object)index);
                return;
            }
        }
    }

    protected boolean areAllIndexTemplatesCreated(ClusterChangedEvent event, Settings settings) {
        return ProfilingIndexTemplateRegistry.isAllResourcesCreated(event.state(), settings);
    }

    protected abstract Iterable<T> getManagedIndices();

    protected abstract void onIndexState(ClusterState var1, IndexState<T> var2, ActionListener<? super ActionResponse> var3);

    protected final void applyMigrations(IndexState<T> indexState, ActionListener<? super ActionResponse> listener) {
        String writeIndex = indexState.getWriteIndex().getName();
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> listener.onResponse(null));){
            for (Migration migration : indexState.getPendingMigrations()) {
                this.logger.debug("Applying migration [{}] for [{}].", (Object)migration, (Object)writeIndex);
                migration.apply(writeIndex, r -> this.updateMapping((PutMappingRequest)r, (ActionListener<AcknowledgedResponse>)ActionListener.releasing((Releasable)refs.acquire())), r -> this.updateSettings((UpdateSettingsRequest)r, (ActionListener<AcknowledgedResponse>)ActionListener.releasing((Releasable)refs.acquire())));
            }
        }
    }

    protected final void updateMapping(PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        this.executeAsync("put mapping", request, listener, (req, l) -> this.client.admin().indices().putMapping(req, l));
    }

    protected final void updateSettings(UpdateSettingsRequest request, ActionListener<AcknowledgedResponse> listener) {
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        this.executeAsync("update settings", request, listener, (req, l) -> this.client.admin().indices().updateSettings(req, l));
    }

    protected final <Request extends ActionRequest, Response extends AcknowledgedResponse> void executeAsync(final String actionName, final Request request, final ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"profiling", (Object)request, (ActionListener)new ActionListener<Response>(){

            public void onResponse(Response response) {
                if (!response.isAcknowledged()) {
                    AbstractProfilingPersistenceManager.this.logger.error("Could not execute action [{}] for indices [{}] for [{}], request was not acknowledged", (Object)actionName, (Object)((IndicesRequest)request).indices(), (Object)"profiling");
                }
                listener.onResponse(response);
            }

            public void onFailure(Exception ex) {
                AbstractProfilingPersistenceManager.this.logger.error(() -> Strings.format((String)"Could not execute action [%s] for indices [%s] for [%s]", (Object[])new Object[]{actionName, ((IndicesRequest)request).indices(), "profiling"}), (Throwable)ex);
                listener.onFailure(ex);
            }
        }, (BiConsumer)consumer));
    }
}

