/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;

public class LongCounterAdapter
extends AbstractInstrument<LongCounter>
implements org.elasticsearch.telemetry.metric.LongCounter {
    public LongCounterAdapter(Meter meter, String name, String description, String unit) {
        super(meter, new Builder(name, description, unit));
    }

    public void increment() {
        ((LongCounter)this.getInstrument()).add(1L);
    }

    public void incrementBy(long inc) {
        assert (inc >= 0L);
        ((LongCounter)this.getInstrument()).add(inc);
    }

    public void incrementBy(long inc, Map<String, Object> attributes) {
        assert (inc >= 0L);
        ((LongCounter)this.getInstrument()).add(inc, OtelHelper.fromMap(attributes));
    }

    private static class Builder
    extends AbstractInstrument.Builder<LongCounter> {
        private Builder(String name, String description, String unit) {
            super(name, description, unit);
        }

        @Override
        public LongCounter build(Meter meter) {
            return Objects.requireNonNull(meter).counterBuilder(this.name).setDescription(this.description).setUnit(this.unit).build();
        }
    }
}

