/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class LogsStreamsActivationToggleAction {
    public static ActionType<AcknowledgedResponse> INSTANCE = new ActionType("cluster:admin/streams/logs/toggle");

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final boolean enable;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, boolean enable) {
            super(masterNodeTimeout, ackTimeout);
            this.enable = enable;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.enable = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.enable);
        }

        public String toString() {
            return "LogsStreamsActivationToggleAction.Request{enable=" + this.enable + "}";
        }

        public boolean shouldEnable() {
            return this.enable;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "Logs streams activation toggle request", parentTaskId, headers);
        }
    }
}

