/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.linear;

import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xpack.rank.linear.ScoreNormalizer;

public class MinMaxScoreNormalizer
extends ScoreNormalizer {
    public static final MinMaxScoreNormalizer INSTANCE = new MinMaxScoreNormalizer();
    public static final NodeFeature LINEAR_RETRIEVER_MINMAX_SINGLE_DOC_FIX = new NodeFeature("linear_retriever.minmax_single_doc_fix");
    public static final String NAME = "minmax";
    private static final float EPSILON = 1.0E-6f;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ScoreDoc[] normalizeScores(ScoreDoc[] docs) {
        if (docs.length == 0) {
            return docs;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[docs.length];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        boolean atLeastOneValidScore = false;
        for (ScoreDoc rd : docs) {
            if (!atLeastOneValidScore && !Float.isNaN(rd.score)) {
                atLeastOneValidScore = true;
            }
            if (rd.score > max) {
                max = rd.score;
            }
            if (!(rd.score < min)) continue;
            min = rd.score;
        }
        if (!atLeastOneValidScore) {
            return docs;
        }
        boolean minEqualsMax = Math.abs(min - max) < 1.0E-6f;
        for (int i = 0; i < docs.length; ++i) {
            float score = minEqualsMax ? 1.0f : (docs[i].score - min) / (max - min);
            scoreDocs[i] = new ScoreDoc(docs[i].doc, score, docs[i].shardIndex);
        }
        return scoreDocs;
    }
}

