/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class URLDecodeProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "urldecode";

    URLDecodeProcessor(String processorTag, String description, String field, boolean ignoreMissing, String targetField) {
        super(processorTag, description, ignoreMissing, targetField, field);
    }

    public static String apply(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    @Override
    protected String process(String value) {
        return URLDecodeProcessor.apply(value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(URLDecodeProcessor.TYPE);
        }

        protected URLDecodeProcessor newProcessor(String tag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new URLDecodeProcessor(tag, description, field, ignoreMissing, targetField);
        }
    }
}

